/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img;

import ch.epfl.biop.bdv.img.OpenersImageLoader;
import ch.epfl.biop.bdv.img.entity.ImageName;
import ch.epfl.biop.bdv.img.opener.ChannelProperties;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import mpicbg.spim.data.SpimData;
import mpicbg.spim.data.generic.AbstractSpimData;
import mpicbg.spim.data.generic.base.Entity;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.BasicImgLoader;
import mpicbg.spim.data.registration.ViewRegistration;
import mpicbg.spim.data.registration.ViewRegistrations;
import mpicbg.spim.data.sequence.Angle;
import mpicbg.spim.data.sequence.Channel;
import mpicbg.spim.data.sequence.Illumination;
import mpicbg.spim.data.sequence.MissingViews;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.data.sequence.Tile;
import mpicbg.spim.data.sequence.TimePoint;
import mpicbg.spim.data.sequence.TimePoints;
import mpicbg.spim.data.sequence.ViewId;
import mpicbg.spim.data.sequence.ViewSetup;
import mpicbg.spim.data.sequence.VoxelDimensions;
import net.imglib2.Dimensions;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.type.numeric.ARGBType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import spimdata.util.Displaysettings;

public class OpenersToSpimData {
    protected static final Logger logger = LoggerFactory.getLogger(OpenersToSpimData.class);
    int viewSetupCounter = 0;
    int nTileCounter = 0;
    final Map<Integer, OpenerChannel> viewSetupToFileChannel = new HashMap<Integer, OpenerChannel>();
    int channelCounter = 0;
    final Map<Integer, Channel> channelIdToChannel = new HashMap<Integer, Channel>();
    final Map<ChannelProperties, Integer> channelToId = new HashMap<ChannelProperties, Integer>();
    int maxTimepoints = -1;

    protected AbstractSpimData<?> getSpimDataInstance(List<OpenerSettings> openerSettings) {
        Illumination dummy_ill = new Illumination(0);
        Angle dummy_ang = new Angle(0);
        ArrayList viewSetups = new ArrayList();
        List<Opener<?>> openers = OpenersImageLoader.createOpeners(openerSettings);
        try {
            for (int iOpener = 0; iOpener < openerSettings.size(); ++iOpener) {
                int iOpener_final = iOpener;
                Opener<?> opener = openers.get(iOpener);
                Tile tile = new Tile(this.nTileCounter);
                ++this.nTileCounter;
                if (opener.getNTimePoints() > this.maxTimepoints) {
                    this.maxTimepoints = opener.getNTimePoints();
                }
                Dimensions dims = opener.getDimensions()[0];
                logger.debug("X:" + dims.dimension(0) + " Y:" + dims.dimension(1) + " Z:" + dims.dimension(2));
                VoxelDimensions voxDims = opener.getVoxelDimensions();
                IntStream channels = IntStream.range(0, opener.getNChannels());
                logger.debug("There are " + opener.getNChannels() + " channels.");
                ImageName imageName = new ImageName(iOpener, opener.getMeta().getImageName());
                channels.forEach(iCh -> {
                    ChannelProperties channelProperties = opener.getMeta().getChannel(iCh);
                    String setupName = opener.getMeta().getImageName() + "-" + channelProperties.getChannelName();
                    logger.debug("setup name : " + setupName);
                    ViewSetup vs = new ViewSetup(this.viewSetupCounter, setupName, dims, voxDims, tile, this.getChannelEntity(iCh, channelProperties), dummy_ang, dummy_ill);
                    Displaysettings ds = new Displaysettings(this.viewSetupCounter);
                    ds.min = channelProperties.getDisplayRangeMin();
                    ds.max = channelProperties.getDisplayRangeMax();
                    ds.isSet = false;
                    ARGBType color = channelProperties.getColor();
                    if (color != null) {
                        ds.isSet = true;
                        ds.color = new int[]{ARGBType.red((int)color.get()), ARGBType.green((int)color.get()), ARGBType.blue((int)color.get()), ARGBType.alpha((int)color.get())};
                    }
                    opener.getMeta().getEntities(iCh).forEach(arg_0 -> ((ViewSetup)vs).setAttribute(arg_0));
                    vs.setAttribute((Entity)ds);
                    vs.setAttribute((Entity)imageName);
                    viewSetups.add(vs);
                    this.viewSetupToFileChannel.put(this.viewSetupCounter, new OpenerChannel(iOpener_final, iCh));
                    ++this.viewSetupCounter;
                });
            }
            ArrayList timePoints = new ArrayList();
            IntStream.range(0, this.maxTimepoints).forEach(tp -> timePoints.add(new TimePoint(tp)));
            ArrayList registrations = new ArrayList();
            ArrayList missingViews = new ArrayList();
            for (int iF = 0; iF < openers.size(); ++iF) {
                int iFile = iF;
                Opener<?> opener = openers.get(iF);
                int nTimePoints = opener.getNTimePoints();
                AffineTransform3D rootTransform = opener.getMeta().getTransform();
                timePoints.forEach(iTp -> this.viewSetupToFileChannel.keySet().stream().filter(viewSetupId -> this.viewSetupToFileChannel.get((Object)viewSetupId).iOpener == iFile).forEach(viewSetupId -> {
                    if (iTp.getId() < nTimePoints) {
                        registrations.add(new ViewRegistration(iTp.getId(), viewSetupId.intValue(), rootTransform));
                    } else {
                        missingViews.add(new ViewId(iTp.getId(), viewSetupId.intValue()));
                    }
                }));
            }
            SequenceDescription sd = new SequenceDescription(new TimePoints(timePoints), viewSetups, null, new MissingViews(missingViews));
            sd.setImgLoader((BasicImgLoader)new OpenersImageLoader(openerSettings, openers, (AbstractSequenceDescription<?, ?, ?>)sd));
            return new SpimData((File)null, sd, new ViewRegistrations(registrations));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Channel getChannelEntity(int iChannel, ChannelProperties channelProperties) {
        if (!this.channelToId.containsKey(channelProperties)) {
            this.channelToId.put(channelProperties, this.channelCounter);
            logger.debug("New Channel " + iChannel + ", set as number " + this.channelCounter);
            this.channelIdToChannel.put(this.channelCounter, new Channel(this.channelCounter, channelProperties.getChannelName()));
            ++this.channelCounter;
        } else {
            logger.debug("Channel " + iChannel + ", already known.");
        }
        return this.channelIdToChannel.get(this.channelToId.get(channelProperties));
    }

    public static AbstractSpimData<?> getSpimData(List<OpenerSettings> openersSettings) {
        return new OpenersToSpimData().getSpimDataInstance(openersSettings);
    }

    public static AbstractSpimData<?> getSpimData(OpenerSettings openerSetting) {
        ArrayList<OpenerSettings> singleOpenerList = new ArrayList<OpenerSettings>();
        singleOpenerList.add(openerSetting);
        return OpenersToSpimData.getSpimData(singleOpenerList);
    }

    static class OpenerChannel {
        public final int iOpener;
        public final int iChannel;

        public OpenerChannel(int iF, int iC) {
            this.iOpener = iF;
            this.iChannel = iC;
        }
    }
}

