/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop.bdv.img;

import bdv.ViewerImgLoader;
import bdv.cache.SharedQueue;
import bdv.img.cache.VolatileGlobalCellCache;
import ch.epfl.biop.bdv.img.CacheControlOverride;
import ch.epfl.biop.bdv.img.OpenerSetupLoader;
import ch.epfl.biop.bdv.img.opener.EmptyOpener;
import ch.epfl.biop.bdv.img.opener.Opener;
import ch.epfl.biop.bdv.img.opener.OpenerSettings;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.IntStream;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.MultiResolutionImgLoader;
import net.imglib2.cache.queue.BlockingFetchQueues;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenersImageLoader
implements ViewerImgLoader,
MultiResolutionImgLoader,
Closeable,
CacheControlOverride {
    protected static final Logger logger = LoggerFactory.getLogger(OpenersImageLoader.class);
    final AbstractSequenceDescription<?, ?, ?> sequenceDescription;
    final Map<Integer, OpenerAndChannelIndex> viewSetupToOpenerChannel = new HashMap<Integer, OpenerAndChannelIndex>();
    int viewSetupCounter = 0;
    final Map<Integer, OpenerSetupLoader<?, ?, ?>> setupLoaders = new HashMap();
    final Map<String, Opener<?>> rawPixelDataChannelToOpener = new HashMap();
    final Map<String, OpenerSetupLoader<?, ?, ?>> rawPixelDataChannelToSetupLoader = new HashMap();
    protected VolatileGlobalCellCache cache;
    protected final SharedQueue sq;
    public final int numFetcherThreads = 10;
    public final int numPriorities = 4;
    final List<OpenerSettings> openerSettings;
    public final List<Opener<?>> openers;

    public List<OpenerSettings> getOpenerSettings() {
        return this.openerSettings;
    }

    public Map<Integer, OpenerAndChannelIndex> getViewSetupToOpenerAndChannelIndex() {
        return this.viewSetupToOpenerChannel;
    }

    public OpenersImageLoader(List<OpenerSettings> openerSettings, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this(openerSettings, OpenersImageLoader.createOpeners(openerSettings), sequenceDescription);
    }

    public OpenersImageLoader(List<OpenerSettings> openerSettings, List<Opener<?>> openers, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        this.openerSettings = openerSettings;
        this.openers = openers;
        this.sequenceDescription = sequenceDescription;
        this.sq = new SharedQueue(10, 4);
        IntStream openersIdxStream = IntStream.range(0, openers.size());
        if (sequenceDescription != null) {
            openersIdxStream.forEach(iF -> {
                try {
                    Opener opener = (Opener)openers.get(iF);
                    int iFile = iF;
                    logger.debug("\t Number of timesteps = " + opener.getNTimePoints());
                    logger.debug("\t Number of channels = " + opener.getNChannels());
                    IntStream channels = IntStream.range(0, opener.getNChannels());
                    channels.forEach(iCh -> {
                        this.rawPixelDataChannelToOpener.put(iCh + "." + opener.getRawPixelDataKey(), opener);
                        OpenerAndChannelIndex oci = new OpenerAndChannelIndex(iFile, iCh);
                        this.viewSetupToOpenerChannel.put(this.viewSetupCounter, oci);
                        ++this.viewSetupCounter;
                    });
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            });
        }
        this.cache = new VolatileGlobalCellCache((BlockingFetchQueues)this.sq);
    }

    public static List<Opener<?>> createOpeners(List<OpenerSettings> openerSettings) {
        ArrayList openers = new ArrayList();
        HashMap cachedObjects = new HashMap();
        openerSettings.forEach(settings -> {
            try {
                Opener<?> opener = settings.create(cachedObjects);
                openers.add(opener);
            }
            catch (Exception e) {
                System.err.println("Error in opener " + e.getMessage() + " : " + settings.toString());
                logger.error(e.getMessage());
                e.printStackTrace();
                int nChannels = settings.getNChannels() > 0 ? settings.getNChannels() : 1;
                openers.add(new EmptyOpener(e.getMessage(), nChannels, e.getMessage(), false));
            }
        });
        assert (openerSettings.size() == openers.size());
        return openers;
    }

    public OpenerSetupLoader getSetupImgLoader(int setupId) {
        try {
            if (this.setupLoaders.containsKey(setupId)) {
                return this.setupLoaders.get(setupId);
            }
            int iOpener = this.viewSetupToOpenerChannel.get((Object)Integer.valueOf((int)setupId)).openerIndex;
            int iC = this.viewSetupToOpenerChannel.get((Object)Integer.valueOf((int)setupId)).channelIndex;
            String keySetup = iC + "." + this.openers.get(this.viewSetupToOpenerChannel.get((Object)Integer.valueOf((int)setupId)).openerIndex).getRawPixelDataKey();
            if (this.rawPixelDataChannelToSetupLoader.containsKey(keySetup)) {
                OpenerSetupLoader<?, ?, ?> loader = this.rawPixelDataChannelToSetupLoader.get(keySetup);
                this.setupLoaders.put(setupId, loader);
                return loader;
            }
            logger.debug("loading file number = " + iOpener + " setupId = " + setupId);
            try {
                OpenerSetupLoader<?, ?, ?> imgL = this.openers.get(iOpener).getSetupLoader(iC, setupId, this::getCacheControl);
                this.setupLoaders.put(setupId, imgL);
                this.rawPixelDataChannelToSetupLoader.put(keySetup, imgL);
                return imgL;
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException("Error in setup loader creation: " + e.getMessage());
        }
    }

    public VolatileGlobalCellCache getCacheControl() {
        return this.cache;
    }

    @Override
    public void close() {
        this.openers.forEach(opener -> {
            try {
                opener.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        this.cache.clearCache();
        this.sq.shutdown();
    }

    @Override
    public void setCacheControl(VolatileGlobalCellCache cache) {
        CacheControlOverride.Tools.shutdownCacheQueue(this.cache);
        this.cache.clearCache();
        this.cache = cache;
    }

    public static class OpenerAndChannelIndex {
        final int openerIndex;
        final int channelIndex;

        public OpenerAndChannelIndex(int openerIndex, int channelIndex) {
            this.openerIndex = openerIndex;
            this.channelIndex = channelIndex;
        }

        public int getChannelIndex() {
            return this.channelIndex;
        }

        public int getOpenerIndex() {
            return this.openerIndex;
        }
    }
}

