/*
 * Decompiled with CFR 0.152.
 */
package ch.epfl.biop;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLDecoder;
import java.util.function.Function;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;

public class DatasetHelper {
    public static final File cachedSampleDir = new File(System.getProperty("user.home"), "CachedSamples");
    public static final String JPG_RGB = "https://biop.epfl.ch/img/splash/physicsTemporal_byRGUIETcrop.jpg";
    public static final String OLYMPUS_OIR = "https://downloads.openmicroscopy.org/images/Olympus-OIR/etienne/venus%20stack.ome.tif";
    public static final String VSI = "https://github.com/NicoKiaru/TestImages/raw/master/VSI/Fluo3DFluoImage2Channels_01.vsi";
    public static final String LIF = "https://downloads.openmicroscopy.org/images/Leica-LIF/michael/PR2729_frameOrderCombinedScanTypes.lif";
    public static final String TIF_TIMELAPSE_3D = "https://github.com/NicoKiaru/TestImages/raw/master/CElegans/dub-0.5xy-TP1-22.tif";
    public static final String ND2_20X = "https://github.com/NicoKiaru/TestImages/raw/master/ND2/20x_g5_a1.nd2";
    public static final String ND2_60X = "https://github.com/NicoKiaru/TestImages/raw/master/ND2/60x_g5_a1.nd2";
    static Function<String, String> decoder = str -> {
        try {
            return URLDecoder.decode(str, "UTF-8");
        }
        catch (Exception e) {
            e.printStackTrace();
            return str;
        }
    };
    private static final int BUFFER_SIZE = 4096;

    public static File urlToFile(URL url, Function<String, String> decoder) {
        try {
            File file_out = new File(cachedSampleDir, decoder.apply(url.getFile()));
            if (file_out.exists()) {
                return file_out;
            }
            System.out.println("Downloading and caching: " + url + " size = " + DatasetHelper.getFileSize(url) / 1024 + " kb");
            FileUtils.copyURLToFile((URL)url, (File)file_out, (int)10000, (int)10000);
            System.out.println("Downloading and caching of " + url + " completed successfully ");
            return file_out;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static File getDataset(String urlString) {
        return DatasetHelper.getDataset(urlString, decoder);
    }

    public static File getDataset(String urlString, Function<String, String> decoder) {
        URL url = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        return DatasetHelper.urlToFile(url, decoder);
    }

    private static int getFileSize(URL url) {
        URLConnection conn = null;
        try {
            conn = url.openConnection();
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).setRequestMethod("HEAD");
            }
            conn.getInputStream();
            int n = conn.getContentLength();
            return n;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        finally {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
        }
    }

    public static Thread ASyncDL(String str) {
        Thread thread = new Thread(() -> DatasetHelper.getDataset(str));
        thread.start();
        return thread;
    }

    public static String getSampleVSIDataset() {
        Thread t0 = DatasetHelper.ASyncDL(VSI);
        Thread t1 = DatasetHelper.ASyncDL("https://github.com/NicoKiaru/TestImages/raw/master/VSI/_Fluo3DFluoImage2Channels_01_/stack1/frame_t_0.ets");
        Thread t2 = DatasetHelper.ASyncDL("https://github.com/NicoKiaru/TestImages/raw/master/VSI/_Fluo3DFluoImage2Channels_01_/stack10001/frame_t_0.ets");
        Thread t3 = DatasetHelper.ASyncDL("https://github.com/NicoKiaru/TestImages/raw/master/VSI/_Fluo3DFluoImage2Channels_01_/stack10004/frame_t_0.ets");
        try {
            t0.join();
            t1.join();
            t2.join();
            t3.join();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return DatasetHelper.getDataset(VSI).getAbsolutePath();
    }

    public static String dowloadBrainVSIDataset() throws IOException {
        DatasetHelper.dowloadBrainVSIDataset(0);
        DatasetHelper.dowloadBrainVSIDataset(1);
        DatasetHelper.dowloadBrainVSIDataset(2);
        DatasetHelper.dowloadBrainVSIDataset(3);
        DatasetHelper.dowloadBrainVSIDataset(4);
        DatasetHelper.dowloadBrainVSIDataset(5);
        return DatasetHelper.dowloadBrainVSIDataset(6);
    }

    public static String dowloadBrainVSIDataset(int i) throws IOException {
        String targetDir = cachedSampleDir.getAbsolutePath() + File.separator + "records" + File.separator + "6553641" + File.separator + "files" + File.separator;
        String urlBrainSlices = "https://zenodo.org/records/6553641/files/";
        String fName = "Slide_0" + i + ".vsi";
        if (!new File(targetDir + fName).exists()) {
            DatasetHelper.dlUnzip(urlBrainSlices + "Slide_0" + i + ".zip", targetDir);
        }
        return targetDir;
    }

    private static void dlUnzip(String url, String targetDir) throws IOException {
        File tempZip = DatasetHelper.getDataset(url);
        DatasetHelper.unpack(tempZip.getAbsolutePath(), targetDir);
        tempZip.delete();
    }

    private static void unpack(String zipFilePath, String destDirectory) throws IOException {
        File destDir = new File(destDirectory);
        if (!destDir.exists()) {
            destDir.mkdir();
        }
        ZipInputStream zipIn = new ZipInputStream(new FileInputStream(zipFilePath));
        ZipEntry entry = zipIn.getNextEntry();
        while (entry != null) {
            String filePath = destDirectory + File.separator + entry.getName();
            if (!entry.isDirectory()) {
                DatasetHelper.extractFile(zipIn, filePath);
            } else {
                File dir = new File(filePath);
                dir.mkdirs();
            }
            zipIn.closeEntry();
            entry = zipIn.getNextEntry();
        }
        zipIn.close();
    }

    private static void extractFile(ZipInputStream zipIn, String filePath) throws IOException {
        BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(filePath));
        byte[] bytesIn = new byte[4096];
        int read = 0;
        while ((read = zipIn.read(bytesIn)) != -1) {
            bos.write(bytesIn, 0, read);
        }
        bos.close();
    }
}

