/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.sgl;

import edu.mines.jtk.awt.ColorMap;
import edu.mines.jtk.awt.ColorMapListener;
import edu.mines.jtk.dsp.Sampling;
import edu.mines.jtk.ogl.Gl;
import edu.mines.jtk.sgl.Axis;
import edu.mines.jtk.sgl.AxisAlignedFrame;
import edu.mines.jtk.sgl.AxisAlignedQuad;
import edu.mines.jtk.sgl.BlendState;
import edu.mines.jtk.sgl.DrawContext;
import edu.mines.jtk.sgl.Group;
import edu.mines.jtk.sgl.ImagePanel;
import edu.mines.jtk.sgl.ImagePanelGroup;
import edu.mines.jtk.sgl.Node;
import edu.mines.jtk.sgl.Point3;
import edu.mines.jtk.sgl.PolygonState;
import edu.mines.jtk.sgl.StateSet;
import edu.mines.jtk.util.Check;
import edu.mines.jtk.util.Clips;
import edu.mines.jtk.util.Float3;
import edu.mines.jtk.util.SimpleFloat3;
import java.awt.image.IndexColorModel;
import java.util.ArrayList;
import java.util.Iterator;

public class ImagePanelGroup2
extends Group {
    private Sampling _s1;
    private Sampling _s2;
    private Sampling _s3;
    private ArrayList<ImagePanel> _ip1List;
    private ArrayList<ImagePanel> _ip2List;
    private Clips _clips1;
    private Clips _clips2;
    private ColorMap _colorMap1 = new ColorMap(0.0, 1.0, ColorMap.GRAY);
    private ColorMap _colorMap2 = new ColorMap(0.0, 1.0, ColorMap.getJet(0.5));

    public ImagePanelGroup2(float[][][] f1, float[][][] f2) {
        this(new Sampling(f1[0][0].length), new Sampling(f1[0].length), new Sampling(f1.length), f1, f2);
    }

    public ImagePanelGroup2(Sampling s1, Sampling s2, Sampling s3, float[][][] f1, float[][][] f2) {
        this(s1, s2, s3, new SimpleFloat3(f1), new SimpleFloat3(f2));
    }

    public ImagePanelGroup2(Sampling s1, Sampling s2, Sampling s3, Float3 f1, Float3 f2) {
        this(s1, s2, s3, f1, f2, new Axis[]{Axis.X, Axis.Y, Axis.Z});
    }

    public ImagePanelGroup2(Sampling s1, Sampling s2, Sampling s3, float[][][] f1, float[][][] f2, Axis[] axes) {
        this(s1, s2, s3, new SimpleFloat3(f1), new SimpleFloat3(f2), axes);
    }

    public ImagePanelGroup2(Sampling s1, Sampling s2, Sampling s3, Float3 f1, Float3 f2, Axis[] axes) {
        this._clips1 = new Clips(f1);
        this._clips2 = new Clips(f2);
        this.addPanels(s1, s2, s3, f1, f2, axes);
        this.addChild(new ImagePanelGroup.Wires(this._ip1List));
    }

    public void update1() {
        for (ImagePanel ip : this._ip1List) {
            ip.update();
        }
    }

    public void update2() {
        for (ImagePanel ip : this._ip2List) {
            ip.update();
        }
    }

    public ImagePanel getImagePanel1(Axis axis) {
        for (ImagePanel ip : this._ip1List) {
            if (axis != ip.getFrame().getAxis()) continue;
            return ip;
        }
        return null;
    }

    public ImagePanel getImagePanel2(Axis axis) {
        for (ImagePanel ip : this._ip2List) {
            if (axis != ip.getFrame().getAxis()) continue;
            return ip;
        }
        return null;
    }

    public Iterator<ImagePanel> getImagePanels1() {
        return this._ip1List.iterator();
    }

    public Iterator<ImagePanel> getImagePanels2() {
        return this._ip2List.iterator();
    }

    public void setColorModel1(IndexColorModel colorModel) {
        this._colorMap1.setColorModel(colorModel);
        for (ImagePanel ip : this._ip1List) {
            ip.setColorModel(colorModel);
        }
    }

    public void setColorModel2(IndexColorModel colorModel) {
        this._colorMap2.setColorModel(colorModel);
        for (ImagePanel ip : this._ip2List) {
            ip.setColorModel(colorModel);
        }
    }

    public IndexColorModel getColorModel1() {
        return this._colorMap1.getColorModel();
    }

    public IndexColorModel getColorModel2() {
        return this._colorMap2.getColorModel();
    }

    public void setClips1(double clipMin, double clipMax) {
        this._clips1.setClips(clipMin, clipMax);
        clipMin = this._clips1.getClipMin();
        clipMax = this._clips1.getClipMax();
        for (ImagePanel ip : this._ip1List) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap1.setValueRange(clipMin, clipMax);
    }

    public void setClips2(double clipMin, double clipMax) {
        this._clips2.setClips(clipMin, clipMax);
        clipMin = this._clips2.getClipMin();
        clipMax = this._clips2.getClipMax();
        for (ImagePanel ip : this._ip2List) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap2.setValueRange(clipMin, clipMax);
    }

    public float getClip1Min() {
        return this._clips1.getClipMin();
    }

    public float getClip2Min() {
        return this._clips2.getClipMin();
    }

    public float getClip1Max() {
        return this._clips1.getClipMax();
    }

    public float getClip2Max() {
        return this._clips2.getClipMax();
    }

    public void setPercentiles1(double percMin, double percMax) {
        this._clips1.setPercentiles(percMin, percMax);
        double clipMin = this._clips1.getClipMin();
        double clipMax = this._clips1.getClipMax();
        for (ImagePanel ip : this._ip1List) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap1.setValueRange(clipMin, clipMax);
    }

    public void setPercentiles2(double percMin, double percMax) {
        this._clips2.setPercentiles(percMin, percMax);
        double clipMin = this._clips2.getClipMin();
        double clipMax = this._clips2.getClipMax();
        for (ImagePanel ip : this._ip2List) {
            ip.setClips(clipMin, clipMax);
        }
        this._colorMap2.setValueRange(clipMin, clipMax);
    }

    public float getPercentile1Min() {
        return this._clips1.getPercentileMin();
    }

    public float getPercentile2Min() {
        return this._clips2.getPercentileMin();
    }

    public float getPercentile1Max() {
        return this._clips1.getPercentileMax();
    }

    public float getPercentile2Max() {
        return this._clips2.getPercentileMax();
    }

    public void addColorMap1Listener(ColorMapListener cml) {
        this._colorMap1.addListener(cml);
    }

    public void addColorMap2Listener(ColorMapListener cml) {
        this._colorMap2.addListener(cml);
    }

    public void removeColorMap1Listener(ColorMapListener cml) {
        this._colorMap1.removeListener(cml);
    }

    public void removeColorMap2Listener(ColorMapListener cml) {
        this._colorMap2.removeListener(cml);
    }

    public void setSlices(int k1, int k2, int k3) {
        int nx = this._s3.getCount();
        int ny = this._s2.getCount();
        int nz = this._s1.getCount();
        double dx = this._s3.getDelta();
        double dy = this._s2.getDelta();
        double dz = this._s1.getDelta();
        double fx = this._s3.getFirst();
        double fy = this._s2.getFirst();
        double fz = this._s1.getFirst();
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        int kx = Math.max(0, Math.min(nx - 1, k3));
        int ky = Math.max(0, Math.min(ny - 1, k2));
        int kz = Math.max(0, Math.min(nz - 1, k1));
        double xk = fx + (double)kx * dx;
        double yk = fy + (double)ky * dy;
        double zk = fz + (double)kz * dz;
        for (ImagePanel ip : this._ip1List) {
            AxisAlignedFrame frame = ip.getFrame();
            Axis axis = frame.getAxis();
            if (axis == Axis.X) {
                frame.setCorners(new Point3(xk, fy, fz), new Point3(xk, ly, lz));
                continue;
            }
            if (axis == Axis.Y) {
                frame.setCorners(new Point3(fx, yk, fz), new Point3(lx, yk, lz));
                continue;
            }
            frame.setCorners(new Point3(fx, fy, zk), new Point3(lx, ly, zk));
        }
    }

    private static void checkSampling(Sampling s1, Sampling s2, Sampling s3, Float3 f1, Float3 f2) {
        Check.argument(f1.getN1() == s1.getCount(), "f1.getN1()==s1.getCount()");
        Check.argument(f1.getN2() == s2.getCount(), "f1.getN2()==s2.getCount()");
        Check.argument(f1.getN3() == s3.getCount(), "f1.getN3()==s3.getCount()");
        Check.argument(f2.getN1() == s1.getCount(), "f2.getN1()==s1.getCount()");
        Check.argument(f2.getN2() == s2.getCount(), "f2.getN2()==s2.getCount()");
        Check.argument(f2.getN3() == s3.getCount(), "f2.getN3()==s3.getCount()");
    }

    private void addPanels(Sampling s1, Sampling s2, Sampling s3, Float3 f1, Float3 f2, Axis[] axes) {
        ImagePanelGroup2.checkSampling(s1, s2, s3, f1, f2);
        this._s1 = s1;
        this._s2 = s2;
        this._s3 = s3;
        int nx = s3.getCount();
        int ny = s2.getCount();
        int nz = s1.getCount();
        double dx = s3.getDelta();
        double dy = s2.getDelta();
        double dz = s1.getDelta();
        double fx = s3.getFirst();
        double fy = s2.getFirst();
        double fz = s1.getFirst();
        double lx = fx + (double)(nx - 1) * dx;
        double ly = fy + (double)(ny - 1) * dy;
        double lz = fz + (double)(nz - 1) * dz;
        Point3 qmin = new Point3(fx, fy, fz);
        Point3 qmax = new Point3(lx, ly, lz);
        int np = axes.length;
        this._ip1List = new ArrayList(np);
        this._ip2List = new ArrayList(np);
        PolygonState ps1 = new PolygonState();
        ps1.setPolygonOffset(1.0f, 1.0f);
        ps1.setPolygonOffsetFill(true);
        StateSet ss1 = new StateSet();
        ss1.add(ps1);
        BlendState bs2 = new BlendState();
        bs2.setFunction(770, 771);
        StateSet ss2 = new StateSet();
        ss2.add(bs2);
        for (int jp = 0; jp < np; ++jp) {
            AxisAlignedQuad aaq = new AxisAlignedQuad(axes[jp], qmin, qmax);
            AxisAlignedFrame aaf = aaq.getFrame();
            ImagePanel ip1 = new ImagePanel(s1, s2, s3, f1);
            ImagePanel ip2 = new ImagePanel(s1, s2, s3, f2);
            ip1.setStates(ss1);
            ip2.setStates(ss2);
            ip1.setColorModel(this.getColorModel1());
            ip2.setColorModel(this.getColorModel2());
            aaf.addChild(ip1);
            aaf.addChild(ip2);
            this.addChild(aaq);
            this._ip1List.add(ip1);
            this._ip2List.add(ip2);
        }
    }

    private class XWires
    extends Node {
        private XWires() {
        }

        @Override
        protected void draw(DrawContext dc) {
            Gl.glColor3f(1.0f, 1.0f, 1.0f);
            Gl.glLineWidth(1.5f);
            for (ImagePanel ip : ImagePanelGroup2.this._ip1List) {
                AxisAlignedFrame fi = ip.getFrame();
                Axis ai = fi.getAxis();
                for (ImagePanel jp : ImagePanelGroup2.this._ip1List) {
                    AxisAlignedFrame fj = jp.getFrame();
                    Axis aj = fj.getAxis();
                    if (ai == aj) continue;
                    Point3 pmini = fi.getCornerMin();
                    Point3 pmaxi = fi.getCornerMax();
                    Point3 pminj = fj.getCornerMin();
                    Point3 pmaxj = fj.getCornerMax();
                    double xmin = Math.max(pmini.x, pminj.x);
                    double xmax = Math.min(pmaxi.x, pmaxj.x);
                    double ymin = Math.max(pmini.y, pminj.y);
                    double ymax = Math.min(pmaxi.y, pmaxj.y);
                    double zmin = Math.max(pmini.z, pminj.z);
                    double zmax = Math.min(pmaxi.z, pmaxj.z);
                    if (!(xmin <= xmax) || !(ymin <= ymax) || !(zmin <= zmax)) continue;
                    Gl.glBegin(1);
                    Gl.glVertex3d(xmin, ymin, zmin);
                    Gl.glVertex3d(xmax, ymax, zmax);
                    Gl.glEnd();
                }
            }
        }
    }
}

