/*
 * Decompiled with CFR 0.152.
 */
package edu.mines.jtk.bench;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import javax.imageio.ImageIO;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class AwtBench {
    public static void main(String[] args) {
        AwtBench.testImage();
    }

    public static void testImage() {
        Dimension panelSize = new Dimension(600, 600);
        ImagePanel panel = new ImagePanel();
        panel.setSize(panelSize);
        panel.setPreferredSize(panelSize);
        panel.setBackground(Color.WHITE);
        BufferedImage image = panel.paintToImage(300.0, 3.0);
        AwtBench.writeToPng(image, "ImageAWT.png");
        JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        frame.add(panel);
        frame.pack();
        frame.setVisible(true);
    }

    private static void writeToPng(BufferedImage image, String fileName) {
        try {
            File file = new File(fileName);
            ImageIO.write((RenderedImage)image, "png", file);
        }
        catch (IOException ioe) {
            throw new RuntimeException(ioe);
        }
    }

    private static class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        private ImagePanel() {
        }

        @Override
        public void paintComponent(Graphics g) {
            int i;
            super.paintComponent(g);
            Graphics2D g2d = (Graphics2D)g;
            int width = this.getWidth();
            int height = this.getHeight();
            g2d.setColor(Color.RED);
            for (i = 0; i < 3; ++i) {
                g2d.drawLine(0, 0, i * (width - 1) / 2, height - 1);
            }
            for (i = 0; i < 2; ++i) {
                g2d.drawLine(0, 0, width - 1, i * (height - 1) / 2);
            }
            g2d.setColor(Color.BLACK);
            Font font = new Font("SansSerif", 0, 18);
            g2d.setFont(font);
            FontMetrics fm = g2d.getFontMetrics();
            int fontAscent = fm.getAscent();
            int fontHeight = fm.getHeight();
            int x = width / 2;
            int y = height / 2;
            g2d.drawLine(x, 0, x, y);
            int sw = fm.stringWidth("Goodbye");
            g2d.drawString("Goodbye", x - sw / 2, y += fontAscent);
            sw = fm.stringWidth("Hello");
            g2d.drawString("Hello", x - sw / 2, y += fontHeight);
            String message = "abcdefghijklmnopqrstuvwxyz0123456789";
            sw = fm.stringWidth(message);
            g2d.drawString(message, x - sw / 2, y += fontHeight);
        }

        public BufferedImage paintToImage(double dpi, double winches) {
            int wpixels = this.getWidth();
            int hpixels = this.getHeight();
            double scale = dpi * winches / (double)wpixels;
            int wimage = (int)(scale * (double)(wpixels - 1) + 1.5);
            int himage = (int)(scale * (double)(hpixels - 1) + 1.5);
            int type = 1;
            BufferedImage bi = new BufferedImage(wimage, himage, type);
            Graphics2D g2d = (Graphics2D)bi.getGraphics();
            g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Color fg = this.getForeground();
            g2d.setColor(this.getBackground());
            g2d.fillRect(0, 0, wimage, himage);
            g2d.setColor(fg);
            g2d.scale(scale, scale);
            this.paintComponent(g2d);
            g2d.dispose();
            return bi;
        }
    }
}

