/*
 * Decompiled with CFR 0.152.
 */
package org.scijava.io.http;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import okhttp3.Authenticator;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import okhttp3.Route;
import org.scijava.io.handle.AbstractSeekableStreamHandle;
import org.scijava.io.handle.DataHandle;
import org.scijava.io.http.HTTPLocation;
import org.scijava.plugin.Plugin;

@Plugin(type=DataHandle.class)
public class HTTPHandle
extends AbstractSeekableStreamHandle<HTTPLocation> {
    private OkHttpClient client;
    private Response result;
    private InputStream resultStream;
    private boolean serverCanResume = true;
    private boolean useAuthentication = false;
    private long length = -1L;

    public void resetStream() throws IOException {
        this.recreateStreamFromPos(0L);
    }

    public InputStream in() {
        if (this.resultStream == null) {
            try {
                this.resultStream = this.result().body().byteStream();
            }
            catch (IOException exc) {
                this.log().error((Object)"Could not create input stream: ", (Throwable)exc);
                return null;
            }
        }
        return this.resultStream;
    }

    public OutputStream out() {
        return null;
    }

    public boolean isReadable() {
        return true;
    }

    public boolean isWritable() {
        return false;
    }

    public boolean exists() throws IOException {
        return this.result().isSuccessful();
    }

    public Date lastModified() throws IOException {
        return null;
    }

    public long length() throws IOException {
        if (this.length == -1L) {
            if (this.result().code() == 206) {
                String range = this.result.header("Content-Range");
                this.length = Integer.parseInt(range.substring(range.lastIndexOf(47) + 1));
            } else if (this.result().code() == 200) {
                this.length = this.result().body().contentLength();
            }
        }
        return this.length;
    }

    public void setLength(long length) throws IOException {
        throw new UnsupportedOperationException("Can not set length on HttpHandles");
    }

    public Class<HTTPLocation> getType() {
        return HTTPLocation.class;
    }

    private Response result() throws IOException {
        if (this.result == null) {
            Request request = new Request.Builder().url(((HTTPLocation)((Object)this.get())).getHttpUrl()).get().header("Range", "bytes=0-").build();
            this.result = this.client().newCall(request).execute();
            if (this.result.code() == 200) {
                this.serverCanResume = false;
            } else if (this.result.code() == 206) {
                this.serverCanResume = true;
            } else {
                int code = this.result.code();
                this.result = null;
                throw new IOException("HTTP connection failure, errorcode: " + code);
            }
        }
        return this.result;
    }

    private OkHttpClient client() {
        if (this.client == null) {
            OkHttpClient.Builder clientBuilder = new OkHttpClient.Builder();
            clientBuilder.connectTimeout(((HTTPLocation)((Object)this.get())).getTimeout(), TimeUnit.MILLISECONDS);
            clientBuilder.authenticator(new Authenticator(){
                private static final int MAX_RETRIES = 4;

                public Request authenticate(Route route, Response response) throws IOException {
                    HTTPHandle.this.useAuthentication = true;
                    if (this.aboveMaxRetries(response)) {
                        return null;
                    }
                    HttpUrl url = ((HTTPLocation)((Object)HTTPHandle.this.get())).getHttpUrl();
                    String credential = Credentials.basic((String)url.username(), (String)url.password());
                    return response.request().newBuilder().header("Authorization", credential).build();
                }

                private boolean aboveMaxRetries(Response response) {
                    int rescount;
                    Response r = response;
                    for (rescount = 1; (r = r.priorResponse()) != null && rescount < 4; ++rescount) {
                    }
                    return rescount > 3;
                }
            });
            this.client = clientBuilder.build();
        }
        return this.client;
    }

    public void recreateStreamFromPos(long pos) throws IOException {
        HttpUrl httpUrl = ((HTTPLocation)((Object)this.get())).getHttpUrl();
        Headers.Builder headersBuilder = new Headers.Builder();
        headersBuilder.add("Range", "bytes=" + pos + "-");
        if (this.useAuthentication) {
            String credentials = Credentials.basic((String)httpUrl.username(), (String)httpUrl.password());
            headersBuilder.add("Authorization", credentials);
        }
        Request request = new Request.Builder().url(httpUrl).get().headers(headersBuilder.build()).build();
        Response tmpResult = this.client().newCall(request).execute();
        if (tmpResult.code() == 200) {
            this.serverCanResume = false;
            if (this.offset() < pos) {
                this.seek(pos);
            } else {
                this.setNewResult(tmpResult);
                this.setOffset(0L);
                this.seek(pos);
            }
        } else if (tmpResult.code() == 206) {
            this.setNewResult(tmpResult);
            this.setOffset(pos);
        } else {
            throw new IOException("HTTP connection failure, errorcode: " + tmpResult.code());
        }
    }

    private void setNewResult(Response result) throws IOException {
        this.result = result;
        if (this.resultStream != null) {
            this.resultStream.close();
        }
        this.resultStream = null;
    }

    protected boolean recreatePossible() throws IOException {
        return this.serverCanResume;
    }
}

