/*
 * Decompiled with CFR 0.152.
 */
package stitching.model;

import java.util.Collection;
import stitching.model.InvertibleModel;
import stitching.model.NotEnoughDataPointsException;
import stitching.model.PointMatch;

public class TranslationModel3D
extends InvertibleModel {
    protected static final int MIN_SET_SIZE = 1;
    protected final float[] translation = new float[3];

    public float[] getTranslation() {
        return this.translation;
    }

    @Override
    public final int getMinSetSize() {
        return 1;
    }

    @Override
    public float[] apply(float[] point) {
        assert (point.length == 3) : "3d translations can be applied to 3d points only.";
        return new float[]{point[0] + this.translation[0], point[1] + this.translation[1], point[2] + this.translation[2]};
    }

    @Override
    public void applyInPlace(float[] point) {
        assert (point.length == 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] + this.translation[0];
        point[1] = point[1] + this.translation[1];
        point[2] = point[2] + this.translation[2];
    }

    @Override
    public float[] applyInverse(float[] point) {
        assert (point.length == 3) : "3d translations can be applied to 3d points only.";
        return new float[]{point[0] - this.translation[0], point[1] - this.translation[1], point[2] - this.translation[2]};
    }

    @Override
    public void applyInverseInPlace(float[] point) {
        assert (point.length == 3) : "3d translations can be applied to 3d points only.";
        point[0] = point[0] - this.translation[0];
        point[1] = point[1] - this.translation[1];
        point[2] = point[2] - this.translation[2];
    }

    @Override
    public String toString() {
        return "[1,3](" + this.translation[0] + "," + this.translation[1] + "," + this.translation[2] + ") " + this.cost;
    }

    @Override
    public final void fit(Collection<PointMatch> matches) throws NotEnoughDataPointsException {
        if (matches.size() < 1) {
            throw new NotEnoughDataPointsException(matches.size() + " data points are not enough to estimate a 3d translation model, at least " + 1 + " data points required.");
        }
        float pcx = 0.0f;
        float pcy = 0.0f;
        float pcz = 0.0f;
        float qcx = 0.0f;
        float qcy = 0.0f;
        float qcz = 0.0f;
        double ws = 0.0;
        for (PointMatch m : matches) {
            float[] p = m.getP1().getL();
            float[] q = m.getP2().getW();
            float w = m.getWeight();
            ws += (double)w;
            pcx += w * p[0];
            pcy += w * p[1];
            pcz += w * p[2];
            qcx += w * q[0];
            qcy += w * q[1];
            qcz += w * q[2];
        }
        pcx = (float)((double)pcx / ws);
        pcy = (float)((double)pcy / ws);
        pcz = (float)((double)pcz / ws);
        qcx = (float)((double)qcx / ws);
        qcy = (float)((double)qcy / ws);
        qcz = (float)((double)qcz / ws);
        this.translation[0] = qcx - pcx;
        this.translation[1] = qcy - pcy;
        this.translation[2] = qcz - pcz;
    }

    @Override
    public final void shake(Collection<PointMatch> matches, float scale, float[] center) {
    }

    @Override
    public TranslationModel3D clone() {
        TranslationModel3D tm = new TranslationModel3D();
        tm.translation[0] = this.translation[0];
        tm.translation[1] = this.translation[1];
        tm.translation[2] = this.translation[2];
        tm.cost = this.cost;
        return tm;
    }
}

