/*
 * Decompiled with CFR 0.152.
 */
package plugin;

import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.gui.MultiLineLabel;
import java.awt.Choice;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import java.util.LinkedHashSet;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import plugin.Stitching_Grid;
import stitching.CommonFunctions;

public class GridType {
    private final String paperURL = "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184";
    public static final String[] choose1 = new String[]{"Grid: row-by-row", "Grid: column-by-column", "Grid: snake by rows", "Grid: snake by columns", "Filename defined position", "Unknown position", "Positions from file", "Sequential Images"};
    public static final String[][] choose2 = new String[choose1.length][];
    public static final String[] allChoices;
    public final ImageIcon[][] images = new ImageIcon[choose1.length][];
    int type = -1;
    int order = -1;

    public GridType() {
        int tmp;
        this.images[0] = new ImageIcon[4];
        this.images[0][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/row1.png"));
        this.images[0][1] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/row2.png"));
        this.images[0][2] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/row3.png"));
        this.images[0][3] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/row4.png"));
        this.images[1] = new ImageIcon[4];
        this.images[1][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/column1.png"));
        this.images[1][1] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/column2.png"));
        this.images[1][2] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/column3.png"));
        this.images[1][3] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/column4.png"));
        this.images[2] = new ImageIcon[4];
        this.images[2][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake1.png"));
        this.images[2][1] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake3.png"));
        this.images[2][2] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake5.png"));
        this.images[2][3] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake7.png"));
        this.images[3] = new ImageIcon[4];
        this.images[3] = new ImageIcon[4];
        this.images[3][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake2.png"));
        this.images[3][1] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake4.png"));
        this.images[3][2] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake6.png"));
        this.images[3][3] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/snake8.png"));
        this.images[4] = new ImageIcon[1];
        this.images[4][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/position.png"));
        this.images[5] = new ImageIcon[1];
        this.images[5][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/unknown.png"));
        this.images[6] = new ImageIcon[2];
        this.images[6][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/fromFile.png"));
        this.images[6][1] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/fromFile.png"));
        this.images[7] = new ImageIcon[1];
        this.images[7][0] = GenericDialogPlus.createImageIcon((URL)this.getClass().getResource("/images/sequential.png"));
        GenericDialogPlus gd = new GenericDialogPlus("Grid/Collection stitching");
        gd.addChoice("Type", choose1, choose1[Stitching_Grid.defaultGridChoice1]);
        if (!IJ.macroRunning()) {
            gd.addChoice("Order", choose2[Stitching_Grid.defaultGridChoice1], choose2[Stitching_Grid.defaultGridChoice1][Stitching_Grid.defaultGridChoice2]);
            try {
                ImageIcon display = new ImageIcon(this.images[Stitching_Grid.defaultGridChoice1][Stitching_Grid.defaultGridChoice2].getImage());
                JLabel label = gd.addImage(display);
                this.imageSwitch((Choice)gd.getChoices().get(0), (Choice)gd.getChoices().get(1), this.images, display, label);
            }
            catch (Exception e) {
                gd.addMessage("");
                gd.addMessage("Cannot load images to visualize the grid types ... ");
            }
        } else {
            gd.addChoice("Order", allChoices, allChoices[0]);
        }
        gd.addMessage("Please note that the Stitching is\nbased on a publication. If you use\nit for your research please be so\nkind to cite us:\nPreibisch et al., Bioinformatics (2009)");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, "http://bioinformatics.oxfordjournals.org/cgi/content/abstract/btp184");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        this.type = Stitching_Grid.defaultGridChoice1 = gd.getNextChoiceIndex();
        this.order = !IJ.macroRunning() ? gd.getNextChoiceIndex() : ((tmp = gd.getNextChoiceIndex()) == 11 ? 1 : (tmp >= 8 ? 0 : tmp % 4));
        Stitching_Grid.defaultGridChoice2 = this.order;
    }

    public int getType() {
        return this.type;
    }

    public int getOrder() {
        return this.order;
    }

    protected final void imageSwitch(final Choice choice1, final Choice choice2, final ImageIcon[][] images, final ImageIcon display, final JLabel label) {
        choice1.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                try {
                    int state1 = choice1.getSelectedIndex();
                    int state2 = state1 == 4 ? 0 : choice2.getSelectedIndex();
                    choice2.removeAll();
                    for (int i = 0; i < choose2[state1].length; ++i) {
                        choice2.add(choose2[state1][i]);
                    }
                    choice2.select(state2);
                    display.setImage(images[state1][state2].getImage());
                    label.update(label.getGraphics());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
        choice2.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent ie) {
                try {
                    int state1 = choice1.getSelectedIndex();
                    int state2 = state1 == 4 ? 0 : choice2.getSelectedIndex();
                    display.setImage(images[state1][state2].getImage());
                    label.update(label.getGraphics());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        });
    }

    static {
        GridType.choose2[0] = new String[]{"Right & Down                ", "Left & Down", "Right & Up", "Left & Up"};
        GridType.choose2[1] = new String[]{"Down & Right                ", "Down & Left", "Up & Right", "Up & Left"};
        GridType.choose2[2] = new String[]{"Right & Down                ", "Left & Down", "Right & Up", "Left & Up"};
        GridType.choose2[3] = new String[]{"Down & Right                ", "Down & Left", "Up & Right", "Up & Left"};
        GridType.choose2[4] = new String[]{"Defined by filename         "};
        GridType.choose2[5] = new String[]{"All files in directory"};
        GridType.choose2[6] = new String[]{"Defined by TileConfiguration", "Defined by image metadata"};
        GridType.choose2[7] = new String[]{"All files in directory"};
        LinkedHashSet<String> allChoicesSet = new LinkedHashSet<String>();
        String[][] stringArray = choose2;
        int n = stringArray.length;
        for (int i = 0; i < n; ++i) {
            String[] choices;
            for (String choice : choices = stringArray[i]) {
                allChoicesSet.add(choice);
            }
        }
        allChoices = allChoicesSet.toArray(new String[allChoicesSet.size()]);
    }
}

