/*
 * Decompiled with CFR 0.152.
 */
import fiji.util.gui.GenericDialogPlus;
import ij.ImagePlus;
import ij.gui.MultiLineLabel;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import stitching.CommonFunctions;
import stitching.GridLayout;
import stitching.utils.Log;

public class Stitch_Image_Grid_Sequence
implements PlugIn {
    private String myURL = "http://fiji.sc/Stitching_2D/3D";
    public static int gridSizeXStatic = 3;
    public static int gridSizeYStatic = 3;
    public static int gridSizeZStatic = 3;
    public static double overlapStatic = 20.0;
    public static String inputDirectoryStatic = "";
    public static String fileNamesStatic = "Tile_Z{zzz}_Y{yyy}_X{xxx}.lsm";
    public static String rgbOrderStatic = CommonFunctions.rgbTypes[0];
    public static String tileConfStatic = "TileConfiguration_{zzz}.txt";
    public static String outputDirectoryStatic = "";
    public static boolean writeOnlyTileConfStatic = false;
    public static int startXStatic = 1;
    public static int startYStatic = 1;
    public static int startZStatic = 1;
    public static int startIStatic = 1;
    public static String handleRGBStatic = CommonFunctions.colorList[CommonFunctions.colorList.length - 1];
    public static String fusionMethodStatic = CommonFunctions.methodListCollection[1];
    public static double alphaStatic = 1.5;
    public static double thresholdRStatic = 0.3;
    public static double thresholdDisplacementRelativeStatic = 2.5;
    public static double thresholdDisplacementAbsoluteStatic = 3.5;
    public static boolean previewOnlyStatic = false;
    public static boolean computeOverlapStatic = true;

    public void run(String arg0) {
        boolean computeOverlap;
        boolean previewOnly;
        String fusionMethod;
        String handleRGB;
        int startI;
        int startZ;
        int startY;
        int startX;
        boolean writeOnlyOutput;
        String outputDirectory;
        String outputFileName;
        String filenames;
        String inputDirectory;
        GenericDialogPlus gd = new GenericDialogPlus("Stitch Image Grid Sequence");
        GridLayout gridLayout = new GridLayout();
        gd.addNumericField("grid_size_x", (double)gridSizeXStatic, 0);
        gd.addNumericField("grid_size_y", (double)gridSizeYStatic, 0);
        gd.addNumericField("grid_size_z", (double)gridSizeZStatic, 0);
        gd.addSlider("overlap [%]", 0.0, 100.0, overlapStatic);
        gd.addDirectoryField("input directory", inputDirectoryStatic, 50);
        gd.addStringField("file_names", fileNamesStatic, 50);
        gd.addChoice("rgb_order", CommonFunctions.rgbTypes, rgbOrderStatic);
        gd.addStringField("Output_file_name", tileConfStatic, 50);
        gd.addDirectoryField("output directory", outputDirectoryStatic, 50);
        gd.addCheckbox("Save_Only_Tile_Configuration", writeOnlyTileConfStatic);
        gd.addNumericField("start_x", (double)startXStatic, 0);
        gd.addNumericField("start_y", (double)startYStatic, 0);
        gd.addNumericField("start_z", (double)startZStatic, 0);
        gd.addNumericField("start_i", (double)startIStatic, 0);
        gd.addChoice("channels_for_registration", CommonFunctions.colorList, handleRGBStatic);
        gd.addChoice("fusion_method", CommonFunctions.methodListCollection, fusionMethodStatic);
        gd.addNumericField("fusion_alpha", alphaStatic, 2);
        gd.addNumericField("regression_threshold", thresholdRStatic, 2);
        gd.addNumericField("max/avg_displacement_threshold", thresholdDisplacementRelativeStatic, 2);
        gd.addNumericField("absolute_displacement_threshold", thresholdDisplacementAbsoluteStatic, 2);
        gd.addCheckbox("create_only_preview", previewOnlyStatic);
        gd.addCheckbox("compute_overlap (otherwise use the coordinates given in the layout file)", computeOverlapStatic);
        gd.addMessage("");
        gd.addMessage("This Plugin is maintained by Ignacio Arganda-Carreras\n" + this.myURL);
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        CommonFunctions.addHyperLinkListener(text, this.myURL);
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        gridLayout.sizeX = (int)Math.round(gd.getNextNumber());
        gridLayout.sizeY = (int)Math.round(gd.getNextNumber());
        gridSizeXStatic = gridLayout.sizeX;
        gridSizeYStatic = gridLayout.sizeY;
        gridSizeZStatic = (int)Math.round(gd.getNextNumber());
        double overlap = gd.getNextNumber() / 100.0;
        overlapStatic = overlap * 100.0;
        inputDirectoryStatic = inputDirectory = gd.getNextString();
        fileNamesStatic = filenames = gd.getNextString();
        rgbOrderStatic = gridLayout.rgbOrder = gd.getNextChoice();
        tileConfStatic = outputFileName = gd.getNextString();
        outputDirectoryStatic = outputDirectory = gd.getNextString();
        writeOnlyTileConfStatic = writeOnlyOutput = gd.getNextBoolean();
        startXStatic = startX = (int)Math.round(gd.getNextNumber());
        startYStatic = startY = (int)Math.round(gd.getNextNumber());
        startZStatic = startZ = (int)Math.round(gd.getNextNumber());
        startIStatic = startI = (int)Math.round(gd.getNextNumber());
        handleRGBStatic = handleRGB = gd.getNextChoice();
        fusionMethodStatic = fusionMethod = gd.getNextChoice();
        alphaStatic = gridLayout.alpha = gd.getNextNumber();
        thresholdRStatic = gridLayout.thresholdR = gd.getNextNumber();
        thresholdDisplacementRelativeStatic = gridLayout.thresholdDisplacementRelative = gd.getNextNumber();
        thresholdDisplacementAbsoluteStatic = gridLayout.thresholdDisplacementAbsolute = gd.getNextNumber();
        previewOnlyStatic = previewOnly = gd.getNextBoolean();
        computeOverlapStatic = computeOverlap = gd.getNextBoolean();
        Stitch_Image_Grid_Sequence.stitchImageGridSequence(gridSizeZStatic, filenames, inputDirectory, gridLayout, handleRGB, fusionMethod, outputFileName, outputDirectory, overlap, startX, startY, startZ, startI, writeOnlyOutput, previewOnly, computeOverlap);
    }

    public static void stitchImageGridSequence(int nSections, String filenames, String inputDirectory, GridLayout gridLayout, String handleRGB, String fusionMethod, String outputFileName, String outputDirectory, double overlap, int startX, int startY, int startZ, int startI, boolean writeOnlyOutput, boolean previewOnly, boolean computeOverlap) {
        String replaceZ = "{";
        int numZValues = 0;
        int z1 = filenames.indexOf("{z");
        int z2 = filenames.indexOf("z}");
        if (z1 >= 0 && z2 > 0) {
            numZValues = z2 - z1;
            for (int i = 0; i < numZValues; ++i) {
                replaceZ = replaceZ + "z";
            }
            replaceZ = replaceZ + "}";
        } else {
            replaceZ = "\\\\\\\\";
        }
        int gridSize = gridLayout.sizeX * gridLayout.sizeY;
        for (int z = 0; z < nSections; ++z) {
            String outTileConfName;
            int zs = z + startZ;
            String file = filenames.replace(replaceZ, Stitch_Image_Grid.getLeadingZeros(numZValues, zs));
            ImagePlus fusedImage = Stitch_Image_Grid.stitchImageGrid(file, inputDirectory, gridLayout, handleRGB, fusionMethod, outTileConfName = outputFileName.replace(replaceZ, Stitch_Image_Grid.getLeadingZeros(numZValues, zs)), overlap, startX, startY, startI, writeOnlyOutput, previewOnly, computeOverlap);
            if (fusedImage == null) {
                return;
            }
            String outputFusedPath = outputDirectory + System.getProperty("file.separator") + fusedImage.getTitle() + "_" + Stitch_Image_Grid.getLeadingZeros(numZValues, zs) + ".tif";
            Log.info("Saving " + outputFusedPath + " ... ");
            try {
                new FileSaver(fusedImage).saveAsTiff(outputFusedPath);
            }
            catch (Exception e) {
                Log.error("Error while saving " + outputFusedPath, e);
                return;
            }
            Log.info("Saved");
            startI += gridSize;
            fusedImage.close();
        }
        Log.info("Image grid sequence stitching is done!");
    }
}

