/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.googlecloud;

import com.google.api.gax.paging.Page;
import com.google.cloud.storage.Blob;
import com.google.cloud.storage.BlobId;
import com.google.cloud.storage.BlobInfo;
import com.google.cloud.storage.Bucket;
import com.google.cloud.storage.BucketInfo;
import com.google.cloud.storage.Storage;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.channels.Channels;
import java.nio.channels.NonReadableChannelException;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageURI;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudUtils;
import org.janelia.saalfeldlab.n5.KeyValueAccess;
import org.janelia.saalfeldlab.n5.LockedChannel;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5URI;

public class GoogleCloudStorageKeyValueAccess
implements KeyValueAccess {
    private final Storage storage;
    private final GoogleCloudStorageURI containerURI;
    private final String bucketName;

    protected static GoogleCloudStorageURI uncheckedContainerLocationStringToGoogleURI(String uri) {
        try {
            return new GoogleCloudStorageURI(uri);
        }
        catch (Exception e) {
            throw new N5Exception("Container location " + uri + " is an invalid URI", e);
        }
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, String containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(storage, GoogleCloudStorageKeyValueAccess.uncheckedContainerLocationStringToGoogleURI(containerURI), createBucket);
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, URI containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this(storage, new GoogleCloudStorageURI(containerURI), createBucket);
    }

    public GoogleCloudStorageKeyValueAccess(Storage storage, GoogleCloudStorageURI containerURI, boolean createBucket) throws N5Exception.N5IOException {
        this.storage = storage;
        this.containerURI = containerURI;
        this.bucketName = containerURI.getBucket();
        if (!this.bucketExists(this.bucketName)) {
            if (createBucket) {
                storage.create(BucketInfo.of((String)this.bucketName), new Storage.BucketTargetOption[0]);
            } else {
                throw new N5Exception.N5IOException("Bucket " + this.bucketName + " does not exist, and you told me not to create one.");
            }
        }
    }

    private boolean bucketExists(String bucketName) {
        Bucket bucket = this.storage.get(bucketName, new Storage.BucketGetOption[0]);
        return bucket != null && bucket.exists(new Bucket.BucketSourceOption[0]);
    }

    @Override
    public String[] components(String path) {
        String[] baseComponents = path.split("/");
        if (baseComponents.length <= 1) {
            return baseComponents;
        }
        return (String[])Arrays.stream(baseComponents).filter(x -> !x.isEmpty()).toArray(String[]::new);
    }

    @Override
    public String compose(String ... components) {
        if (components == null || components.length == 0) {
            return null;
        }
        return this.normalize(Arrays.stream(components).filter(x -> !x.isEmpty()).collect(Collectors.joining("/")));
    }

    @Override
    public String compose(URI uri, String ... components) {
        String[] uriComponents = new String[components.length + 1];
        System.arraycopy(components, 0, uriComponents, 1, components.length);
        uriComponents[0] = GoogleCloudUtils.getGoogleCloudStorageKey(uri);
        return this.compose(uriComponents);
    }

    @Override
    public String parent(String path) {
        String[] components = this.components(path);
        String[] parentComponents = Arrays.copyOf(components, components.length - 1);
        return this.compose(parentComponents);
    }

    @Override
    public String relativize(String path, String base) {
        try {
            return GoogleCloudUtils.getGoogleCloudStorageKey(this.normalize(this.uri("/" + base).relativize(this.uri("/" + path)).getPath()));
        }
        catch (URISyntaxException e) {
            throw new N5Exception("Cannot relativize path (" + path + ") with base (" + base + ")", e);
        }
    }

    @Override
    public String normalize(String path) {
        return N5URI.normalizeGroupPath(path);
    }

    @Override
    public URI uri(String normalPath) throws URISyntaxException {
        URI asUri = this.containerURI.asURI();
        if (this.normalize(normalPath).equals(this.normalize("/"))) {
            return asUri;
        }
        Path containerPath = Paths.get(asUri.getPath(), new String[0]);
        Path givenPath = Paths.get(URI.create(normalPath).getPath(), new String[0]);
        Path resolvedPath = containerPath.resolve(givenPath);
        String[] pathParts = new String[resolvedPath.getNameCount() + 1];
        pathParts[0] = "/";
        for (int i = 0; i < resolvedPath.getNameCount(); ++i) {
            pathParts[i + 1] = resolvedPath.getName(i).toString();
        }
        String normalResolvedPath = this.compose(pathParts);
        return new URI(asUri.getScheme(), asUri.getAuthority(), normalResolvedPath, null, null);
    }

    @Override
    public boolean exists(String normalPath) {
        return this.isDirectory(normalPath) || this.isFile(normalPath);
    }

    private boolean keyExists(String key) {
        Blob blob = this.storage.get(BlobId.of((String)this.bucketName, (String)key), new Storage.BlobGetOption[]{Storage.BlobGetOption.fields((Storage.BlobField[])new Storage.BlobField[0])});
        return GoogleCloudStorageKeyValueAccess.blobExists(blob);
    }

    private static boolean blobExists(Blob blob) {
        return blob != null && blob.exists(new Blob.BlobSourceOption[0]);
    }

    private static String addTrailingSlash(String path) {
        return path.endsWith("/") ? path : path + "/";
    }

    private static String removeLeadingSlash(String path) {
        return path.startsWith("/") ? path.substring(1) : path;
    }

    @Override
    public boolean isDirectory(String normalPath) {
        String key = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(GoogleCloudStorageKeyValueAccess.addTrailingSlash(normalPath));
        if (key.equals(this.normalize("/"))) {
            return this.bucketExists(this.bucketName);
        }
        return this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)key), Storage.BlobListOption.pageSize((long)1L), Storage.BlobListOption.currentDirectory()}).iterateAll().iterator().hasNext();
    }

    @Override
    public boolean isFile(String normalPath) {
        return !normalPath.endsWith("/") && this.keyExists(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath));
    }

    @Override
    public LockedChannel lockForReading(String normalPath) {
        return new GoogleCloudObjectChannel(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath), true);
    }

    @Override
    public LockedChannel lockForWriting(String normalPath) {
        return new GoogleCloudObjectChannel(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath), false);
    }

    @Override
    public String[] listDirectories(String normalPath) {
        return this.list(normalPath, true);
    }

    private String[] list(String normalPath, boolean onlyDirectories) {
        if (!this.isDirectory(normalPath)) {
            throw new N5Exception.N5IOException(normalPath + " is not a valid group");
        }
        ArrayList<String> subGroups = new ArrayList<String>();
        String prefix = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(GoogleCloudStorageKeyValueAccess.addTrailingSlash(normalPath));
        Page blobListing = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)prefix), Storage.BlobListOption.currentDirectory(), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})});
        for (Blob nextBlob : blobListing.iterateAll()) {
            String relativePath;
            String blobName = nextBlob.getBlobId().getName();
            if (prefix.equals(blobName) || onlyDirectories && !blobName.endsWith("/") || (relativePath = this.relativize(blobName, prefix)).isEmpty()) continue;
            subGroups.add(relativePath);
        }
        return subGroups.toArray(new String[subGroups.size()]);
    }

    @Override
    public String[] list(String normalPath) {
        return this.list(normalPath, false);
    }

    @Override
    public void createDirectories(String normalPath) {
        String path = "";
        for (String component : this.components(GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath))) {
            if ((path = GoogleCloudStorageKeyValueAccess.addTrailingSlash(this.compose(path, component))).equals("/")) continue;
            BlobInfo blobInfo = BlobInfo.newBuilder((String)this.bucketName, (String)path).build();
            this.storage.create(blobInfo, new Storage.BlobTargetOption[0]);
        }
    }

    @Override
    public void delete(String normalPath) {
        if (!this.bucketExists(this.bucketName)) {
            return;
        }
        String path = GoogleCloudStorageKeyValueAccess.removeLeadingSlash(normalPath);
        if (!path.endsWith("/")) {
            this.storage.delete(BlobId.of((String)this.bucketName, (String)path));
        }
        for (Page page = this.storage.list(this.bucketName, new Storage.BlobListOption[]{Storage.BlobListOption.prefix((String)path), Storage.BlobListOption.fields((Storage.BlobField[])new Storage.BlobField[]{Storage.BlobField.ID})}); page != null; page = page.getNextPage()) {
            BlobId[] ids = (BlobId[])page.streamValues().map(BlobInfo::getBlobId).toArray(BlobId[]::new);
            if (ids.length <= 0) continue;
            this.storage.delete(ids);
        }
        if (normalPath.equals(this.normalize("/"))) {
            this.storage.delete(this.bucketName, new Storage.BucketSourceOption[0]);
            return;
        }
    }

    private class GoogleCloudObjectChannel
    implements LockedChannel {
        final String path;
        final boolean readOnly;
        final ArrayList<Closeable> resources = new ArrayList();

        GoogleCloudObjectChannel(String path, boolean readOnly) {
            this.path = path;
            this.readOnly = readOnly;
        }

        private void checkWritable() {
            if (this.readOnly) {
                throw new NonReadableChannelException();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public InputStream newInputStream() {
            Blob blob = GoogleCloudStorageKeyValueAccess.this.storage.get(BlobId.of((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path));
            if (!GoogleCloudStorageKeyValueAccess.blobExists(blob)) {
                return null;
            }
            InputStream in = Channels.newInputStream((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]));
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(in);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Reader newReader() {
            Blob blob = GoogleCloudStorageKeyValueAccess.this.storage.get(BlobId.of((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path));
            if (!GoogleCloudStorageKeyValueAccess.blobExists(blob)) {
                return null;
            }
            Reader in = Channels.newReader((ReadableByteChannel)blob.reader(new Blob.BlobSourceOption[0]), StandardCharsets.UTF_8.name());
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(in);
            }
            return in;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public OutputStream newOutputStream() {
            this.checkWritable();
            BlobInfo blobInfo = BlobInfo.newBuilder((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path).build();
            OutputStream out = Channels.newOutputStream((WritableByteChannel)GoogleCloudStorageKeyValueAccess.this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]));
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(out);
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Writer newWriter() {
            this.checkWritable();
            BlobInfo blobInfo = BlobInfo.newBuilder((String)GoogleCloudStorageKeyValueAccess.this.bucketName, (String)this.path).build();
            Writer out = Channels.newWriter((WritableByteChannel)GoogleCloudStorageKeyValueAccess.this.storage.writer(blobInfo, new Storage.BlobWriteOption[0]), StandardCharsets.UTF_8.name());
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                this.resources.add(out);
            }
            return out;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() throws IOException {
            ArrayList<Closeable> arrayList = this.resources;
            synchronized (arrayList) {
                for (Closeable resource : this.resources) {
                    resource.close();
                }
                this.resources.clear();
            }
        }
    }
}

