/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.googlecloud;

import com.google.cloud.storage.Storage;
import com.google.cloud.storage.StorageOptions;
import java.net.URI;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageClient;
import org.janelia.saalfeldlab.googlecloud.GoogleCloudStorageURI;

public class GoogleCloudUtils {
    public static final Pattern GS_SCHEME = Pattern.compile("gs", 2);
    public static final Pattern GS_HOST = Pattern.compile("(cloud\\.google|storage\\.googleapis)\\.com", 2);

    private GoogleCloudUtils() {
    }

    public static String getGoogleCloudStorageKey(String uri) {
        return GoogleCloudUtils.getGoogleCloudStorageKey(URI.create(uri));
    }

    public static String getGoogleCloudStorageKey(URI uri) {
        try {
            String key = new GoogleCloudStorageURI(uri).getKey();
            return key == null ? "" : key;
        }
        catch (Exception key) {
            String path = uri.getPath().replaceFirst("^/", "");
            return path.substring(path.indexOf(47) + 1);
        }
    }

    public static Storage createGoogleCloudStorage(@Nullable String googleCloudProjectId) {
        GoogleCloudStorageClient storageClient = GoogleCloudUtils.getGoogleCloudStorageClient(googleCloudProjectId);
        if (storageClient == null) {
            return null;
        }
        return storageClient.create();
    }

    public static GoogleCloudStorageClient getGoogleCloudStorageClient(@Nullable String googleCloudProjectId) {
        return new GoogleCloudStorageClient(googleCloudProjectId != null ? googleCloudProjectId : StorageOptions.getDefaultProjectId());
    }
}

