/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.googlecloud;

import com.google.common.base.Splitter;
import java.net.URI;
import java.util.Map;

public class GoogleCloudStorageURI {
    private static final String storageHost = "storage.googleapis.com";
    private static final String googleCloudHost = "googleapis.com";
    private static final String googleCloudHost2 = "storage.cloud.google.com";
    private static final String storagePathPrefix = "/storage/v1/b/";
    private static final String projectKey = "project";
    private final URI uri;
    private final String bucketName;
    private final String objectKey;
    private final String query;
    private Map<String, String> queryMap;

    public GoogleCloudStorageURI(String str) {
        this(URI.create(str));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public GoogleCloudStorageURI(URI uri) {
        this.uri = uri;
        if (uri.getScheme() != null && uri.getScheme().equalsIgnoreCase("gs")) {
            this.bucketName = uri.getAuthority();
            this.objectKey = uri.getPath();
            this.query = uri.getQuery();
        } else {
            if (!uri.getScheme().equalsIgnoreCase("http") && !uri.getScheme().equalsIgnoreCase("https")) throw new IllegalArgumentException("Invalid scheme");
            String host = uri.getHost();
            if (host.equalsIgnoreCase(googleCloudHost) || host.equalsIgnoreCase("www.googleapis.com")) {
                String path;
                if (!uri.getPath().toLowerCase().startsWith(storagePathPrefix)) {
                    throw new IllegalArgumentException("Not a google cloud storage link");
                }
                int delimeterIndex = (path = uri.getPath().substring(storagePathPrefix.length())).indexOf("/");
                this.bucketName = path.substring(0, delimeterIndex != -1 ? delimeterIndex : path.length());
                this.objectKey = delimeterIndex != -1 && delimeterIndex < path.length() - 1 ? path.substring(delimeterIndex) : "";
                this.query = uri.getQuery();
            } else {
                if (!host.equalsIgnoreCase(storageHost) && !host.equalsIgnoreCase(googleCloudHost2)) throw new IllegalArgumentException("Not a google cloud storage link");
                String path = uri.getPath().indexOf(47) == 0 ? uri.getPath().substring(1) : uri.getPath();
                int delimeterIndex = path.indexOf("/");
                this.bucketName = path.substring(0, delimeterIndex != -1 ? delimeterIndex : path.length());
                this.objectKey = delimeterIndex != -1 && delimeterIndex < path.length() - 1 ? path.substring(delimeterIndex) : "";
                this.query = uri.getQuery();
            }
        }
        this.queryMap = this.parseQuery();
    }

    public String getBucket() {
        return this.bucketName;
    }

    public URI asURI() {
        return this.uri;
    }

    public String getKey() {
        return this.objectKey;
    }

    public String getQuery() {
        return this.query;
    }

    public String getProject() {
        if (this.queryMap != null && this.queryMap.containsKey(projectKey)) {
            return this.queryMap.get(projectKey);
        }
        return null;
    }

    private Map<String, String> parseQuery() {
        if (this.query != null) {
            return Splitter.on((char)'&').trimResults().withKeyValueSeparator('=').split((CharSequence)this.query);
        }
        return null;
    }
}

