/*
 * Decompiled with CFR 0.152.
 */
package spim.process.fusion.weights;

import net.imglib2.Interval;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealPositionable;
import net.imglib2.RealRandomAccessible;
import net.imglib2.realtransform.AffineTransform3D;
import net.imglib2.util.Util;
import spim.process.fusion.weights.TransformedInterpolatedRealRandomAccess;

public class TransformedRealRandomAccessibleInterval<T>
implements RandomAccessibleInterval<T> {
    final RealRandomAccessible<T> realRandomAccessible;
    final T zero;
    final Interval transformedInterval;
    final AffineTransform3D transform;
    final long[] offset;

    public TransformedRealRandomAccessibleInterval(RealRandomAccessible<T> realRandomAccessible, T zero, Interval transformedInterval, AffineTransform3D transform, long[] offset) {
        this.realRandomAccessible = realRandomAccessible;
        this.zero = zero;
        this.transformedInterval = transformedInterval;
        this.transform = transform;
        this.offset = offset;
    }

    public int numDimensions() {
        return this.realRandomAccessible.numDimensions();
    }

    public RandomAccess<T> randomAccess() {
        return new TransformedInterpolatedRealRandomAccess<T>(this.realRandomAccessible, this.zero, this.transformedInterval, this.transform, Util.long2int((long[])this.offset));
    }

    public RandomAccess<T> randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public long min(int d) {
        return this.transformedInterval.min(d);
    }

    public void min(long[] min) {
        this.transformedInterval.min(min);
    }

    public void min(Positionable min) {
        this.transformedInterval.min(min);
    }

    public long max(int d) {
        return this.transformedInterval.max(d);
    }

    public void max(long[] max) {
        this.transformedInterval.max(max);
    }

    public void max(Positionable max) {
        this.transformedInterval.max(max);
    }

    public double realMin(int d) {
        return this.transformedInterval.realMin(d);
    }

    public void realMin(double[] min) {
        this.transformedInterval.realMin(min);
    }

    public void realMin(RealPositionable min) {
        this.transformedInterval.realMin(min);
    }

    public double realMax(int d) {
        return this.transformedInterval.realMax(d);
    }

    public void realMax(double[] max) {
        this.transformedInterval.realMax(max);
    }

    public void realMax(RealPositionable max) {
        this.transformedInterval.realMax(max);
    }

    public void dimensions(long[] dimensions) {
        this.transformedInterval.dimensions(dimensions);
    }

    public long dimension(int d) {
        return this.transformedInterval.dimension(d);
    }
}

