/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.spimdata.imgloaders;

import java.io.File;
import mpicbg.spim.data.XmlHelpers;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.generic.sequence.ImgLoaderIo;
import mpicbg.spim.data.generic.sequence.XmlIoBasicImgLoader;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.array.ArrayImgFactory;
import net.imglib2.img.cell.CellImgFactory;
import net.imglib2.img.planar.PlanarImgFactory;
import net.imglib2.type.NativeType;
import org.jdom2.Content;
import org.jdom2.Element;
import spim.fiji.spimdata.imgloaders.StackImgLoader;

public abstract class XmlIoStackImgLoader<T extends StackImgLoader<?>>
implements XmlIoBasicImgLoader<T> {
    public static final String DIRECTORY_TAG = "imagedirectory";
    public static final String FILE_PATTERN_TAG = "filePattern";
    public static final String IMGLIB2CONTAINER_PATTERN_TAG = "imglib2container";
    public static final String LAYOUT_TP_TAG = "layoutTimepoints";
    public static final String LAYOUT_CHANNEL_TAG = "layoutChannels";
    public static final String LAYOUT_ILLUMINATION_TAG = "layoutIlluminations";
    public static final String LAYOUT_ANGLE_TAG = "layoutAngles";

    public Element toXml(T imgLoader, File basePath) {
        Element elem = new Element("ImageLoader");
        elem.setAttribute("format", this.getClass().getAnnotation(ImgLoaderIo.class).format());
        elem.addContent((Content)XmlHelpers.pathElement((String)DIRECTORY_TAG, (File)((StackImgLoader)((Object)imgLoader)).getPath(), (File)basePath));
        elem.addContent((Content)XmlHelpers.textElement((String)FILE_PATTERN_TAG, (String)((StackImgLoader)((Object)imgLoader)).getFileNamePattern()));
        elem.addContent((Content)XmlHelpers.intElement((String)LAYOUT_TP_TAG, (int)((StackImgLoader)((Object)imgLoader)).getLayoutTimePoints()));
        elem.addContent((Content)XmlHelpers.intElement((String)LAYOUT_CHANNEL_TAG, (int)((StackImgLoader)((Object)imgLoader)).getLayoutChannels()));
        elem.addContent((Content)XmlHelpers.intElement((String)LAYOUT_ILLUMINATION_TAG, (int)((StackImgLoader)((Object)imgLoader)).getLayoutIlluminations()));
        elem.addContent((Content)XmlHelpers.intElement((String)LAYOUT_ANGLE_TAG, (int)((StackImgLoader)((Object)imgLoader)).getLayoutAngles()));
        elem.addContent((Content)XmlHelpers.textElement((String)IMGLIB2CONTAINER_PATTERN_TAG, (String)((StackImgLoader)((Object)imgLoader)).getImgFactory().getClass().getSimpleName()));
        return elem;
    }

    public T fromXml(Element elem, File basePath, AbstractSequenceDescription<?, ?, ?> sequenceDescription) {
        try {
            ArrayImgFactory imgFactory;
            File path = XmlHelpers.loadPath((Element)elem, (String)DIRECTORY_TAG, (File)basePath);
            String fileNamePattern = XmlHelpers.getText((Element)elem, (String)FILE_PATTERN_TAG);
            int layoutTP = XmlHelpers.getInt((Element)elem, (String)LAYOUT_TP_TAG);
            int layoutChannels = XmlHelpers.getInt((Element)elem, (String)LAYOUT_CHANNEL_TAG);
            int layoutIllum = XmlHelpers.getInt((Element)elem, (String)LAYOUT_ILLUMINATION_TAG);
            int layoutAngles = XmlHelpers.getInt((Element)elem, (String)LAYOUT_ANGLE_TAG);
            String container = XmlHelpers.getText((Element)elem, (String)IMGLIB2CONTAINER_PATTERN_TAG);
            if (container == null) {
                System.out.println("WARNING: No Img implementation defined, using ArrayImg.");
                imgFactory = new ArrayImgFactory();
            } else if (container.toLowerCase().contains("cellimg")) {
                imgFactory = new CellImgFactory(new int[]{256});
            } else if (container.toLowerCase().contains("arrayimg")) {
                imgFactory = new ArrayImgFactory();
            } else if (container.toLowerCase().contains("planarimg")) {
                imgFactory = new PlanarImgFactory();
            } else {
                imgFactory = new ArrayImgFactory();
                System.out.println("WARNING: Unknown Img implementation '" + container + "', using ArrayImg.");
            }
            return this.createImgLoader(path, fileNamePattern, (ImgFactory<? extends NativeType<?>>)imgFactory, layoutTP, layoutChannels, layoutIllum, layoutAngles, sequenceDescription);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected abstract T createImgLoader(File var1, String var2, ImgFactory<? extends NativeType<?>> var3, int var4, int var5, int var6, int var7, AbstractSequenceDescription<?, ?, ?> var8);
}

