/*
 * Decompiled with CFR 0.152.
 */
package spim.fiji.datasetmanager;

import ij.ImagePlus;
import ij.io.Opener;
import ij.measure.Calibration;
import java.io.File;
import mpicbg.spim.data.generic.sequence.AbstractSequenceDescription;
import mpicbg.spim.data.sequence.SequenceDescription;
import mpicbg.spim.io.IOFunctions;
import net.imglib2.img.ImgFactory;
import net.imglib2.type.NativeType;
import spim.fiji.datasetmanager.StackList;
import spim.fiji.spimdata.imgloaders.StackImgLoader;
import spim.fiji.spimdata.imgloaders.StackImgLoaderIJ;

public class StackListImageJ
extends StackList {
    public static int defaultAngleChoice = 1;
    public static int defaultTimePointChoice = 1;
    public static int defaultChannelleChoice = 0;
    public static int defaultIlluminationChoice = 0;

    @Override
    public String getTitle() {
        return "Image Stacks (ImageJ Opener)";
    }

    @Override
    public String getExtendedDescription() {
        return "This dataset definition supports a series of three-dimensional (3d) image stacks\nall present in the same folder. The filename of each file must define timepoint,\nangle, channel and illumination direction (or a subset of those).\nThe 3d image stacks must be stored as TIFF that can be opened by ImageJ natively.\n\n\nThe filenames of the 3d image stacks could be for example:\n\nspim_TL1_Channel1_Illum1_Angle0.tif ... spim_TL100_Channel2_Illum2_Angle315.tif\ndata_TP01_Angle000.lsm ... data_TP70_Angle180.lsm\nAngle0.ome.tiff ... Angle288.ome.tiff\n\nNote: this definition can be used for OpenSPIM data if saved as plain TIFF.";
    }

    @Override
    protected StackList.Calibration loadCalibration(File file) {
        try {
            IOFunctions.println("Loading calibration for: " + file.getAbsolutePath());
            if (!file.exists()) {
                IOFunctions.println("File '" + file + "' does not exist. Stopping.");
                return null;
            }
            ImagePlus imp = new Opener().openImage(file.getAbsolutePath());
            if (imp == null) {
                IOFunctions.println("Could not open file: '" + file.getAbsolutePath() + "'");
                return null;
            }
            Calibration c = imp.getCalibration();
            double calX = c.pixelWidth;
            double calY = c.pixelHeight;
            double calZ = c.pixelDepth;
            String calUnit = c.getUnit();
            if (calUnit.contains("\u00b5")) {
                calUnit = calUnit.replace('\u00b5', 'u');
            }
            imp.close();
            return new StackList.Calibration(calX, calY, calZ, calUnit);
        }
        catch (Exception e) {
            IOFunctions.println("Could not open file: '" + file.getAbsolutePath() + "'");
            return null;
        }
    }

    @Override
    protected StackImgLoader createAndInitImgLoader(String path, File basePath, ImgFactory<? extends NativeType<?>> imgFactory, SequenceDescription sequenceDescription) {
        return new StackImgLoaderIJ(new File(basePath.getAbsolutePath(), path), this.fileNamePattern, imgFactory, this.hasMultipleTimePoints, this.hasMultipleChannels, this.hasMultipleIlluminations, this.hasMultipleAngles, (AbstractSequenceDescription<?, ?, ?>)sequenceDescription);
    }

    @Override
    protected boolean supportsMultipleTimepointsPerFile() {
        return false;
    }

    @Override
    protected boolean supportsMultipleChannelsPerFile() {
        return false;
    }

    @Override
    protected boolean supportsMultipleAnglesPerFile() {
        return false;
    }

    @Override
    protected boolean supportsMultipleIlluminationsPerFile() {
        return false;
    }

    @Override
    protected int getDefaultMultipleAngles() {
        return defaultAngleChoice;
    }

    @Override
    protected int getDefaultMultipleTimepoints() {
        return defaultTimePointChoice;
    }

    @Override
    protected int getDefaultMultipleChannels() {
        return defaultChannelleChoice;
    }

    @Override
    protected int getDefaultMultipleIlluminations() {
        return defaultIlluminationChoice;
    }

    @Override
    protected void setDefaultMultipleAngles(int a) {
        defaultAngleChoice = a;
    }

    @Override
    protected void setDefaultMultipleTimepoints(int t) {
        defaultTimePointChoice = t;
    }

    @Override
    protected void setDefaultMultipleChannels(int c) {
        defaultChannelleChoice = c;
    }

    @Override
    protected void setDefaultMultipleIlluminations(int i) {
        defaultIlluminationChoice = i;
    }

    @Override
    public StackListImageJ newInstance() {
        return new StackListImageJ();
    }
}

