/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.segmentation;

import fiji.tool.SliceListener;
import fiji.tool.SliceObserver;
import ij.IJ;
import ij.ImageJ;
import ij.ImagePlus;
import ij.WindowManager;
import ij.gui.OvalRoi;
import ij.gui.Overlay;
import ij.gui.Roi;
import ij.plugin.PlugIn;
import ij.process.ByteProcessor;
import ij.process.FloatProcessor;
import ij.process.ImageProcessor;
import ij.process.ShortProcessor;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.Rectangle;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.integral.IntegralImageLong;
import mpicbg.imglib.algorithm.scalespace.DifferenceOfGaussian;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursor;
import mpicbg.imglib.cursor.special.LocalNeighborhoodCursorFactory;
import mpicbg.imglib.function.Converter;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.integer.LongType;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import mpicbg.spim.registration.detection.DetectionSegmentation;
import mpicbg.spim.segmentation.DOM;
import mpicbg.spim.segmentation.SimplePeak;
import spim.Threads;

public class InteractiveIntegral
implements PlugIn {
    final int scrollbarSize = 1000;
    int radius1 = 1;
    int radius2 = 3;
    float threshold = 1.0E-4f;
    double min;
    double max;
    int radiusMin = 1;
    int radiusMax = 29;
    int radiusInit1 = 300;
    int radiusInit2 = 400;
    float thresholdMin = 1.0E-4f;
    float thresholdMax = 1.0f;
    int thresholdInit = 500;
    SliceObserver sliceObserver;
    ImagePlus imp;
    int channel = 0;
    Rectangle rectangle;
    Image<FloatType> source;
    Image<FloatType> sliceImage;
    Image<LongType> integralImage;
    ArrayList<SimplePeak> peaks;
    Color originalColor = new Color(0.8f, 0.8f, 0.8f);
    Color inactiveColor = new Color(0.95f, 0.95f, 0.95f);
    boolean isComputing = false;
    boolean isStarted = false;
    boolean enableRadius2 = false;
    boolean lookForMinima = false;
    boolean lookForMaxima = true;
    boolean isFinished = false;
    boolean wasCanceled = false;

    public boolean isFinished() {
        return this.isFinished;
    }

    public boolean wasCanceld() {
        return this.wasCanceled;
    }

    public void setInitialRadii(int r1, int r2) {
        if (r2 <= r1) {
            r2 = r1 + 2;
        }
        this.radius1 = r1;
        this.radiusInit1 = InteractiveIntegral.computeScrollbarPositionFromValue(this.radius1, this.radiusMin, this.radiusMax, 1000);
        this.radius2 = r2;
        this.radiusInit2 = InteractiveIntegral.computeScrollbarPositionFromValue(this.radius2, this.radiusMin, this.radiusMax, 1000);
    }

    public void setInitialRadius(int r1) {
        this.setInitialRadii(r1, InteractiveIntegral.computeRadius2(r1));
    }

    public int getRadius1() {
        return this.radius1;
    }

    public int getRadius2() {
        return this.radius2;
    }

    public double getThreshold() {
        return this.threshold;
    }

    public void setThreshold(float value) {
        this.threshold = value;
        double log1001 = Math.log10(1001.0);
        this.thresholdInit = (int)Math.round(1001.0 - Math.pow(10.0, -((double)((this.threshold - this.thresholdMin) / (this.thresholdMax - this.thresholdMin)) * log1001) + log1001));
    }

    public boolean getRadius2WasAdjusted() {
        return this.enableRadius2;
    }

    public boolean getLookForMaxima() {
        return this.lookForMaxima;
    }

    public boolean getLookForMinima() {
        return this.lookForMinima;
    }

    public void setLookForMaxima(boolean lookForMaxima) {
        this.lookForMaxima = lookForMaxima;
    }

    public void setLookForMinima(boolean lookForMinima) {
        this.lookForMinima = lookForMinima;
    }

    public void setRadiusMax(int radiusMax) {
        this.radiusMax = radiusMax;
    }

    public Image<FloatType> getConvertedImage() {
        return this.source;
    }

    public InteractiveIntegral(ImagePlus imp, int channel) {
        this.imp = imp;
        this.channel = channel;
    }

    public InteractiveIntegral(ImagePlus imp) {
        this.imp = imp;
    }

    public InteractiveIntegral() {
    }

    public void setMinIntensityImage(double min) {
        this.min = min;
    }

    public void setMaxIntensityImage(double max) {
        this.max = max;
    }

    public void run(String arg) {
        if (this.imp == null) {
            this.imp = WindowManager.getCurrentImage();
        }
        if (this.imp.getType() == 4 || this.imp.getType() == 3) {
            IJ.log((String)"Color images are not supported, please convert to 8, 16 or 32-bit grayscale");
            return;
        }
        this.source = InteractiveIntegral.convertToFloat(this.imp, this.channel, 0);
        this.sliceImage = this.source.getImageFactory().createImage(new int[]{this.source.getDimension(0), this.source.getDimension(1)});
        if (Double.isNaN(this.min) || Double.isNaN(this.max) || Double.isInfinite(this.min) || Double.isInfinite(this.max) || this.min == this.max) {
            FloatType min = new FloatType();
            FloatType max = new FloatType();
            DOM.computeMinMax(this.source, min, max);
            this.min = min.get();
            this.max = max.get();
        }
        this.integralImage = this.computeIntegralImage(this.source);
        this.displaySliders();
        this.sliceObserver = new SliceObserver(this.imp, (SliceListener)new ImagePlusListener());
        this.updatePreview(ValueChange.ALL);
        this.isStarted = true;
    }

    public Image<LongType> computeIntegralImage(Image<FloatType> img) {
        IntegralImageLong intImg = new IntegralImageLong(img, (Converter)new Converter<FloatType, LongType>(){

            public void convert(FloatType input, LongType output) {
                output.set((long)Util.round((float)input.get()));
            }
        });
        intImg.process();
        Image integralImg = intImg.getResult();
        return integralImg;
    }

    public static final void computeDifferencOfMeanSlice(final Image<LongType> integralImg, final Image<FloatType> sliceImg, final int z, final int sx1, final int sy1, final int sz1, final int sx2, final int sy2, final int sz2, final float min, final float max) {
        final float sumPixels1 = sx1 * sy1 * sz1;
        final float sumPixels2 = sx2 * sy2 * sz2;
        final int sx1Half = sx1 / 2;
        final int sy1Half = sy1 / 2;
        final int sz1Half = sz1 / 2;
        final int sx2Half = sx2 / 2;
        final int sy2Half = sy2 / 2;
        final int sz2Half = sz2 / 2;
        final int sxHalfMax = Math.max(sx1Half, sx2Half);
        final int syHalfMax = Math.max(sy1Half, sy2Half);
        final int szHalfMax = Math.max(sz1Half, sz2Half);
        final int w = sliceImg.getDimension(0) - Math.max(sx1, sx2) / 2 * 2;
        final int h = sliceImg.getDimension(1) - Math.max(sy1, sy2) / 2 * 2;
        final int d = integralImg.getDimension(2) - 1 - Math.max(sz1, sz2) / 2 * 2;
        long imageSize = w * h;
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads();
        final Vector threadChunks = SimpleMultiThreading.divideIntoChunks((long)imageSize, (int)threads.length);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    Chunk myChunk = (Chunk)threadChunks.get(myNumber);
                    long loopSize = myChunk.getLoopSize();
                    LocalizableCursor cursor = sliceImg.createLocalizableCursor();
                    LocalizableByDimCursor randomAccess = integralImg.createLocalizableByDimCursor();
                    cursor.fwd(myChunk.getStartPosition());
                    for (long j = 0L; j < loopSize; ++j) {
                        FloatType result = (FloatType)cursor.next();
                        int x = cursor.getPosition(0);
                        int y = cursor.getPosition(1);
                        int xt = x - sxHalfMax;
                        int yt = y - syHalfMax;
                        int zt = z - szHalfMax;
                        if (xt < 0 || yt < 0 || zt < 0 || xt >= w || yt >= h || zt >= d) continue;
                        float s1 = (float)DOM.computeSum(x - sx1Half, y - sy1Half, z - sz1Half, sx1, sy1, sz1, (LocalizableByDimCursor<LongType>)randomAccess) / sumPixels1;
                        float s2 = (float)DOM.computeSum(x - sx2Half, y - sy2Half, z - sz2Half, sx2, sy2, sz2, (LocalizableByDimCursor<LongType>)randomAccess) / sumPixels2;
                        result.set((s2 - s1) / (max - min));
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    protected void updatePreview(ValueChange change) {
        Overlay o;
        if (this.peaks == null || change == ValueChange.RADIUS || change == ValueChange.SLICE || change == ValueChange.ALL) {
            int slice = (this.imp.getCurrentSlice() - 1) / this.imp.getNChannels();
            int s1 = this.radius1 * 2 + 1;
            int s2 = this.radius2 * 2 + 1;
            InteractiveIntegral.computeDifferencOfMeanSlice(this.integralImage, this.sliceImage, slice, s1, s1, s1, s2, s2, s2, (float)this.min, (float)this.max);
            this.peaks = InteractiveIntegral.findPeaks(this.sliceImage, this.thresholdMin);
        }
        if ((o = this.imp.getOverlay()) == null) {
            o = new Overlay();
            this.imp.setOverlay(o);
        }
        o.clear();
        if (this.peaks != null) {
            int avgSize = (this.radius1 + this.radius2 + 1) / 2;
            for (SimplePeak peak : this.peaks) {
                if ((!peak.isMax || !this.lookForMaxima) && (!peak.isMin || !this.lookForMinima)) continue;
                float x = peak.location[0];
                float y = peak.location[1];
                if (!(Math.abs(peak.intensity) > this.threshold)) continue;
                OvalRoi or = new OvalRoi(Util.round((float)(x - (float)avgSize)), Util.round((float)(y - (float)avgSize)), this.radius1 + this.radius2 + 1, this.radius1 + this.radius2 + 1);
                if (peak.isMax) {
                    or.setStrokeColor(Color.green);
                } else if (peak.isMin) {
                    or.setStrokeColor(Color.red);
                }
                o.add((Roi)or);
            }
        }
        this.imp.updateAndDraw();
        this.isComputing = false;
    }

    public static int computeRadius2(int radius1) {
        float sensitivity = 1.25f;
        float k = (float)DetectionSegmentation.computeK(1.25f);
        float[] radius = DetectionSegmentation.computeSigma(k, radius1);
        int radius2 = Math.round(radius[1]);
        if (radius2 <= radius1 + 1) {
            radius2 = radius1 + 1;
        }
        return radius2;
    }

    public static ArrayList<SimplePeak> findPeaks(final Image<FloatType> laPlace, final float minValue) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)Threads.numThreads());
        final int nThreads = threads.length;
        final int numDimensions = laPlace.getNumDimensions();
        final Vector threadPeaksList = new Vector();
        for (int i = 0; i < nThreads; ++i) {
            threadPeaksList.add(new ArrayList());
        }
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int myNumber = ai.getAndIncrement();
                    ArrayList myPeaks = (ArrayList)threadPeaksList.get(myNumber);
                    LocalizableByDimCursor cursor = laPlace.createLocalizableByDimCursor();
                    LocalNeighborhoodCursor neighborhoodCursor = LocalNeighborhoodCursorFactory.createLocalNeighborhoodCursor((LocalizableByDimCursor)cursor);
                    int[] position = new int[numDimensions];
                    int[] dimensionsMinus2 = laPlace.getDimensions();
                    int d = 0;
                    while (d < numDimensions) {
                        int n = d++;
                        dimensionsMinus2[n] = dimensionsMinus2[n] - 2;
                    }
                    block1: while (cursor.hasNext()) {
                        cursor.fwd();
                        cursor.getPosition(position);
                        if (position[0] % nThreads != myNumber) continue;
                        for (d = 0; d < numDimensions; ++d) {
                            int pos = position[d];
                            if (pos < 1 || pos > dimensionsMinus2[d]) continue block1;
                        }
                        float currentValue = ((FloatType)cursor.getType()).get();
                        if (Math.abs(currentValue) < minValue) continue;
                        neighborhoodCursor.update();
                        DifferenceOfGaussian.SpecialPoint specialPoint = InteractiveIntegral.isSpecialPoint((LocalNeighborhoodCursor<FloatType>)neighborhoodCursor, currentValue);
                        if (specialPoint == DifferenceOfGaussian.SpecialPoint.MIN) {
                            myPeaks.add(new SimplePeak(position, Math.abs(currentValue), true, false));
                        } else if (specialPoint == DifferenceOfGaussian.SpecialPoint.MAX) {
                            myPeaks.add(new SimplePeak(position, Math.abs(currentValue), false, true));
                        }
                        neighborhoodCursor.reset();
                    }
                    cursor.close();
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
        ArrayList<SimplePeak> dogPeaks = new ArrayList<SimplePeak>();
        for (ArrayList arrayList : threadPeaksList) {
            dogPeaks.addAll(arrayList);
        }
        return dogPeaks;
    }

    protected static final DifferenceOfGaussian.SpecialPoint isSpecialPoint(LocalNeighborhoodCursor<FloatType> neighborhoodCursor, float centerValue) {
        boolean isMax;
        double value;
        boolean isMin = true;
        for (isMax = true; (isMax || isMin) && neighborhoodCursor.hasNext(); isMin &= value >= (double)centerValue, isMax &= value <= (double)centerValue) {
            neighborhoodCursor.fwd();
            value = ((FloatType)neighborhoodCursor.getType()).getRealDouble();
        }
        if (isMin) {
            return DifferenceOfGaussian.SpecialPoint.MAX;
        }
        if (isMax) {
            return DifferenceOfGaussian.SpecialPoint.MIN;
        }
        return DifferenceOfGaussian.SpecialPoint.INVALID;
    }

    public static Image<FloatType> convertToFloat(ImagePlus imp, int channel, int timepoint) {
        Image img = imp.getNSlices() > 1 ? new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()).createImage(new int[]{imp.getWidth(), imp.getHeight(), imp.getNSlices()}) : new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory()).createImage(new int[]{imp.getWidth(), imp.getHeight()});
        int sliceSize = imp.getWidth() * imp.getHeight();
        int z = 0;
        ImageProcessor ip = imp.getStack().getProcessor(imp.getStackIndex(++channel, z + 1, ++timepoint));
        if (ip instanceof FloatProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            float[] pixels = (float[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (float[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set(pixels[i++]);
            }
        } else if (ip instanceof ByteProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            byte[] pixels = (byte[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (byte[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set((float)(pixels[i++] & 0xFF));
            }
        } else if (ip instanceof ShortProcessor) {
            ArrayCursor cursor = (ArrayCursor)img.createCursor();
            short[] pixels = (short[])ip.getPixels();
            int i = 0;
            while (cursor.hasNext()) {
                if (i == sliceSize) {
                    pixels = (short[])imp.getStack().getProcessor(imp.getStackIndex(channel, ++z + 1, timepoint)).getPixels();
                    i = 0;
                }
                ((FloatType)cursor.next()).set((float)(pixels[i++] & 0xFFFF));
            }
        } else {
            LocalizableCursor cursor = img.createLocalizableCursor();
            int[] location = new int[img.getNumDimensions()];
            while (cursor.hasNext()) {
                cursor.fwd();
                cursor.getPosition(location);
                if (location[2] != z) {
                    z = location[2];
                    ip = imp.getStack().getProcessor(imp.getStackIndex(channel, z + 1, timepoint));
                }
                ((FloatType)cursor.getType()).set(ip.getPixelValue(location[0], location[1]));
            }
        }
        return img;
    }

    protected void displaySliders() {
        Frame frame = new Frame("Adjust Difference-of-Mean Values");
        frame.setSize(400, 330);
        GridBagLayout layout = new GridBagLayout();
        GridBagConstraints c = new GridBagConstraints();
        Scrollbar radius1 = new Scrollbar(0, this.radiusInit1, 10, 0, 1010);
        this.radius1 = Math.round(InteractiveIntegral.computeValueFromScrollbarPosition(this.radiusInit1, this.radiusMin, this.radiusMax, 1000));
        Scrollbar threshold = new Scrollbar(0, this.thresholdInit, 10, 0, 1010);
        float log1001 = (float)Math.log10(1001.0);
        this.threshold = this.thresholdMin + (log1001 - (float)Math.log10(1001 - this.thresholdInit)) / log1001 * (this.thresholdMax - this.thresholdMin);
        this.radius2 = InteractiveIntegral.computeRadius2(this.radius1);
        int radius2init = InteractiveIntegral.computeScrollbarPositionFromValue(this.radius2, this.radiusMin, this.radiusMax, 1000);
        Scrollbar radius2 = new Scrollbar(0, radius2init, 10, 0, 1010);
        Label radiusText1 = new Label("Radius 1 = " + this.radius1, 1);
        Label radiusText2 = new Label("Radius 2 = " + this.radius2, 1);
        Label thresholdText = new Label("Threshold = " + this.threshold, 1);
        Button button = new Button("Done");
        Button cancel = new Button("Cancel");
        Checkbox radius2Enable = new Checkbox("Enable Manual Adjustment of Radius 2 ", this.enableRadius2);
        Checkbox min = new Checkbox("Look for Minima (red)", this.lookForMinima);
        Checkbox max = new Checkbox("Look for Maxima (green)", this.lookForMaxima);
        frame.setLayout(layout);
        c.fill = 2;
        c.gridx = 0;
        c.gridy = 0;
        c.weightx = 1.0;
        frame.add((Component)radius1, c);
        ++c.gridy;
        frame.add((Component)radiusText1, c);
        ++c.gridy;
        frame.add((Component)radius2, c);
        ++c.gridy;
        frame.add((Component)radiusText2, c);
        ++c.gridy;
        c.insets = new Insets(0, 65, 0, 65);
        frame.add((Component)radius2Enable, c);
        ++c.gridy;
        c.insets = new Insets(10, 0, 0, 0);
        frame.add((Component)threshold, c);
        c.insets = new Insets(0, 0, 0, 0);
        ++c.gridy;
        frame.add((Component)thresholdText, c);
        ++c.gridy;
        c.insets = new Insets(0, 130, 0, 75);
        frame.add((Component)min, c);
        ++c.gridy;
        c.insets = new Insets(0, 125, 0, 75);
        frame.add((Component)max, c);
        ++c.gridy;
        c.insets = new Insets(10, 150, 0, 150);
        frame.add((Component)button, c);
        ++c.gridy;
        c.insets = new Insets(10, 150, 0, 150);
        frame.add((Component)cancel, c);
        radius1.addAdjustmentListener(new Radius1Listener(radiusText1, this.radiusMin, this.radiusMax, 1000, radius1, radius2, radiusText2));
        radius2.addAdjustmentListener(new Radius2Listener(this.radiusMin, this.radiusMax, 1000, radius2, radiusText2));
        threshold.addAdjustmentListener(new ThresholdListener(thresholdText, this.thresholdMin, this.thresholdMax));
        button.addActionListener(new FinishButtonListener(frame, false));
        cancel.addActionListener(new FinishButtonListener(frame, true));
        min.addItemListener(new MinListener());
        max.addItemListener(new MaxListener());
        radius2Enable.addItemListener(new EnableListener(radius2, radiusText2));
        if (!this.enableRadius2) {
            radius2Enable.setEnabled(false);
        }
        frame.addWindowListener(new FrameListener(frame));
        frame.setVisible(true);
        this.originalColor = radius2.getBackground();
        radius2.setBackground(this.inactiveColor);
        radiusText1.setFont(radiusText1.getFont().deriveFont(1));
        thresholdText.setFont(thresholdText.getFont().deriveFont(1));
    }

    protected final void close(Frame parent, SliceObserver sliceObserver, ImagePlus imp) {
        if (parent != null) {
            parent.dispose();
        }
        if (sliceObserver != null) {
            sliceObserver.unregister();
        }
        if (imp != null) {
            imp.getOverlay().clear();
            imp.updateAndDraw();
        }
        this.isFinished = true;
    }

    protected static float computeValueFromScrollbarPosition(int scrollbarPosition, float min, float max, int scrollbarSize) {
        return min + (float)scrollbarPosition / (float)scrollbarSize * (max - min);
    }

    protected static int computeScrollbarPositionFromValue(float radius, float min, float max, int scrollbarSize) {
        return Util.round((float)((radius - min) / (max - min) * (float)scrollbarSize));
    }

    public static void main(String[] args) {
        new ImageJ();
        ImagePlus imp = new ImagePlus("/Users/preibischs/Documents/Microscopy/SPIM/HisYFP-SPIM/spim_TL18_Angle0_cropped.tif");
        imp.show();
        imp.setSlice(27);
        InteractiveIntegral ii = new InteractiveIntegral();
        ii.setInitialRadius(2);
        ii.run(null);
    }

    protected class ImagePlusListener
    implements SliceListener {
        protected ImagePlusListener() {
        }

        public void sliceChanged(ImagePlus arg0) {
            if (InteractiveIntegral.this.isStarted) {
                while (InteractiveIntegral.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveIntegral.this.updatePreview(ValueChange.SLICE);
            }
        }
    }

    protected class ThresholdListener
    implements AdjustmentListener {
        final Label label;
        final float min;
        final float max;
        final float log1001 = (float)Math.log10(1001.0);

        public ThresholdListener(Label label, float min, float max) {
            this.label = label;
            this.min = min;
            this.max = max;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            InteractiveIntegral.this.threshold = this.min + (this.log1001 - (float)Math.log10(1001 - event.getValue())) / this.log1001 * (this.max - this.min);
            this.label.setText("Threshold = " + InteractiveIntegral.this.threshold);
            if (!InteractiveIntegral.this.isComputing) {
                InteractiveIntegral.this.updatePreview(ValueChange.THRESHOLD);
            } else if (!event.getValueIsAdjusting()) {
                while (InteractiveIntegral.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveIntegral.this.updatePreview(ValueChange.THRESHOLD);
            }
        }
    }

    protected class Radius1Listener
    implements AdjustmentListener {
        final Label label;
        final float min;
        final float max;
        final int scrollbarSize;
        final Scrollbar radiusScrollbar1;
        final Scrollbar radiusScrollbar2;
        final Label radiusText2;

        public Radius1Listener(Label label, float min, float max, int scrollbarSize, Scrollbar radiusScrollbar1, Scrollbar radiusScrollbar2, Label radiusText2) {
            this.label = label;
            this.min = min;
            this.max = max;
            this.scrollbarSize = scrollbarSize;
            this.radiusScrollbar1 = radiusScrollbar1;
            this.radiusScrollbar2 = radiusScrollbar2;
            this.radiusText2 = radiusText2;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            InteractiveIntegral.this.radius1 = Math.round(InteractiveIntegral.computeValueFromScrollbarPosition(event.getValue(), this.min, this.max, this.scrollbarSize));
            if (!InteractiveIntegral.this.enableRadius2) {
                InteractiveIntegral.this.radius2 = InteractiveIntegral.computeRadius2(InteractiveIntegral.this.radius1);
                this.radiusText2.setText("Radius 2 = " + InteractiveIntegral.this.radius2);
                this.radiusScrollbar2.setValue(InteractiveIntegral.computeScrollbarPositionFromValue(InteractiveIntegral.this.radius2, this.min, this.max, this.scrollbarSize));
            } else if (InteractiveIntegral.this.radius1 >= InteractiveIntegral.this.radius2) {
                InteractiveIntegral.this.radius1 = InteractiveIntegral.this.radius2 - 2;
                this.radiusScrollbar1.setValue(InteractiveIntegral.computeScrollbarPositionFromValue(InteractiveIntegral.this.radius1, this.min, this.max, this.scrollbarSize));
            }
            this.label.setText("Radius 1 = " + InteractiveIntegral.this.radius1);
            if (!event.getValueIsAdjusting()) {
                while (InteractiveIntegral.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveIntegral.this.updatePreview(ValueChange.RADIUS);
            }
        }
    }

    protected class Radius2Listener
    implements AdjustmentListener {
        final float min;
        final float max;
        final int scrollbarSize;
        final Scrollbar radiusScrollbar2;
        final Label radius2Label;

        public Radius2Listener(float min, float max, int scrollbarSize, Scrollbar radiusScrollbar2, Label radius2Label) {
            this.min = min;
            this.max = max;
            this.scrollbarSize = scrollbarSize;
            this.radiusScrollbar2 = radiusScrollbar2;
            this.radius2Label = radius2Label;
        }

        @Override
        public void adjustmentValueChanged(AdjustmentEvent event) {
            if (InteractiveIntegral.this.enableRadius2) {
                InteractiveIntegral.this.radius2 = Math.round(InteractiveIntegral.computeValueFromScrollbarPosition(event.getValue(), this.min, this.max, this.scrollbarSize));
                if (InteractiveIntegral.this.radius2 <= InteractiveIntegral.this.radius1) {
                    InteractiveIntegral.this.radius2 = InteractiveIntegral.this.radius1 + 1;
                    this.radiusScrollbar2.setValue(InteractiveIntegral.computeScrollbarPositionFromValue(InteractiveIntegral.this.radius2, this.min, this.max, this.scrollbarSize));
                }
                this.radius2Label.setText("Radius 2 = " + InteractiveIntegral.this.radius2);
                if (!event.getValueIsAdjusting()) {
                    while (InteractiveIntegral.this.isComputing) {
                        SimpleMultiThreading.threadWait((long)10L);
                    }
                    InteractiveIntegral.this.updatePreview(ValueChange.RADIUS);
                }
            } else {
                this.radiusScrollbar2.setValue(InteractiveIntegral.computeScrollbarPositionFromValue(InteractiveIntegral.this.radius2, this.min, this.max, this.scrollbarSize));
            }
        }
    }

    protected class FrameListener
    extends WindowAdapter {
        final Frame parent;

        public FrameListener(Frame parent) {
            this.parent = parent;
        }

        @Override
        public void windowClosing(WindowEvent e) {
            InteractiveIntegral.this.close(this.parent, InteractiveIntegral.this.sliceObserver, InteractiveIntegral.this.imp);
        }
    }

    protected class FinishButtonListener
    implements ActionListener {
        final Frame parent;
        final boolean cancel;

        public FinishButtonListener(Frame parent, boolean cancel) {
            this.parent = parent;
            this.cancel = cancel;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            InteractiveIntegral.this.wasCanceled = this.cancel;
            InteractiveIntegral.this.close(this.parent, InteractiveIntegral.this.sliceObserver, InteractiveIntegral.this.imp);
        }
    }

    protected class MaxListener
    implements ItemListener {
        protected MaxListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            boolean oldState = InteractiveIntegral.this.lookForMaxima;
            if (arg0.getStateChange() == 2) {
                InteractiveIntegral.this.lookForMaxima = false;
            } else if (arg0.getStateChange() == 1) {
                InteractiveIntegral.this.lookForMaxima = true;
            }
            if (InteractiveIntegral.this.lookForMaxima != oldState) {
                while (InteractiveIntegral.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveIntegral.this.updatePreview(ValueChange.MINMAX);
            }
        }
    }

    protected class MinListener
    implements ItemListener {
        protected MinListener() {
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            boolean oldState = InteractiveIntegral.this.lookForMinima;
            if (arg0.getStateChange() == 2) {
                InteractiveIntegral.this.lookForMinima = false;
            } else if (arg0.getStateChange() == 1) {
                InteractiveIntegral.this.lookForMinima = true;
            }
            if (InteractiveIntegral.this.lookForMinima != oldState) {
                while (InteractiveIntegral.this.isComputing) {
                    SimpleMultiThreading.threadWait((long)10L);
                }
                InteractiveIntegral.this.updatePreview(ValueChange.MINMAX);
            }
        }
    }

    protected class EnableListener
    implements ItemListener {
        final Scrollbar radius2;
        final Label radiusText2;

        public EnableListener(Scrollbar radius2, Label radiusText2) {
            this.radiusText2 = radiusText2;
            this.radius2 = radius2;
        }

        @Override
        public void itemStateChanged(ItemEvent arg0) {
            if (arg0.getStateChange() == 2) {
                this.radiusText2.setFont(this.radiusText2.getFont().deriveFont(0));
                this.radius2.setBackground(InteractiveIntegral.this.inactiveColor);
                InteractiveIntegral.this.enableRadius2 = false;
            } else if (arg0.getStateChange() == 1) {
                this.radiusText2.setFont(this.radiusText2.getFont().deriveFont(1));
                this.radius2.setBackground(InteractiveIntegral.this.originalColor);
                InteractiveIntegral.this.enableRadius2 = true;
            }
        }
    }

    public static enum ValueChange {
        RADIUS,
        THRESHOLD,
        SLICE,
        MINMAX,
        ALL;

    }
}

