/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.registration.detection.descriptor;

import fiji.util.NNearestNeighborSearch;
import java.util.ArrayList;
import mpicbg.pointdescriptor.AbstractPointDescriptor;
import mpicbg.pointdescriptor.LocalCoordinateSystemPointDescriptor;
import mpicbg.pointdescriptor.ModelPointDescriptor;
import mpicbg.pointdescriptor.exception.NoSuitablePointsException;
import mpicbg.pointdescriptor.matcher.Matcher;
import mpicbg.pointdescriptor.matcher.SimpleMatcher;
import mpicbg.pointdescriptor.model.TranslationInvariantModel;
import mpicbg.pointdescriptor.model.TranslationInvariantRigidModel3D;
import mpicbg.pointdescriptor.similarity.SimilarityMeasure;
import mpicbg.pointdescriptor.similarity.SquareDistance;
import mpicbg.spim.mpicbg.PointMatchGeneric;
import mpicbg.spim.registration.detection.DetectionView;
import mpicbg.spim.registration.detection.descriptor.CoordSystem3d;

public class CoordSystemSecure3d<T extends DetectionView<?, T>>
extends CoordSystem3d<T> {
    final int numExtractions;
    private static final TranslationInvariantModel<?> model = new TranslationInvariantRigidModel3D();
    private static final Matcher matcher = new SimpleMatcher(3);
    private static final SimilarityMeasure similarityMeasure = new SquareDistance();

    public CoordSystemSecure3d(int numExtractions) {
        this.numExtractions = numExtractions;
    }

    @Override
    protected void computeMatching(ArrayList<LocalCoordinateSystemPointDescriptor<T>> descriptors1, NNearestNeighborSearch<LocalCoordinateSystemPointDescriptor<T>> nnsearch2, ArrayList<PointMatchGeneric<T>> correspondences, double differenceThreshold, double ratioOfDistance) {
        for (LocalCoordinateSystemPointDescriptor<T> descriptorA : descriptors1) {
            ModelPointDescriptor<T> modelPointDescriptorA = CoordSystemSecure3d.transformDescriptor(descriptorA);
            if (modelPointDescriptorA == null) continue;
            LocalCoordinateSystemPointDescriptor[] matches = (LocalCoordinateSystemPointDescriptor[])nnsearch2.findNNearestNeighbors(descriptorA, 2 + this.numExtractions);
            ArrayList<ModelPointDescriptor<T>> modelPointDescriptorsB = new ArrayList<ModelPointDescriptor<T>>();
            for (LocalCoordinateSystemPointDescriptor match : matches) {
                ModelPointDescriptor<T> modelPointDescriptorB = CoordSystemSecure3d.transformDescriptor(match);
                if (modelPointDescriptorB == null) continue;
                modelPointDescriptorsB.add(modelPointDescriptorB);
            }
            if (modelPointDescriptorsB.size() < 2) continue;
            double bestDifference = Double.MAX_VALUE;
            double secondBestDifference = Double.MAX_VALUE;
            AbstractPointDescriptor bestMatch = null;
            AbstractPointDescriptor secondBestMatch = null;
            for (ModelPointDescriptor modelPointDescriptor : modelPointDescriptorsB) {
                double difference = modelPointDescriptorA.descriptorDistance(modelPointDescriptor);
                if (!(difference < secondBestDifference)) continue;
                secondBestDifference = difference;
                secondBestMatch = modelPointDescriptor;
                if (!(secondBestDifference < bestDifference)) continue;
                double tmpDiff = secondBestDifference;
                ModelPointDescriptor tmpMatch = secondBestMatch;
                secondBestDifference = bestDifference;
                secondBestMatch = bestMatch;
                bestDifference = tmpDiff;
                bestMatch = tmpMatch;
            }
            if (!(bestDifference < differenceThreshold) || !(bestDifference * ratioOfDistance <= secondBestDifference)) continue;
            DetectionView detectionA = (DetectionView)((Object)descriptorA.getBasisPoint());
            DetectionView detectionView = (DetectionView)((Object)bestMatch.getBasisPoint());
            detectionA.addPointDescriptorCorrespondence(detectionView, 1.0);
            detectionView.addPointDescriptorCorrespondence(detectionA, 1.0);
            correspondences.add(new PointMatchGeneric<DetectionView>(detectionA, detectionView, 1.0));
        }
    }

    private static final <T extends DetectionView<?, T>> ModelPointDescriptor<T> transformDescriptor(LocalCoordinateSystemPointDescriptor<T> desc) {
        DetectionView basisPoint = (DetectionView)((Object)desc.getBasisPoint());
        ArrayList orderedNearestNeighboringPoints = desc.getOrderedNearestNeighboringPoints();
        try {
            return new ModelPointDescriptor<DetectionView>(basisPoint, orderedNearestNeighboringPoints, model, similarityMeasure, matcher);
        }
        catch (NoSuitablePointsException e) {
            return null;
        }
    }
}

