/*
 * Decompiled with CFR 0.152.
 */
package mpicbg.spim.postprocessing.deconvolution2;

import ij.ImageJ;
import java.util.ArrayList;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicInteger;
import mpicbg.imglib.algorithm.fft.FourierConvolution;
import mpicbg.imglib.container.ContainerFactory;
import mpicbg.imglib.container.array.Array;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.basictypecontainer.array.FloatArray;
import mpicbg.imglib.cursor.LocalizableByDimCursor;
import mpicbg.imglib.cursor.LocalizableByDimCursor3D;
import mpicbg.imglib.cursor.LocalizableCursor;
import mpicbg.imglib.cursor.array.ArrayLocalizableCursor;
import mpicbg.imglib.image.Image;
import mpicbg.imglib.image.ImageFactory;
import mpicbg.imglib.image.display.imagej.ImageJFunctions;
import mpicbg.imglib.io.LOCI;
import mpicbg.imglib.multithreading.Chunk;
import mpicbg.imglib.multithreading.SimpleMultiThreading;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyFactory;
import mpicbg.imglib.outofbounds.OutOfBoundsStrategyMirrorFactory;
import mpicbg.imglib.type.Type;
import mpicbg.imglib.type.numeric.real.FloatType;
import mpicbg.imglib.util.Util;
import spim.Threads;

public class Block {
    final int numDimensions;
    final int[] blockSize;
    final int[] offset;
    final int[] effectiveSize;
    final int[] effectiveOffset;
    final int[] effectiveLocalOffset;
    final boolean inside;
    final Vector<Chunk> threadChunks;
    final int numThreads;
    static final OutOfBoundsStrategyFactory<FloatType> factory = new OutOfBoundsStrategyMirrorFactory();

    public Block(int[] blockSize, int[] offset, int[] effectiveSize, int[] effectiveOffset, int[] effectiveLocalOffset, boolean inside) {
        this.numDimensions = blockSize.length;
        this.blockSize = (int[])blockSize.clone();
        this.offset = (int[])offset.clone();
        this.effectiveSize = (int[])effectiveSize.clone();
        this.effectiveOffset = (int[])effectiveOffset.clone();
        this.effectiveLocalOffset = (int[])effectiveLocalOffset.clone();
        this.inside = inside;
        this.numThreads = Threads.numThreads();
        long n = blockSize[0];
        for (int d = 1; d < this.numDimensions; ++d) {
            n *= (long)blockSize[d];
        }
        this.threadChunks = SimpleMultiThreading.divideIntoChunks((long)n, (int)this.numThreads);
    }

    public void copyBlock(final Image<FloatType> source, final Image<FloatType> block) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int threadIdx = ai.getAndIncrement();
                    Chunk myChunk = Block.this.threadChunks.get(threadIdx);
                    if (source.getNumDimensions() == 3 && Array.class.isInstance(source.getContainer()) && Array.class.isInstance(block.getContainer())) {
                        Block.copy3dArray(threadIdx, Block.this.numThreads, (Image<FloatType>)source, (Image<FloatType>)block, Block.this.offset, Block.this.inside, (OutOfBoundsStrategyFactory<FloatType>)factory);
                    } else if (source.getNumDimensions() == 3 && Array.class.isInstance(block.getContainer())) {
                        Block.copy3d(threadIdx, Block.this.numThreads, (Image<FloatType>)source, (Image<FloatType>)block, Block.this.offset, Block.this.inside, (OutOfBoundsStrategyFactory<FloatType>)factory);
                    } else {
                        Block.copy(myChunk.getStartPosition(), myChunk.getLoopSize(), (Image<FloatType>)source, (Image<FloatType>)block, Block.this.offset, Block.this.inside, (OutOfBoundsStrategyFactory<FloatType>)factory);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    private static final void copy(long start, long loopSize, Image<FloatType> source, Image<FloatType> block, int[] offset, boolean inside, OutOfBoundsStrategyFactory<FloatType> strategyFactory) {
        int numDimensions = source.getNumDimensions();
        LocalizableCursor cursor = block.createLocalizableCursor();
        LocalizableByDimCursor randomAccess = inside ? source.createLocalizableByDimCursor() : source.createLocalizableByDimCursor(strategyFactory);
        cursor.fwd(start);
        int[] tmp = new int[numDimensions];
        for (long l = 0L; l < loopSize; ++l) {
            cursor.fwd();
            cursor.getPosition(tmp);
            for (int d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + offset[d];
            }
            randomAccess.setPosition(tmp);
            ((FloatType)cursor.getType()).set((FloatType)randomAccess.getType());
        }
    }

    private static final void copy3dArray(int threadIdx, int numThreads, Image<FloatType> source, Image<FloatType> block, int[] offset, boolean inside, OutOfBoundsStrategyFactory<FloatType> strategyFactory) {
        int w = block.getDimension(0);
        int h = block.getDimension(1);
        int d = block.getDimension(2);
        int offsetX = offset[0];
        int offsetY = offset[1];
        int offsetZ = offset[2];
        float[] blockArray = ((FloatArray)((Array)block.getContainer()).update(null)).getCurrentStorageArray();
        LocalizableByDimCursor3D randomAccess = inside ? (LocalizableByDimCursor3D)source.createLocalizableByDimCursor() : (LocalizableByDimCursor3D)source.createLocalizableByDimCursor(strategyFactory);
        for (int z = threadIdx; z < d; z += numThreads) {
            randomAccess.setPosition(offsetX, offsetY, z + offsetZ);
            int i = z * h * w;
            for (int y = 0; y < h; ++y) {
                randomAccess.setPosition(offsetX, 0);
                for (int x = 0; x < w; ++x) {
                    blockArray[i++] = ((FloatType)randomAccess.getType()).get();
                    randomAccess.fwdX();
                }
                randomAccess.move(-w, 0);
                randomAccess.fwdY();
            }
        }
    }

    private static final void copy3d(int threadIdx, int numThreads, Image<FloatType> source, Image<FloatType> block, int[] offset, boolean inside, OutOfBoundsStrategyFactory<FloatType> strategyFactory) {
        int w = block.getDimension(0);
        int h = block.getDimension(1);
        int d = block.getDimension(2);
        int offsetX = offset[0];
        int offsetY = offset[1];
        int offsetZ = offset[2];
        float[] blockArray = ((FloatArray)((Array)block.getContainer()).update(null)).getCurrentStorageArray();
        LocalizableByDimCursor randomAccess = inside ? source.createLocalizableByDimCursor() : source.createLocalizableByDimCursor(strategyFactory);
        int[] tmp = new int[]{offsetX, offsetY, 0};
        for (int z = threadIdx; z < d; z += numThreads) {
            tmp[2] = z + offsetZ;
            randomAccess.setPosition(tmp);
            int i = z * h * w;
            for (int y = 0; y < h; ++y) {
                randomAccess.setPosition(offsetX, 0);
                for (int x = 0; x < w; ++x) {
                    blockArray[i++] = ((FloatType)randomAccess.getType()).get();
                    randomAccess.fwd(0);
                }
                randomAccess.move(-w, 0);
                randomAccess.fwd(1);
            }
        }
    }

    public void pasteBlock(final Image<FloatType> target, final Image<FloatType> block) {
        final AtomicInteger ai = new AtomicInteger(0);
        Thread[] threads = SimpleMultiThreading.newThreads((int)this.numThreads);
        for (int ithread = 0; ithread < threads.length; ++ithread) {
            threads[ithread] = new Thread(new Runnable(){

                @Override
                public void run() {
                    int threadIdx = ai.getAndIncrement();
                    Chunk myChunk = Block.this.threadChunks.get(threadIdx);
                    if (target.getNumDimensions() == 3 && Array.class.isInstance(target.getContainer())) {
                        Block.paste3d(threadIdx, Block.this.numThreads, (Image<FloatType>)target, (Image<FloatType>)block, Block.this.effectiveOffset, Block.this.effectiveSize, Block.this.effectiveLocalOffset);
                    } else {
                        Block.paste(myChunk.getStartPosition(), myChunk.getLoopSize(), (Image<FloatType>)target, (Image<FloatType>)block, Block.this.effectiveOffset, Block.this.effectiveSize, Block.this.effectiveLocalOffset);
                    }
                }
            });
        }
        SimpleMultiThreading.startAndJoin((Thread[])threads);
    }

    private static final void paste(long start, long loopSize, Image<FloatType> target, Image<FloatType> block, int[] effectiveOffset, int[] effectiveSize, int[] effectiveLocalOffset) {
        int numDimensions = target.getNumDimensions();
        ArrayLocalizableCursor cursor = ArrayLocalizableCursor.createLinearCursor((int[])effectiveSize);
        LocalizableByDimCursor blockRandomAccess = block.createLocalizableByDimCursor();
        LocalizableByDimCursor targetRandomAccess = target.createLocalizableByDimCursor();
        cursor.fwd(start);
        int[] tmp = new int[numDimensions];
        for (long l = 0L; l < loopSize; ++l) {
            int d;
            cursor.fwd();
            cursor.getPosition(tmp);
            for (d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + effectiveLocalOffset[d];
            }
            blockRandomAccess.setPosition(tmp);
            for (d = 0; d < numDimensions; ++d) {
                int n = d;
                tmp[n] = tmp[n] + (effectiveOffset[d] - effectiveLocalOffset[d]);
            }
            targetRandomAccess.setPosition(tmp);
            ((FloatType)targetRandomAccess.getType()).set((FloatType)blockRandomAccess.getType());
        }
    }

    private static final void paste3d(int threadIdx, int numThreads, Image<FloatType> target, Image<FloatType> block, int[] effectiveOffset, int[] effectiveSize, int[] effectiveLocalOffset) {
        int minX = effectiveOffset[0];
        int minY = effectiveOffset[1];
        int minZ = effectiveOffset[2];
        int maxX = effectiveSize[0] + minX;
        int maxY = effectiveSize[1] + minY;
        int maxZ = effectiveSize[2] + minZ;
        int sX = effectiveSize[0];
        int minXb = effectiveLocalOffset[0];
        int minYb = effectiveLocalOffset[1];
        int minZb = effectiveLocalOffset[2];
        int w = target.getDimension(0);
        int h = target.getDimension(1);
        int wb = block.getDimension(0);
        int hb = block.getDimension(1);
        float[] blockArray = ((FloatArray)((Array)block.getContainer()).update(null)).getCurrentStorageArray();
        float[] targetArray = ((FloatArray)((Array)target.getContainer()).update(null)).getCurrentStorageArray();
        for (int z = minZ + threadIdx; z < maxZ; z += numThreads) {
            int zBlock = z - minZ + minZb;
            int iTarget = z * h * w + minY * w + minX;
            int iBlock = zBlock * hb * wb + minYb * wb + minXb;
            for (int y = minY; y < maxY; ++y) {
                for (int x = minX; x < maxX; ++x) {
                    targetArray[iTarget++] = blockArray[iBlock++];
                }
                iTarget -= sX;
                iTarget += w;
                iBlock -= sX;
                iBlock += wb;
            }
        }
    }

    public static Block[] divideIntoBlocks(int[] imgSize, int[] blockSize, int[] kernelSize) {
        int numDimensions = imgSize.length;
        int[] effectiveSizeGeneral = new int[numDimensions];
        int[] effectiveLocalOffset = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            effectiveSizeGeneral[d] = blockSize[d] - kernelSize[d] + 1;
            if (effectiveSizeGeneral[d] <= 0) {
                System.out.println("Blocksize in dimension " + d + " (" + blockSize[d] + ") is smaller than the kernel (" + kernelSize[d] + ") which results in an negative effective size: " + effectiveSizeGeneral[d] + ", retrying with double the blocksize");
                int n = d;
                blockSize[n] = blockSize[n] * 2;
                return Block.divideIntoBlocks(imgSize, blockSize, kernelSize);
            }
            effectiveLocalOffset[d] = kernelSize[d] / 2;
        }
        int[] numBlocks = new int[numDimensions];
        for (int d = 0; d < numDimensions; ++d) {
            numBlocks[d] = imgSize[d] / effectiveSizeGeneral[d];
            if (imgSize[d] % effectiveSizeGeneral[d] == 0) continue;
            int n = d;
            numBlocks[n] = numBlocks[n] + 1;
        }
        System.out.println("imgSize " + Util.printCoordinates((int[])imgSize));
        System.out.println("kernelSize " + Util.printCoordinates((int[])kernelSize));
        System.out.println("blockSize " + Util.printCoordinates((int[])blockSize));
        System.out.println("numBlocks " + Util.printCoordinates((int[])numBlocks));
        System.out.println("effectiveSize " + Util.printCoordinates((int[])effectiveSizeGeneral));
        System.out.println("effectiveLocalOffset " + Util.printCoordinates((int[])effectiveLocalOffset));
        ArrayLocalizableCursor cursor = ArrayLocalizableCursor.createLinearCursor((int[])numBlocks);
        ArrayList<Block> blockList = new ArrayList<Block>();
        int[] currentBlock = new int[numDimensions];
        while (cursor.hasNext()) {
            cursor.fwd();
            cursor.getPosition(currentBlock);
            int[] offset = new int[numDimensions];
            int[] effectiveOffset = new int[numDimensions];
            int[] effectiveSize = (int[])effectiveSizeGeneral.clone();
            boolean inside = true;
            for (int d = 0; d < numDimensions; ++d) {
                effectiveOffset[d] = currentBlock[d] * effectiveSize[d];
                offset[d] = effectiveOffset[d] - kernelSize[d] / 2;
                if (offset[d] < 0 || offset[d] + blockSize[d] > imgSize[d]) {
                    inside = false;
                }
                if (effectiveOffset[d] + effectiveSize[d] <= imgSize[d]) continue;
                effectiveSize[d] = imgSize[d] - effectiveOffset[d];
            }
            blockList.add(new Block(blockSize, offset, effectiveSize, effectiveOffset, effectiveLocalOffset, inside));
        }
        Block[] blocks = new Block[blockList.size()];
        for (int i = 0; i < blockList.size(); ++i) {
            blocks[i] = (Block)blockList.get(i);
        }
        return blocks;
    }

    public static void main(String[] args) {
        new ImageJ();
        Image img = LOCI.openLOCIFloatType((String)"/Users/preibischs/Desktop/spim.tif", (ContainerFactory)new ArrayContainerFactory());
        Image kernel = FourierConvolution.createGaussianKernel((ContainerFactory)img.getContainerFactory(), (double[])new double[]{10.0, 10.0, 10.0});
        int[] imgSize = img.getDimensions();
        int[] blockSize = new int[]{256, 256, 256};
        int[] kernelSize = kernel.getDimensions();
        Block[] blocks = Block.divideIntoBlocks(imgSize, blockSize, kernelSize);
        ArrayList<Image> blockImgs = new ArrayList<Image>();
        ImageFactory factory = new ImageFactory((Type)new FloatType(), (ContainerFactory)new ArrayContainerFactory());
        ImageJFunctions.show((Image)img);
        for (int i = 0; i < blocks.length; ++i) {
            blockImgs.add(factory.createImage(blockSize));
        }
        long time = 0L;
        time = System.currentTimeMillis();
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i].copyBlock((Image<FloatType>)img, (Image<FloatType>)((Image)blockImgs.get(i)));
        }
        System.out.println(System.currentTimeMillis() - time);
        Image img2 = img.createNewImage();
        time = System.currentTimeMillis();
        for (int i = 0; i < blocks.length; ++i) {
            blocks[i].pasteBlock((Image<FloatType>)img2, (Image<FloatType>)((Image)blockImgs.get(i)));
        }
        System.out.println(System.currentTimeMillis() - time);
        ImageJFunctions.show((Image)img2);
    }
}

