/*
 * Decompiled with CFR 0.152.
 */
package fiji.plugin;

import fiji.plugin.Bead_Registration;
import fiji.plugin.Multi_View_Deconvolution;
import fiji.util.gui.GenericDialogPlus;
import ij.IJ;
import ij.gui.DialogListener;
import ij.gui.GenericDialog;
import ij.gui.MultiLineLabel;
import ij.plugin.PlugIn;
import java.awt.AWTEvent;
import java.awt.TextField;
import java.awt.event.TextEvent;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import mpicbg.imglib.container.array.ArrayContainerFactory;
import mpicbg.imglib.container.cell.CellContainerFactory;
import mpicbg.spim.Reconstruction;
import mpicbg.spim.io.ConfigurationParserException;
import mpicbg.spim.io.IOFunctions;
import mpicbg.spim.io.SPIMConfiguration;
import mpicbg.spim.io.TextFileAccess;
import spim.fiji.plugin.util.GUIHelper;
import spimopener.SPIMExperiment;

public class Multi_View_Fusion
implements PlugIn {
    private final String myURL = "http://fly.mpi-cbg.de/preibisch";
    private final String paperURL = "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html";
    static final String[] fusionType = new String[]{"Single-channel", "Multi-channel"};
    static final String[] outputType = new String[]{"Display only", "Save 2d-slices, all in one directory", "Save 2d-slices, one directory per time-point"};
    public static int defaultFusionType = 0;
    public static String[] fusionMethodList = new String[]{"Fuse into a single image", "Create independent registered images"};
    public static int defaultFusionMethod = 0;
    public static int defaultParalellViews = 0;
    public static boolean fusionUseBlendingStatic = true;
    public static boolean fusionUseContentBasedStatic = false;
    public static boolean fusionUseContentBasedIntegralStatic = false;
    public static int defaultOutputType = 1;
    public static int outputImageScalingStatic = 1;
    public static int cropOffsetXStatic = 0;
    public static int cropOffsetYStatic = 0;
    public static int cropOffsetZStatic = 0;
    public static int cropSizeXStatic = 0;
    public static int cropSizeYStatic = 0;
    public static int cropSizeZStatic = 0;

    public void run(String arg0) {
        int channelChoice;
        IOFunctions.printIJLog = true;
        GenericDialog gd = new GenericDialog("Multi-view fusion");
        gd.addChoice("Select_channel type", fusionType, fusionType[defaultFusionType]);
        gd.addMessage("Please note that the Multi-view fusion is based on a publication.\nIf you use it successfully for your research please be so kind to cite our work:\nPreibisch et al., Nature Methods (2010), 7(6):418-419\n");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://www.nature.com/nmeth/journal/v7/n6/full/nmeth0610-418.html");
        gd.showDialog();
        if (gd.wasCanceled()) {
            return;
        }
        defaultFusionType = channelChoice = gd.getNextChoiceIndex();
        SPIMConfiguration conf = channelChoice == 0 ? this.getParameters(false) : this.getParameters(true);
        if (conf == null) {
            return;
        }
        conf.readSegmentation = true;
        conf.readRegistration = true;
        new Reconstruction(conf);
    }

    protected SPIMConfiguration getParameters(final boolean multichannel) {
        int c;
        int c2;
        Object name;
        ArrayList<Object> channels;
        int c3;
        TextField tfChannels;
        GenericDialogPlus gd = new GenericDialogPlus("Multi-View Fusion");
        gd.addDirectoryOrFileField("SPIM_data_directory", Bead_Registration.spimDataDirectory);
        final TextField tfSpimDataDirectory = (TextField)gd.getStringFields().lastElement();
        if (multichannel) {
            gd.addStringField("Pattern_of_SPIM files", Bead_Registration.fileNamePatternMC, 25);
        } else {
            gd.addStringField("Pattern_of_SPIM files", Bead_Registration.fileNamePattern, 25);
        }
        final TextField tfFilePattern = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Timepoints_to_process", Bead_Registration.timepoints);
        final TextField tfTimepoints = (TextField)gd.getStringFields().lastElement();
        gd.addStringField("Angles to process", Bead_Registration.angles);
        final TextField tfAngles = (TextField)gd.getStringFields().lastElement();
        if (multichannel) {
            gd.addStringField("Channels to process", Bead_Registration.channelsBeadsMC);
            tfChannels = (TextField)gd.getStringFields().lastElement();
        } else {
            tfChannels = null;
        }
        gd.addMessage("");
        gd.addChoice("ImgLib_container_(input files)", Multi_View_Deconvolution.imglibContainer, Multi_View_Deconvolution.imglibContainer[Multi_View_Deconvolution.defaultContainerInput]);
        gd.addMessage("");
        gd.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        MultiLineLabel text = (MultiLineLabel)gd.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd.addDialogListener(new DialogListener(){

            public boolean dialogItemChanged(GenericDialog dialog, AWTEvent e) {
                if (e instanceof TextEvent && e.getID() == 900 && e.getSource() == tfSpimDataDirectory) {
                    TextField tf = (TextField)e.getSource();
                    String spimDataDirectory = tf.getText();
                    File f = new File(spimDataDirectory);
                    if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
                        SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                        tfFilePattern.setEnabled(false);
                        String expTimepoints = "";
                        expTimepoints = exp.timepointStart == exp.timepointEnd ? "" + exp.timepointStart : "" + exp.timepointStart + "-" + exp.timepointEnd;
                        tfTimepoints.setText(expTimepoints);
                        String expAngles = "";
                        for (String angle : exp.angles) {
                            int a = Integer.parseInt(angle.substring(1, angle.length()));
                            if (!expAngles.equals("")) {
                                expAngles = expAngles + ",";
                            }
                            expAngles = expAngles + a;
                        }
                        tfAngles.setText(expAngles);
                        if (multichannel) {
                            String expChannels = "";
                            for (String channel : exp.channels) {
                                int c = Integer.parseInt(channel.substring(1, channel.length()));
                                if (!expChannels.equals("")) {
                                    expChannels = expChannels + ",";
                                }
                                expChannels = expChannels + c;
                            }
                            tfChannels.setText(expChannels);
                        }
                    } else {
                        tfFilePattern.setEnabled(true);
                    }
                }
                return true;
            }
        });
        File f = new File(tfSpimDataDirectory.getText());
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            tfFilePattern.setEnabled(false);
            if (multichannel) {
                SPIMExperiment exp = new SPIMExperiment(f.getAbsolutePath());
                String expChannels = "";
                for (String channel : exp.channels) {
                    c3 = Integer.parseInt(channel.substring(1, channel.length()));
                    if (!expChannels.equals("")) {
                        expChannels = expChannels + ",";
                    }
                    expChannels = expChannels + c3;
                }
                tfChannels.setText(expChannels);
            }
        }
        gd.showDialog();
        if (gd.wasCanceled()) {
            return null;
        }
        Bead_Registration.spimDataDirectory = gd.getNextString();
        if (multichannel) {
            Bead_Registration.fileNamePatternMC = gd.getNextString();
        } else {
            Bead_Registration.fileNamePattern = gd.getNextString();
        }
        Bead_Registration.timepoints = gd.getNextString();
        Bead_Registration.angles = gd.getNextString();
        Multi_View_Deconvolution.defaultContainerInput = gd.getNextChoiceIndex();
        int numViews = 0;
        try {
            numViews = SPIMConfiguration.parseIntegerString(Bead_Registration.angles).size();
        }
        catch (ConfigurationParserException e) {
            IOFunctions.printErr("Cannot understand/parse the channels: " + Bead_Registration.angles);
            return null;
        }
        int numChannels = 0;
        if (multichannel) {
            Bead_Registration.channelsBeadsMC = gd.getNextString();
            try {
                channels = SPIMConfiguration.parseIntegerString(Bead_Registration.channelsBeadsMC);
                numChannels = channels.size();
            }
            catch (ConfigurationParserException e) {
                IOFunctions.printErr("Cannot understand/parse the channels: " + Bead_Registration.channelsBeadsMC);
                return null;
            }
            if (numChannels < 1) {
                IOFunctions.printErr("There are no channels given: " + Bead_Registration.channelsBeadsMC);
                return null;
            }
        } else {
            numChannels = 1;
            channels = new ArrayList();
            channels.add(0);
        }
        SPIMConfiguration conf = new SPIMConfiguration();
        conf.inputImageFactory = Multi_View_Deconvolution.defaultContainerInput == 1 ? new CellContainerFactory(256) : new ArrayContainerFactory();
        conf.timepointPattern = Bead_Registration.timepoints;
        conf.anglePattern = Bead_Registration.angles;
        if (multichannel) {
            conf.channelPattern = Bead_Registration.channelsBeadsMC;
            conf.channelsToRegister = Bead_Registration.channelsBeadsMC;
            conf.channelsToFuse = Bead_Registration.channelsBeadsMC;
            conf.inputFilePattern = Bead_Registration.fileNamePatternMC;
        } else {
            conf.channelPattern = "";
            conf.channelsToRegister = "";
            conf.channelsToFuse = "";
            conf.inputFilePattern = Bead_Registration.fileNamePattern;
        }
        f = new File(Bead_Registration.spimDataDirectory);
        if (f.exists() && f.isFile() && f.getName().endsWith(".xml")) {
            conf.spimExperiment = new SPIMExperiment(f.getAbsolutePath());
            conf.inputdirectory = f.getAbsolutePath().substring(0, f.getAbsolutePath().length() - 4);
            System.out.println("inputdirectory : " + conf.inputdirectory);
        } else {
            conf.inputdirectory = Bead_Registration.spimDataDirectory;
        }
        conf.fuseOnly = true;
        if (!Bead_Registration.init(conf)) {
            return null;
        }
        ArrayList timepoints = new ArrayList();
        int numChoices = 0;
        conf.zStretching = -1.0;
        for (c3 = 0; c3 < channels.size(); ++c3) {
            String[] entries;
            timepoints.add(new ArrayList());
            name = conf.file[0][c3][0][0].getName();
            File regDir = new File(conf.registrationFiledirectory);
            IJ.log((String)("name: " + (String)name));
            IJ.log((String)("dir: " + regDir.getAbsolutePath()));
            if (!regDir.isDirectory()) {
                IOFunctions.println(conf.registrationFiledirectory + " is not a directory. ");
                return null;
            }
            for (String e : entries = regDir.list(new FilenameFilter((String)name){
                final /* synthetic */ String val$name;
                {
                    this.val$name = string;
                }

                @Override
                public boolean accept(File directory, String filename) {
                    return filename.contains(this.val$name) && filename.contains(".registration");
                }
            })) {
                IJ.log((String)e);
            }
            for (String s : entries) {
                if (s.endsWith(".registration")) {
                    if (!((ArrayList)timepoints.get(c3)).contains(-1)) {
                        ((ArrayList)timepoints.get(c3)).add(-1);
                        ++numChoices;
                    }
                } else if (s.contains(".registration.to_")) {
                    int timepoint = Integer.parseInt(s.substring(s.indexOf(".registration.to_") + 17, s.length()));
                    if (!((ArrayList)timepoints.get(c3)).contains(timepoint)) {
                        ((ArrayList)timepoints.get(c3)).add(timepoint);
                        ++numChoices;
                    }
                }
                if (!(conf.zStretching < 0.0)) continue;
                conf.zStretching = Multi_View_Fusion.loadZStretching(conf.registrationFiledirectory + s);
                IOFunctions.println("Z-stretching = " + conf.zStretching);
            }
        }
        if (numChoices == 0) {
            IOFunctions.println("No registration files available.");
            return null;
        }
        for (c3 = 0; c3 < channels.size(); ++c3) {
            name = ((ArrayList)timepoints.get(c3)).iterator();
            while (name.hasNext()) {
                int i = (Integer)name.next();
                IOFunctions.println(c3 + ": " + i);
            }
        }
        GenericDialog gd2 = new GenericDialog("Multi-View Fusion");
        String[] choices = new String[numChoices];
        int[] suggest = new int[channels.size()];
        int firstSuggestion = -1;
        int index = 0;
        for (c2 = 0; c2 < channels.size(); ++c2) {
            ArrayList tps = (ArrayList)timepoints.get(c2);
            suggest[c2] = -1;
            for (int i = 0; i < tps.size(); ++i) {
                choices[index] = (Integer)tps.get(i) == -1 ? "Individual registration of channel " + channels.get(c2) : "Time-point registration (reference=" + tps.get(i) + ") of channel " + channels.get(c2);
                if (suggest[c2] == -1) {
                    suggest[c2] = index;
                    if (firstSuggestion == -1) {
                        firstSuggestion = index;
                    }
                }
                ++index;
            }
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            if (suggest[c2] != -1) continue;
            suggest[c2] = firstSuggestion;
        }
        for (c2 = 0; c2 < channels.size(); ++c2) {
            gd2.addChoice("Registration for channel " + channels.get(c2), choices, choices[suggest[c2]]);
        }
        gd2.addMessage("");
        gd2.addChoice("Fusion_method", fusionMethodList, fusionMethodList[defaultFusionMethod]);
        String[] views = new String[numViews];
        views[0] = "All";
        for (int v = 1; v < numViews; ++v) {
            views[v] = "" + v;
        }
        if (defaultParalellViews >= views.length) {
            defaultParalellViews = views.length - 1;
        }
        gd2.addChoice("Process_views_in_paralell", views, views[defaultParalellViews]);
        gd2.addMessage("");
        gd2.addCheckbox("Blending", fusionUseBlendingStatic);
        gd2.addCheckbox("Content_based weights", fusionUseContentBasedStatic);
        gd2.addCheckbox("Content_based_weights_(fast, approximate)", fusionUseContentBasedIntegralStatic);
        gd2.addMessage("");
        gd2.addNumericField("Downsample_output image n-times", (double)outputImageScalingStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_x", (double)cropOffsetXStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_y", (double)cropOffsetYStatic, 0);
        gd2.addNumericField("Crop_output_image_offset_z", (double)cropOffsetZStatic, 0);
        gd2.addNumericField("Crop_output_image_size_x", (double)cropSizeXStatic, 0);
        gd2.addNumericField("Crop_output_image_size_y", (double)cropSizeYStatic, 0);
        gd2.addNumericField("Crop_output_image_size_z", (double)cropSizeZStatic, 0);
        gd2.addMessage("");
        gd2.addChoice("Fused_image_output", outputType, outputType[defaultOutputType]);
        gd2.addMessage("");
        gd2.addMessage("This Plugin is developed by Stephan Preibisch\nhttp://fly.mpi-cbg.de/preibisch");
        text = (MultiLineLabel)gd2.getMessage();
        GUIHelper.addHyperLinkListener(text, "http://fly.mpi-cbg.de/preibisch");
        gd2.showDialog();
        if (gd2.wasCanceled()) {
            return null;
        }
        int[][] registrationAssignment = new int[channels.size()][2];
        for (int c4 = 0; c4 < channels.size(); ++c4) {
            int choice = gd2.getNextChoiceIndex();
            index = 0;
            for (int c22 = 0; c22 < channels.size(); ++c22) {
                ArrayList tps = (ArrayList)timepoints.get(c22);
                for (int i = 0; i < tps.size(); ++i) {
                    if (index == choice) {
                        registrationAssignment[c4][0] = (Integer)tps.get(i);
                        registrationAssignment[c4][1] = c22;
                    }
                    ++index;
                }
            }
        }
        int tp = registrationAssignment[0][0];
        for (c = 1; c < channels.size(); ++c) {
            if (tp == registrationAssignment[c][0]) continue;
            IOFunctions.println("Inconsistent choice of reference timeseries, only same reference timepoints or individual registration are allowed.");
            return null;
        }
        conf.registrationAssignmentForFusion = new int[channels.size()];
        for (c = 0; c < channels.size(); ++c) {
            IOFunctions.println("channel " + c + " takes it from channel " + registrationAssignment[c][1]);
            conf.registrationAssignmentForFusion[c] = registrationAssignment[c][1];
        }
        if (tp >= 0) {
            conf.timeLapseRegistration = true;
            conf.referenceTimePoint = tp;
            ArrayList<Integer> tpList = null;
            try {
                tpList = SPIMConfiguration.parseIntegerString(conf.timepointPattern);
            }
            catch (ConfigurationParserException e) {
                e.printStackTrace();
                IJ.log((String)("Cannot parse time-point pattern: " + conf.timepointPattern));
                return null;
            }
            if (!tpList.contains(tp)) {
                conf.timepointPattern = conf.timepointPattern + ", " + tp;
                conf.fuseReferenceTimepoint = false;
                if (!Bead_Registration.init(conf)) {
                    return null;
                }
            }
        }
        IOFunctions.println("tp " + tp);
        defaultFusionMethod = gd2.getNextChoiceIndex();
        defaultParalellViews = gd2.getNextChoiceIndex();
        fusionUseBlendingStatic = gd2.getNextBoolean();
        fusionUseContentBasedStatic = gd2.getNextBoolean();
        fusionUseContentBasedIntegralStatic = gd2.getNextBoolean();
        outputImageScalingStatic = (int)Math.round(gd2.getNextNumber());
        cropOffsetXStatic = (int)Math.round(gd2.getNextNumber());
        cropOffsetYStatic = (int)Math.round(gd2.getNextNumber());
        cropOffsetZStatic = (int)Math.round(gd2.getNextNumber());
        cropSizeXStatic = (int)Math.round(gd2.getNextNumber());
        cropSizeYStatic = (int)Math.round(gd2.getNextNumber());
        cropSizeZStatic = (int)Math.round(gd2.getNextNumber());
        defaultOutputType = gd2.getNextChoiceIndex();
        conf.paralellFusion = false;
        conf.sequentialFusion = false;
        conf.multipleImageFusion = false;
        if (defaultFusionMethod == 0 && defaultParalellViews == 0) {
            conf.paralellFusion = true;
        } else if (defaultFusionMethod == 0 && defaultParalellViews > 0) {
            conf.sequentialFusion = true;
            conf.numParalellViews = defaultParalellViews;
        } else {
            conf.multipleImageFusion = true;
            conf.numParalellViews = defaultParalellViews == 0 ? views.length : defaultParalellViews;
        }
        conf.showOutputImage = defaultOutputType == 0;
        conf.writeOutputImage = defaultOutputType;
        conf.useLinearBlening = fusionUseBlendingStatic;
        conf.useGaussContentBased = fusionUseContentBasedStatic;
        conf.useIntegralContentBased = fusionUseContentBasedIntegralStatic;
        conf.scale = outputImageScalingStatic;
        conf.cropOffsetX = cropOffsetXStatic;
        conf.cropOffsetY = cropOffsetYStatic;
        conf.cropOffsetZ = cropOffsetZStatic;
        conf.cropSizeX = cropSizeXStatic;
        conf.cropSizeY = cropSizeYStatic;
        conf.cropSizeZ = cropSizeZStatic;
        conf.processImageFactory = new CellContainerFactory(256);
        conf.overrideImageZStretching = true;
        return conf;
    }

    protected static double loadZStretching(String file) {
        BufferedReader in = TextFileAccess.openFileRead(file);
        double z = -1.0;
        try {
            while (in.ready()) {
                String line = in.readLine();
                if (!line.contains("z-scaling:")) continue;
                z = Double.parseDouble(line.substring(line.indexOf("ing") + 4, line.length()).trim());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return z;
    }
}

