/*
 * Decompiled with CFR 0.152.
 */
package org.lsmp.djep.vectorJep.function;

import java.util.Stack;
import org.lsmp.djep.vectorJep.Dimensions;
import org.lsmp.djep.vectorJep.function.BinaryOperatorI;
import org.lsmp.djep.vectorJep.values.MVector;
import org.lsmp.djep.vectorJep.values.Matrix;
import org.lsmp.djep.vectorJep.values.MatrixValueI;
import org.lsmp.djep.vectorJep.values.Scaler;
import org.lsmp.djep.vectorJep.values.Tensor;
import org.nfunk.jep.ParseException;
import org.nfunk.jep.function.PostfixMathCommand;

public class VEle
extends PostfixMathCommand
implements BinaryOperatorI {
    public VEle() {
        this.numberOfParameters = 2;
    }

    @Override
    public Dimensions calcDim(Dimensions ldim, Dimensions rdim) throws ParseException {
        return Dimensions.ONE;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public MatrixValueI calcValue(MatrixValueI res, MatrixValueI param1, MatrixValueI param2) throws ParseException {
        if (param1 instanceof MVector) {
            if (param2 instanceof Scaler) {
                int index = ((Number)param2.getEle(0)).intValue() - 1;
                Object val = ((MVector)param1).getEle(index);
                res.setEle(0, val);
                return res;
            } else {
                if (!(param2 instanceof MVector)) throw new ParseException("Bad second argument to ele, expecting a double " + param2.toString());
                MVector vec = (MVector)param2;
                if (!vec.getDim().equals(Dimensions.ONE)) return res;
                int d1 = ((Number)vec.getEle(0)).intValue();
                if (d1 < 1 || d1 > ((MVector)param1).getNumEles()) {
                    throw new ParseException("ArrayAccess: array indices " + d1 + " out of range 1.." + param1.getDim());
                }
                Object val = ((MVector)param1).getEle(d1 - 1);
                res.setEle(0, val);
            }
            return res;
        } else if (param1 instanceof Matrix) {
            if (!(param2 instanceof MVector)) throw new ParseException("Bad second argument to ele, expecting [i,j] " + param2.toString());
            MVector vec = (MVector)param2;
            if (!vec.getDim().equals(Dimensions.TWO)) return res;
            int d1 = ((Number)vec.getEle(0)).intValue();
            int d2 = ((Number)vec.getEle(1)).intValue();
            if (d1 < 1 || d1 > ((Matrix)param1).getNumRows() || d2 < 1 || d2 > ((Matrix)param1).getNumCols()) {
                throw new ParseException("ArrayAccess: array indices " + d1 + ", " + d2 + " out of range 1.." + param1.getDim());
            }
            Object val = ((Matrix)param1).getEle(d1 - 1, d2 - 1);
            res.setEle(0, val);
            return res;
        } else {
            if (!(param1 instanceof Tensor)) throw new ParseException("ele requires a vector matrix or tensor for first argument it has " + param1.toString());
            throw new ParseException("Sorry don't know how to find elements for a tensor");
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void run(Stack stack) throws ParseException {
        this.checkStack(stack);
        Object param2 = stack.pop();
        Object param1 = stack.pop();
        if (param1 instanceof MVector) {
            MVector vec;
            if (param2 instanceof Number) {
                Object val = ((MVector)param1).getEle(((Number)param2).intValue() - 1);
                stack.push(val);
                return;
            }
            if (!(param2 instanceof MVector) || !(vec = (MVector)param2).getDim().equals(Dimensions.ONE)) throw new ParseException("Bad second argument to ele, expecting a double " + param2.toString());
            int d1 = ((Number)vec.getEle(0)).intValue();
            if (d1 < 1 || d1 > ((MVector)param1).getNumEles()) {
                throw new ParseException("ArrayAccess: array indices " + d1 + " out of range 1.." + ((MVector)param1).getDim());
            }
            Object val = ((MVector)param1).getEle(d1 - 1);
            stack.push(val);
            return;
        }
        if (param1 instanceof Matrix) {
            if (!(param2 instanceof MVector)) throw new ParseException("Bad second argument to ele, expecting [i,j] " + param2.toString());
            MVector vec = (MVector)param2;
            if (!vec.getDim().equals(Dimensions.TWO)) throw new ParseException("ele requires a vector matrix or tensor for first argument it has " + param1.toString());
            int d1 = ((Number)vec.getEle(0)).intValue();
            int d2 = ((Number)vec.getEle(1)).intValue();
            if (d1 < 1 || d1 > ((Matrix)param1).getNumRows() || d2 < 1 || d2 > ((Matrix)param1).getNumCols()) {
                throw new ParseException("ArrayAccess: array indices " + d1 + ", " + d2 + " out of range 1.." + ((Matrix)param1).getDim());
            }
            Object val = ((Matrix)param1).getEle(d1 - 1, d2 - 1);
            stack.push(val);
            return;
        }
        if (!(param1 instanceof Tensor)) throw new ParseException("ele requires a vector matrix or tensor for first argument it has " + param1.toString());
        throw new ParseException("Sorry don't know how to find elements for a tensor");
    }
}

