/*
 * Decompiled with CFR 0.152.
 */
package mmorpho;

import ij.IJ;
import mmorpho.Constants;

public class LocalHistogram
implements Constants {
    private static final int MAX = 255;
    private static final int MIN = 0;
    private int[] counts = new int[256];
    private int min = 0;
    private int max = 255;
    private int binCount = 0;

    public LocalHistogram(int[] cnt) {
        this.counts = cnt;
    }

    public LocalHistogram() {
    }

    public LocalHistogram(int index, int width, int height, byte[] pixels, int[][] pg, int type) {
        int binCount = Math.min(pg.length, 256);
        this.counts = new int[256];
        this.init(index, width, height, pixels, pg, type);
    }

    public void init(int index, int width, int height, byte[] pixels, int[][] pg, int type) {
        int[] histogram = new int[256];
        int k = 0;
        int y = 0;
        int bin = 0;
        int i = index / width;
        int j = index % width;
        int tmin = 255;
        int tmax = 0;
        for (int g = 0; g < pg.length; ++g) {
            y = i + pg[g][0];
            int x = j + pg[g][1];
            try {
                k = x >= width || y >= height || x < 0 || y < 0 ? (type == 0 ? 0 : 255) : pixels[x + width * y] & 0xFF;
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                k = x + width * y;
                IJ.log((String)("AIOB x: " + x + " y: " + y + " index: " + k));
            }
            bin = type == 0 ? k + pg[g][2] - 255 : k - pg[g][2] + 255;
            if (tmin > bin) {
                tmin = bin;
            }
            if (tmax < bin) {
                tmax = bin;
            }
            int n = bin;
            histogram[n] = histogram[n] + 1;
        }
        this.min = tmin;
        this.max = tmax;
        this.counts = histogram;
    }

    public void Log() {
        StringBuffer sb = new StringBuffer(200);
        for (int h = 0; h <= 255; ++h) {
            if (this.counts[h] == 0) continue;
            sb.append(h + " " + this.counts[h] + " \n");
        }
        IJ.write((String)("histogram +\n" + sb.toString() + "\n"));
    }

    public int[] getCounts() {
        return this.counts;
    }

    public void count() {
        int counter = 0;
        for (int i = 0; i < 256; ++i) {
            if (this.counts[i] < 0) continue;
            ++counter;
        }
        this.binCount = counter;
    }

    public int getBinCount() {
        return this.binCount;
    }

    public int getMaximum() {
        return this.max;
    }

    public int getMinimum() {
        return this.min;
    }

    public void doMaximum() {
        int smax;
        for (smax = this.max; this.counts[smax] == 0 && smax >= 0; --smax) {
        }
        this.max = smax;
    }

    public void doMinimum() {
        int smin;
        for (smin = this.min; this.counts[smin] == 0 && smin <= 255; ++smin) {
        }
        this.min = smin;
    }

    public void add(LocalHistogram bh) {
        int u = Math.min(this.min, bh.min);
        int v = Math.max(this.max, bh.max);
        this.binCount = Math.max(this.binCount, bh.binCount);
        for (int i = u; i <= v; ++i) {
            this.counts[i] = this.counts[i] + bh.counts[i];
        }
        this.min = u;
        this.max = v;
    }

    public void sub(LocalHistogram bh) {
        int u = Math.min(this.min, bh.min);
        int v = Math.max(this.max, bh.max);
        boolean cnt = false;
        int tmin = u;
        int tmax = v;
        for (int i = u; i <= v; ++i) {
            this.counts[i] = this.counts[i] - bh.counts[i];
            if (this.counts[i] >= 0) continue;
            this.counts[i] = 0;
        }
        while (this.counts[tmin] == 0 && tmin < u) {
            ++tmin;
        }
        while (this.counts[tmax] == 0 && tmax > tmin) {
            --tmax;
        }
        this.min = tmin;
        this.max = tmax;
    }
}

