/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import net.imglib2.Dimensions;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.Cache;
import net.imglib2.cache.LoaderCache;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.cache.img.DiskCachedCellImgFactory;
import net.imglib2.cache.img.DiskCachedCellImgOptions;
import net.imglib2.cache.ref.BoundedSoftRefLoaderCache;
import net.imglib2.cache.ref.SoftRefLoaderCache;
import net.imglib2.exception.ImgLibException;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.AccessFlags;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.DataAccess;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.iterator.IntervalIterator;
import net.imglib2.loops.LoopBuilder;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.label.LabelMultisetType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.util.ValuePair;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Exception;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5CacheLoader;
import org.janelia.saalfeldlab.n5.imglib2.N5CellLoader;
import org.janelia.saalfeldlab.n5.imglib2.N5LabelMultisets;

public class N5Utils {
    private N5Utils() {
    }

    public static final <T extends NativeType<T>> DataType dataType(T type) {
        if (DoubleType.class.isInstance(type)) {
            return DataType.FLOAT64;
        }
        if (FloatType.class.isInstance(type)) {
            return DataType.FLOAT32;
        }
        if (LongType.class.isInstance(type)) {
            return DataType.INT64;
        }
        if (UnsignedLongType.class.isInstance(type)) {
            return DataType.UINT64;
        }
        if (IntType.class.isInstance(type)) {
            return DataType.INT32;
        }
        if (UnsignedIntType.class.isInstance(type)) {
            return DataType.UINT32;
        }
        if (ShortType.class.isInstance(type)) {
            return DataType.INT16;
        }
        if (UnsignedShortType.class.isInstance(type)) {
            return DataType.UINT16;
        }
        if (ByteType.class.isInstance(type)) {
            return DataType.INT8;
        }
        if (UnsignedByteType.class.isInstance(type)) {
            return DataType.UINT8;
        }
        return null;
    }

    public static final <T extends NativeType<T>> T type(DataType dataType) {
        switch (dataType) {
            case INT8: {
                return (T)new ByteType();
            }
            case UINT8: {
                return (T)new UnsignedByteType();
            }
            case INT16: {
                return (T)new ShortType();
            }
            case UINT16: {
                return (T)new UnsignedShortType();
            }
            case INT32: {
                return (T)new IntType();
            }
            case UINT32: {
                return (T)new UnsignedIntType();
            }
            case INT64: {
                return (T)new LongType();
            }
            case UINT64: {
                return (T)new UnsignedLongType();
            }
            case FLOAT32: {
                return (T)new FloatType();
            }
            case FLOAT64: {
                return (T)new DoubleType();
            }
        }
        return null;
    }

    private static final DataBlock<?> createDataBlock(RandomAccessibleInterval<?> source, DataType dataType, int[] intBlockSize, long[] longBlockSize, long[] gridPosition) {
        DataBlock dataBlock = dataType.createDataBlock(intBlockSize, gridPosition);
        switch (dataType) {
            case UINT8: {
                N5CellLoader.burnIn(source, ArrayImgs.unsignedBytes((byte[])((byte[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case INT8: {
                N5CellLoader.burnIn(source, ArrayImgs.bytes((byte[])((byte[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case UINT16: {
                N5CellLoader.burnIn(source, ArrayImgs.unsignedShorts((short[])((short[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case INT16: {
                N5CellLoader.burnIn(source, ArrayImgs.shorts((short[])((short[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case UINT32: {
                N5CellLoader.burnIn(source, ArrayImgs.unsignedInts((int[])((int[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case INT32: {
                N5CellLoader.burnIn(source, ArrayImgs.ints((int[])((int[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case UINT64: {
                N5CellLoader.burnIn(source, ArrayImgs.unsignedLongs((long[])((long[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case INT64: {
                N5CellLoader.burnIn(source, ArrayImgs.longs((long[])((long[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case FLOAT32: {
                N5CellLoader.burnIn(source, ArrayImgs.floats((float[])((float[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            case FLOAT64: {
                N5CellLoader.burnIn(source, ArrayImgs.doubles((double[])((double[])dataBlock.getData()), (long[])longBlockSize));
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + dataType.name() + " not supported!");
            }
        }
        return dataBlock;
    }

    private static final <T extends Type<T>> DataBlock<?> createNonEmptyDataBlock(RandomAccessibleInterval<?> source, DataType dataType, int[] intBlockSize, long[] longBlockSize, long[] gridPosition, T defaultValue) {
        boolean isEmpty;
        DataBlock dataBlock = dataType.createDataBlock(intBlockSize, gridPosition);
        switch (dataType) {
            case UINT8: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.unsignedBytes((byte[])((byte[])dataBlock.getData()), (long[])longBlockSize), (UnsignedByteType)defaultValue);
                break;
            }
            case INT8: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.bytes((byte[])((byte[])dataBlock.getData()), (long[])longBlockSize), (ByteType)defaultValue);
                break;
            }
            case UINT16: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.unsignedShorts((short[])((short[])dataBlock.getData()), (long[])longBlockSize), (UnsignedShortType)defaultValue);
                break;
            }
            case INT16: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.shorts((short[])((short[])dataBlock.getData()), (long[])longBlockSize), (ShortType)defaultValue);
                break;
            }
            case UINT32: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.unsignedInts((int[])((int[])dataBlock.getData()), (long[])longBlockSize), (UnsignedIntType)defaultValue);
                break;
            }
            case INT32: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.ints((int[])((int[])dataBlock.getData()), (long[])longBlockSize), (IntType)defaultValue);
                break;
            }
            case UINT64: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.unsignedLongs((long[])((long[])dataBlock.getData()), (long[])longBlockSize), (UnsignedLongType)defaultValue);
                break;
            }
            case INT64: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.longs((long[])((long[])dataBlock.getData()), (long[])longBlockSize), (LongType)defaultValue);
                break;
            }
            case FLOAT32: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.floats((float[])((float[])dataBlock.getData()), (long[])longBlockSize), (FloatType)defaultValue);
                break;
            }
            case FLOAT64: {
                isEmpty = N5CellLoader.burnInTestAllEqual(source, ArrayImgs.doubles((double[])((double[])dataBlock.getData()), (long[])longBlockSize), (DoubleType)defaultValue);
                break;
            }
            default: {
                throw new IllegalArgumentException("Type " + dataType.name() + " not supported!");
            }
        }
        return isEmpty ? null : dataBlock;
    }

    static void cropBlockDimensions(long[] max, long[] offset, int[] blockDimensions, long[] croppedBlockDimensions, int[] intCroppedBlockDimensions, long[] gridPosition) {
        for (int d = 0; d < max.length; ++d) {
            croppedBlockDimensions[d] = Math.min((long)blockDimensions[d], max[d] - offset[d] + 1L);
            intCroppedBlockDimensions[d] = (int)croppedBlockDimensions[d];
            gridPosition[d] = offset[d] / (long)blockDimensions[d];
        }
    }

    static void cropBlockDimensions(long[] max, long[] offset, long[] gridOffset, int[] blockDimensions, long[] croppedBlockDimensions, int[] intCroppedBlockDimensions, long[] gridPosition) {
        for (int d = 0; d < max.length; ++d) {
            croppedBlockDimensions[d] = Math.min((long)blockDimensions[d], max[d] - offset[d] + 1L);
            intCroppedBlockDimensions[d] = (int)croppedBlockDimensions[d];
            gridPosition[d] = offset[d] / (long)blockDimensions[d] + gridOffset[d];
        }
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset) {
        if (N5LabelMultisets.isLabelMultisetType(n5, dataset)) {
            return N5LabelMultisets.openLabelMultiset(n5, dataset);
        }
        return N5Utils.open(n5, dataset, img -> {});
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, img -> {}, maxNumCacheEntries);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset) {
        if (N5LabelMultisets.isLabelMultisetType(n5, dataset)) {
            return N5LabelMultisets.openLabelMultiset(n5, dataset);
        }
        return N5Utils.openVolatile(n5, dataset, img -> {});
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries) {
        return N5Utils.openVolatileWithBoundedSoftRefCache(n5, dataset, img -> {}, maxNumCacheEntries);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset) {
        return N5Utils.openWithDiskCache(n5, dataset, img -> {});
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.open(n5, dataset, N5CellLoader.setToDefaultValue(defaultValue));
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries, T defaultValue) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, N5CellLoader.setToDefaultValue(defaultValue), maxNumCacheEntries);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.openVolatile(n5, dataset, N5CellLoader.setToDefaultValue(defaultValue));
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, int maxNumCacheEntries, T defaultValue) {
        return N5Utils.openVolatileWithBoundedSoftRefCache(n5, dataset, N5CellLoader.setToDefaultValue(defaultValue), maxNumCacheEntries);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset, T defaultValue) {
        return N5Utils.openWithDiskCache(n5, dataset, N5CellLoader.setToDefaultValue(defaultValue));
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, AccessFlags.setOf());
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, Set<AccessFlags> accessFlags) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, dataType -> new SoftRefLoaderCache(), accessFlags);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, blockNotFoundHandler, maxNumCacheEntries, AccessFlags.setOf());
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries, Set<AccessFlags> accessFlags) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, dataType -> new BoundedSoftRefLoaderCache(maxNumCacheEntries), accessFlags);
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, Function<DataType, LoaderCache> loaderCacheFactory, Set<AccessFlags> accessFlags) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        LoaderCache loaderCache = loaderCacheFactory.apply(attributes.getDataType());
        T type = N5Utils.type(attributes.getDataType());
        return type == null ? null : N5Utils.open(n5, dataset, blockNotFoundHandler, loaderCache, accessFlags, type);
    }

    public static final <T extends NativeType<T>, A extends ArrayDataAccess<A>> CachedCellImg<T, A> open(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, LoaderCache<Long, Cell<A>> loaderCache, Set<AccessFlags> accessFlags, T type) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        int[] blockSize = attributes.getBlockSize();
        CellGrid grid = new CellGrid(dimensions, blockSize);
        N5CacheLoader loader = new N5CacheLoader(n5, dataset, grid, type, accessFlags, blockNotFoundHandler);
        Cache cache = loaderCache.withLoader(loader);
        CachedCellImg img = new CachedCellImg(grid, type, cache, (DataAccess)ArrayDataAccessFactory.get(type, accessFlags));
        return img;
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openVolatile(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        return N5Utils.open(n5, dataset, blockNotFoundHandler, AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE));
    }

    public static <T extends NativeType<T>> CachedCellImg<T, ?> openVolatileWithBoundedSoftRefCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler, int maxNumCacheEntries) {
        return N5Utils.openWithBoundedSoftRefCache(n5, dataset, blockNotFoundHandler, maxNumCacheEntries, AccessFlags.setOf((AccessFlags)AccessFlags.VOLATILE));
    }

    public static final <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmapsWithHandler(N5Reader n5, String group, boolean useVolatileAccess, IntFunction<Consumer<IterableInterval<T>>> blockNotFoundHandlerSupplier) {
        int numScales = n5.list(group).length;
        RandomAccessibleInterval[] mipmaps = new RandomAccessibleInterval[numScales];
        double[][] scales = new double[numScales][];
        for (int s = 0; s < numScales; ++s) {
            String datasetName = group + "/s" + s;
            long[] dimensions = (long[])n5.getAttribute(datasetName, "dimensions", long[].class);
            long[] downsamplingFactors = (long[])n5.getAttribute(datasetName, "downsamplingFactors", long[].class);
            double[] scale = new double[dimensions.length];
            if (downsamplingFactors == null) {
                int si = 1 << s;
                for (int i = 0; i < scale.length; ++i) {
                    scale[i] = si;
                }
            } else {
                for (int i = 0; i < scale.length; ++i) {
                    scale[i] = downsamplingFactors[i];
                }
            }
            CachedCellImg<T, ?> source = useVolatileAccess ? N5Utils.openVolatile(n5, datasetName, blockNotFoundHandlerSupplier.apply(s)) : N5Utils.open(n5, datasetName, blockNotFoundHandlerSupplier.apply(s));
            mipmaps[s] = source;
            scales[s] = scale;
        }
        return new ValuePair((Object)mipmaps, (Object)scales);
    }

    public static final <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmaps(N5Reader n5, String group, boolean useVolatileAccess, IntFunction<T> defaultValueSupplier) {
        return N5Utils.openMipmapsWithHandler(n5, group, useVolatileAccess, s -> N5CellLoader.setToDefaultValue((Type)defaultValueSupplier.apply(s)));
    }

    public static final <T extends NativeType<T>> Pair<RandomAccessibleInterval<T>[], double[][]> openMipmaps(N5Reader n5, String group, boolean useVolatileAccess) {
        return N5Utils.openMipmapsWithHandler(n5, group, useVolatileAccess, s -> t -> {});
    }

    public static final <T extends NativeType<T>> CachedCellImg<T, ?> openWithDiskCache(N5Reader n5, String dataset, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        long[] dimensions = attributes.getDimensions();
        int[] blockSize = attributes.getBlockSize();
        N5CellLoader<T> loader = new N5CellLoader<T>(n5, dataset, blockSize, blockNotFoundHandler);
        DiskCachedCellImgOptions options = (DiskCachedCellImgOptions)((DiskCachedCellImgOptions)DiskCachedCellImgOptions.options().cellDimensions(blockSize)).dirtyAccesses(true).maxCacheSize(100L);
        DiskCachedCellImgFactory factory = new DiskCachedCellImgFactory(N5Utils.type(attributes.getDataType()), options);
        return factory.create(dimensions, loader);
    }

    public static final <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset) {
        if (N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            IntervalView labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultisetBlock((RandomAccessibleInterval<LabelMultisetType>)labelMultisetSource, n5, dataset, attributes, gridOffset);
            return;
        }
        source = Views.zeroMin(source);
        int n = source.numDimensions();
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] blockSize = attributes.getBlockSize();
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5Utils.cropBlockDimensions(max, offset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            DataBlock<?> dataBlock = N5Utils.createDataBlock(sourceBlock, attributes.getDataType(), intCroppedBlockSize, longCroppedBlockSize, gridPosition);
            n5.writeBlock(dataset, attributes, dataBlock);
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static final <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static final <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveBlock(source, n5, dataset, attributes);
    }

    public static final <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveBlock(source, n5, dataset, attributes, gridOffset);
    }

    public static final <T extends NativeType<T>> void saveBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset, ExecutorService exec) throws InterruptedException, ExecutionException {
        if (N5LabelMultisets.isLabelMultisetType((N5Reader)n5, dataset)) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultisetBlock(labelMultisetSource, n5, dataset, gridOffset, exec);
            return;
        }
        IntervalView zeroMinSource = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)zeroMinSource);
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes != null) {
            int n = dimensions.length;
            long[] max = Intervals.maxAsLongArray((Interval)zeroMinSource);
            long[] offset = new long[n];
            int[] blockSize = attributes.getBlockSize();
            ArrayList futures = new ArrayList();
            int d = 0;
            block0: while (d < n) {
                long[] lArray = (long[])offset.clone();
                futures.add(exec.submit(() -> N5Utils.lambda$saveBlock$11(n, max, lArray, gridOffset, blockSize, (RandomAccessibleInterval)zeroMinSource, attributes, n5, dataset)));
                for (d = 0; d < n; ++d) {
                    int n2 = d;
                    offset[n2] = offset[n2] + (long)blockSize[d];
                    if (offset[d] <= max[d]) continue block0;
                    offset[d] = 0L;
                }
            }
            for (Future future : futures) {
                future.get();
            }
        } else {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
    }

    public static final <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset, T defaultValue) {
        source = Views.zeroMin(source);
        int n = source.numDimensions();
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] blockSize = attributes.getBlockSize();
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5Utils.cropBlockDimensions(max, offset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            DataBlock<?> dataBlock = N5Utils.createNonEmptyDataBlock(sourceBlock, attributes.getDataType(), intCroppedBlockSize, longCroppedBlockSize, gridPosition, defaultValue);
            if (dataBlock != null) {
                n5.writeBlock(dataset, attributes, dataBlock);
            }
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static final <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, T defaultValue) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> source.min(d) / (long)blockSize[d]);
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultValue);
    }

    public static final <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, T defaultValue) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, defaultValue);
    }

    public static final <T extends NativeType<T>> void saveNonEmptyBlock(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, long[] gridOffset, T defaultValue) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.saveNonEmptyBlock(source, n5, dataset, attributes, gridOffset, defaultValue);
    }

    public static final <T extends NativeType<T>> void save(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, int[] blockSize, Compression compression) {
        if (Util.getTypeFromInterval(source) instanceof LabelMultisetType) {
            IntervalView labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultiset((RandomAccessibleInterval<LabelMultisetType>)labelMultisetSource, n5, dataset, blockSize, compression);
            return;
        }
        source = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)source);
        DatasetAttributes attributes = new DatasetAttributes(dimensions, blockSize, N5Utils.dataType((NativeType)Util.getTypeFromInterval((Interval)source)), compression);
        n5.createDataset(dataset, attributes);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)source);
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5Utils.cropBlockDimensions(max, offset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)source, (long[])offset, (long[])longCroppedBlockSize);
            DataBlock<?> dataBlock = N5Utils.createDataBlock(sourceBlock, attributes.getDataType(), intCroppedBlockSize, longCroppedBlockSize, gridPosition);
            n5.writeBlock(dataset, attributes, dataBlock);
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static final <T extends NativeType<T>> void save(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, int[] blockSize, Compression compression, ExecutorService exec) throws InterruptedException, ExecutionException {
        if (Util.getTypeFromInterval(source) instanceof LabelMultisetType) {
            RandomAccessibleInterval<T> labelMultisetSource = source;
            N5LabelMultisets.saveLabelMultiset(labelMultisetSource, n5, dataset, blockSize, compression, exec);
            return;
        }
        IntervalView zeroMinSource = Views.zeroMin(source);
        long[] dimensions = Intervals.dimensionsAsLongArray((Dimensions)zeroMinSource);
        DatasetAttributes attributes = new DatasetAttributes(dimensions, blockSize, N5Utils.dataType((NativeType)Util.getTypeFromInterval((Interval)zeroMinSource)), compression);
        n5.createDataset(dataset, attributes);
        int n = dimensions.length;
        long[] max = Intervals.maxAsLongArray((Interval)zeroMinSource);
        long[] offset = new long[n];
        ArrayList futures = new ArrayList();
        int d = 0;
        block0: while (d < n) {
            long[] lArray = (long[])offset.clone();
            futures.add(exec.submit(() -> N5Utils.lambda$save$13(n, max, lArray, blockSize, (RandomAccessibleInterval)zeroMinSource, attributes, n5, dataset)));
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
        for (Future future : futures) {
            future.get();
        }
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset) throws InterruptedException, ExecutionException {
        N5Utils.saveRegion(source, n5, dataset, n5.getDatasetAttributes(dataset));
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, ExecutorService exec) throws InterruptedException, ExecutionException {
        N5Utils.saveRegion(source, n5, dataset, n5.getDatasetAttributes(dataset), exec);
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes) throws InterruptedException, ExecutionException {
        long[] dimensions;
        Optional<long[]> newDimensionsOpt = N5Utils.saveRegionPreprocessing(source, attributes);
        if (newDimensionsOpt.isPresent()) {
            n5.setAttribute(dataset, "dimensions", (Object)newDimensionsOpt.get());
            dimensions = newDimensionsOpt.get();
        } else {
            dimensions = attributes.getDimensions();
        }
        int n = source.numDimensions();
        int[] blockSize = attributes.getBlockSize();
        CachedCellImg<T, ?> currentImg = N5Utils.open((N5Reader)n5, dataset);
        long[] gridOffset = new long[n];
        long[] gridMin = new long[n];
        long[] gridMax = new long[n];
        long[] imgMin = new long[n];
        long[] imgMax = new long[n];
        for (int d = 0; d < n; ++d) {
            gridMin[d] = Math.floorDiv(source.min(d), (long)blockSize[d]);
            gridMax[d] = Math.floorDiv(source.max(d), (long)blockSize[d]);
        }
        IntervalIterator it = new IntervalIterator(gridMin, gridMax);
        while (it.hasNext()) {
            it.fwd();
            it.localize(gridOffset);
            for (int d = 0; d < n; ++d) {
                imgMin[d] = gridOffset[d] * (long)blockSize[d];
                imgMax[d] = Math.min(imgMin[d] + (long)blockSize[d] - 1L, dimensions[d] - 1L);
            }
            IntervalView currentBlock = Views.interval(currentImg, (long[])imgMin, (long[])imgMax);
            FinalInterval intersection = Intervals.intersect((Interval)currentBlock, source);
            IntervalView srcInt = Views.interval(source, (Interval)intersection);
            IntervalView blkInt = Views.interval(currentImg, (Interval)intersection);
            LoopBuilder.setImages((RandomAccessibleInterval)srcInt, (RandomAccessibleInterval)blkInt).forEachPixel((x, y) -> y.set((Type)x));
            N5Utils.saveBlock(currentBlock, n5, dataset, gridOffset);
        }
    }

    public static <T extends NativeType<T>> void saveRegion(RandomAccessibleInterval<T> source, N5Writer n5, String dataset, DatasetAttributes attributes, ExecutorService exec) throws InterruptedException, ExecutionException {
        long[] dimensions;
        Optional<long[]> newDimensionsOpt = N5Utils.saveRegionPreprocessing(source, attributes);
        if (newDimensionsOpt.isPresent()) {
            n5.setAttribute(dataset, "dimensions", (Object)newDimensionsOpt.get());
            dimensions = newDimensionsOpt.get();
        } else {
            dimensions = attributes.getDimensions();
        }
        int n = source.numDimensions();
        int[] blockSize = attributes.getBlockSize();
        CachedCellImg<T, ?> currentImg = N5Utils.open((N5Reader)n5, dataset);
        long[] gridOffset = new long[n];
        long[] gridMin = new long[n];
        long[] gridMax = new long[n];
        long[] imgMin = new long[n];
        long[] imgMax = new long[n];
        for (int d = 0; d < n; ++d) {
            gridMin[d] = Math.floorDiv(source.min(d), (long)blockSize[d]);
            gridMax[d] = Math.floorDiv(source.max(d), (long)blockSize[d]);
        }
        ArrayList futures = new ArrayList();
        IntervalIterator it = new IntervalIterator(gridMin, gridMax);
        while (it.hasNext()) {
            it.fwd();
            it.localize(gridOffset);
            for (int d = 0; d < n; ++d) {
                imgMin[d] = gridOffset[d] * (long)blockSize[d];
                imgMax[d] = Math.min(imgMin[d] + (long)blockSize[d] - 1L, dimensions[d] - 1L);
            }
            long[] imgMinCopy = new long[n];
            long[] lArray = new long[n];
            long[] gridOffsetCopy = new long[n];
            System.arraycopy(imgMin, 0, imgMinCopy, 0, n);
            System.arraycopy(imgMax, 0, lArray, 0, n);
            System.arraycopy(gridOffset, 0, gridOffsetCopy, 0, n);
            futures.add(exec.submit(() -> {
                IntervalView currentBlock = Views.interval((RandomAccessible)currentImg, (long[])imgMinCopy, (long[])imgMaxCopy);
                FinalInterval intersection = Intervals.intersect((Interval)currentBlock, (Interval)source);
                IntervalView srcInt = Views.interval((RandomAccessible)source, (Interval)intersection);
                IntervalView blkInt = Views.interval((RandomAccessible)currentImg, (Interval)intersection);
                LoopBuilder.setImages((RandomAccessibleInterval)srcInt, (RandomAccessibleInterval)blkInt).forEachPixel((x, y) -> y.set((Type)x));
                N5Utils.saveBlock(currentBlock, n5, dataset, gridOffsetCopy);
            }));
        }
        for (Future future : futures) {
            future.get();
        }
    }

    private static <T extends NativeType<T>> Optional<long[]> saveRegionPreprocessing(RandomAccessibleInterval<T> source, DatasetAttributes attributes) {
        DataType dtype = attributes.getDataType();
        long[] currentDimensions = attributes.getDimensions();
        int n = currentDimensions.length;
        if (source.numDimensions() != n) {
            throw new ImgLibException(String.format("Image dimensions (%d) does not match n5 dataset dimensionalidy (%d)", source.numDimensions(), n));
        }
        DataType srcType = N5Utils.dataType((NativeType)Util.getTypeFromInterval(source));
        if (srcType != dtype) {
            throw new ImgLibException(String.format("Image type (%s) does not match n5 dataset type (%s)", srcType, dtype));
        }
        boolean needsPadding = false;
        long[] newDimensions = new long[n];
        for (int d = 0; d < n; ++d) {
            if (source.min(d) < 0L) {
                throw new ImgLibException(String.format("Source interval must ", source.min(d), d));
            }
            if (source.max(d) + 1L > currentDimensions[d]) {
                newDimensions[d] = source.max(d) + 1L;
                needsPadding = true;
                continue;
            }
            newDimensions[d] = currentDimensions[d];
        }
        if (needsPadding) {
            return Optional.of(newDimensions);
        }
        return Optional.empty();
    }

    public static final void deleteBlock(Interval interval, N5Writer n5, String dataset, DatasetAttributes attributes, long[] gridOffset) {
        FinalInterval zeroMinInterval = new FinalInterval(Intervals.dimensionsAsLongArray((Dimensions)interval));
        int n = zeroMinInterval.numDimensions();
        long[] max = Intervals.maxAsLongArray((Interval)zeroMinInterval);
        int[] blockSize = attributes.getBlockSize();
        long[] offset = new long[n];
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        int d = 0;
        block0: while (d < n) {
            N5Utils.cropBlockDimensions(max, offset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
            n5.deleteBlock(dataset, gridPosition);
            for (d = 0; d < n; ++d) {
                int n2 = d;
                offset[n2] = offset[n2] + (long)blockSize[d];
                if (offset[d] <= max[d]) continue block0;
                offset[d] = 0L;
            }
        }
    }

    public static final void deleteBlock(Interval interval, N5Writer n5, String dataset, DatasetAttributes attributes) {
        int[] blockSize = attributes.getBlockSize();
        long[] gridOffset = new long[blockSize.length];
        Arrays.setAll(gridOffset, d -> interval.min(d) / (long)blockSize[d]);
        N5Utils.deleteBlock(interval, n5, dataset, attributes, gridOffset);
    }

    public static final void deleteBlock(Interval interval, N5Writer n5, String dataset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.deleteBlock(interval, n5, dataset, attributes);
    }

    public static final void deleteBlock(Interval interval, N5Writer n5, String dataset, long[] gridOffset) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        if (attributes == null) {
            throw new N5Exception.N5IOException("Dataset " + dataset + " does not exist.");
        }
        N5Utils.deleteBlock(interval, n5, dataset, attributes, gridOffset);
    }

    private static /* synthetic */ void lambda$save$13(int n, long[] max, long[] fOffset, int[] blockSize, RandomAccessibleInterval zeroMinSource, DatasetAttributes attributes, N5Writer n5, String dataset) {
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        N5Utils.cropBlockDimensions(max, fOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
        IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)zeroMinSource, (long[])fOffset, (long[])longCroppedBlockSize);
        DataBlock<?> dataBlock = N5Utils.createDataBlock(sourceBlock, attributes.getDataType(), intCroppedBlockSize, longCroppedBlockSize, gridPosition);
        n5.writeBlock(dataset, attributes, dataBlock);
    }

    private static /* synthetic */ void lambda$saveBlock$11(int n, long[] max, long[] fOffset, long[] gridOffset, int[] blockSize, RandomAccessibleInterval zeroMinSource, DatasetAttributes attributes, N5Writer n5, String dataset) {
        long[] gridPosition = new long[n];
        int[] intCroppedBlockSize = new int[n];
        long[] longCroppedBlockSize = new long[n];
        N5Utils.cropBlockDimensions(max, fOffset, gridOffset, blockSize, longCroppedBlockSize, intCroppedBlockSize, gridPosition);
        IntervalView sourceBlock = Views.offsetInterval((RandomAccessible)zeroMinSource, (long[])fOffset, (long[])longCroppedBlockSize);
        DataBlock<?> dataBlock = N5Utils.createDataBlock(sourceBlock, attributes.getDataType(), intCroppedBlockSize, longCroppedBlockSize, gridPosition);
        n5.writeBlock(dataset, attributes, dataBlock);
    }
}

