/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import net.imglib2.Cursor;
import net.imglib2.EuclideanSpace;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.cache.img.CachedCellImg;
import net.imglib2.converter.Converter;
import net.imglib2.converter.Converters;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorFactory;
import net.imglib2.realtransform.AffineGet;
import net.imglib2.realtransform.AffineTransform;
import net.imglib2.realtransform.DisplacementFieldTransform;
import net.imglib2.realtransform.ExplicitInvertibleRealTransform;
import net.imglib2.realtransform.RealTransform;
import net.imglib2.realtransform.RealTransformSequence;
import net.imglib2.realtransform.RealViews;
import net.imglib2.realtransform.Scale;
import net.imglib2.realtransform.Scale2D;
import net.imglib2.realtransform.Scale3D;
import net.imglib2.realtransform.ScaleAndTranslation;
import net.imglib2.realtransform.Translation;
import net.imglib2.realtransform.Translation2D;
import net.imglib2.realtransform.Translation3D;
import net.imglib2.transform.integer.Mixed;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.numeric.integer.ByteType;
import net.imglib2.type.numeric.integer.IntType;
import net.imglib2.type.numeric.integer.LongType;
import net.imglib2.type.numeric.integer.ShortType;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedIntType;
import net.imglib2.type.numeric.integer.UnsignedLongType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.IntervalView;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.Views;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.RealComposite;
import org.janelia.saalfeldlab.n5.Compression;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;
import org.janelia.saalfeldlab.n5.N5Writer;
import org.janelia.saalfeldlab.n5.imglib2.N5Utils;

public class N5DisplacementField {
    public static final String MULTIPLIER_ATTR = "quantization_multiplier";
    public static final String AFFINE_ATTR = "affine";
    public static final String SPACING_ATTR = "spacing";
    public static final String OFFSET_ATTR = "offset";
    public static final String FORWARD_ATTR = "dfield";
    public static final String INVERSE_ATTR = "invdfield";
    public static final String EXTEND_ZERO = "ext_zero";
    public static final String EXTEND_MIRROR = "ext_mirror";
    public static final String EXTEND_BORDER = "ext_border";
    public static final int[] PERMUTATION2D = new int[]{2, 0, 1};
    public static final int[] PERMUTATION3D = new int[]{3, 0, 1, 2};

    public static final <T extends NativeType<T> & RealType<T>> void save(N5Writer n5Writer, AffineGet affine, RandomAccessibleInterval<T> forwardDfield, double[] fwdspacing, RandomAccessibleInterval<T> inverseDfield, double[] invspacing, int[] blockSize, Compression compression) {
        N5DisplacementField.save(n5Writer, FORWARD_ATTR, affine, forwardDfield, fwdspacing, blockSize, compression);
        N5DisplacementField.save(n5Writer, INVERSE_ATTR, affine.inverse(), inverseDfield, invspacing, blockSize, compression);
    }

    public static final <T extends NativeType<T> & RealType<T>> void save(N5Writer n5Writer, String dataset, AffineGet affine, RandomAccessibleInterval<T> dfield, double[] spacing, int[] blockSize, Compression compression) {
        N5Utils.save(dfield, n5Writer, dataset, blockSize, compression);
        if (affine != null) {
            N5DisplacementField.saveAffine(affine, n5Writer, dataset);
        }
        if (spacing != null) {
            n5Writer.setAttribute(dataset, SPACING_ATTR, (Object)spacing);
        }
    }

    public static final <T extends NativeType<T> & RealType<T>> void save(N5Writer n5Writer, String dataset, AffineGet affine, RandomAccessibleInterval<T> dfield, double[] spacing, double[] offset, int[] blockSize, Compression compression) {
        N5Utils.save(dfield, n5Writer, dataset, blockSize, compression);
        if (affine != null) {
            N5DisplacementField.saveAffine(affine, n5Writer, dataset);
        }
        if (spacing != null) {
            n5Writer.setAttribute(dataset, SPACING_ATTR, (Object)spacing);
        }
        if (offset != null) {
            n5Writer.setAttribute(dataset, OFFSET_ATTR, (Object)offset);
        }
    }

    public static final <T extends NativeType<T> & RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> void save(N5Writer n5Writer, String dataset, AffineGet affine, RandomAccessibleInterval<T> dfield, double[] spacing, int[] blockSize, Compression compression, Q outputType, double maxError) {
        N5DisplacementField.saveQuantized(n5Writer, dataset, dfield, blockSize, compression, outputType, maxError);
        N5DisplacementField.saveAffine(affine, n5Writer, dataset);
        if (spacing != null) {
            n5Writer.setAttribute(dataset, SPACING_ATTR, (Object)spacing);
        }
    }

    public static final <T extends NativeType<T> & RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> void save(N5Writer n5Writer, String dataset, AffineGet affine, RandomAccessibleInterval<T> dfield, double[] spacing, double[] offset, int[] blockSize, Compression compression, Q outputType, double maxError) {
        N5DisplacementField.saveQuantized(n5Writer, dataset, dfield, blockSize, compression, outputType, maxError);
        N5DisplacementField.saveAffine(affine, n5Writer, dataset);
        if (spacing != null) {
            n5Writer.setAttribute(dataset, SPACING_ATTR, (Object)spacing);
        }
        if (offset != null) {
            n5Writer.setAttribute(dataset, OFFSET_ATTR, (Object)offset);
        }
    }

    public static final void saveAffine(AffineGet affine, N5Writer n5Writer, String dataset) {
        if (affine != null) {
            n5Writer.setAttribute(dataset, AFFINE_ATTR, (Object)affine.getRowPackedCopy());
        }
    }

    public static final <T extends RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> void saveQuantized(N5Writer n5Writer, String dataset, RandomAccessibleInterval<T> source, int[] blockSize, Compression compression, Q outputType, double maxError) {
        int nd = source.numDimensions() - 1;
        final double m = 2.0 * Math.sqrt(maxError * maxError / (double)nd);
        RandomAccessibleInterval<T> source_permuted = N5DisplacementField.vectorAxisFirst(source);
        RandomAccessibleInterval source_quant = Converters.convert(source_permuted, (Converter)new Converter<T, Q>(){

            public void convert(T input, Q output) {
                ((IntegerType)output).setInteger(Math.round(input.getRealDouble() / m));
            }
        }, (Type)outputType.copy());
        N5Utils.save(source_quant, n5Writer, dataset, blockSize, compression);
        n5Writer.setAttribute(dataset, MULTIPLIER_ATTR, (Object)m);
    }

    public static final <T extends RealType<T> & NativeType<T>> ExplicitInvertibleRealTransform openInvertible(N5Reader n5, String forwardDataset, String inverseDataset, T defaultType, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolator) {
        if (!n5.datasetExists(forwardDataset)) {
            System.err.println("dataset : " + forwardDataset + " does not exist.");
            return null;
        }
        if (!n5.datasetExists(inverseDataset)) {
            System.err.println("dataset : " + inverseDataset + " does not exist.");
            return null;
        }
        return new ExplicitInvertibleRealTransform(N5DisplacementField.open(n5, forwardDataset, false, defaultType, interpolator), N5DisplacementField.open(n5, inverseDataset, true, defaultType, interpolator));
    }

    public static final <T extends RealType<T> & NativeType<T>> ExplicitInvertibleRealTransform openInvertible(N5Reader n5) {
        return N5DisplacementField.openInvertible(n5, FORWARD_ATTR, INVERSE_ATTR, new DoubleType(), new NLinearInterpolatorFactory());
    }

    public static final <T extends RealType<T> & NativeType<T>> ExplicitInvertibleRealTransform openInvertible(N5Reader n5, int level) {
        return N5DisplacementField.openInvertible(n5, "/" + level + "/" + FORWARD_ATTR, "/" + level + "/" + INVERSE_ATTR, new DoubleType(), new NLinearInterpolatorFactory());
    }

    public static final <T extends RealType<T> & NativeType<T>> ExplicitInvertibleRealTransform openInvertible(N5Reader n5, T defaultType, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolator) {
        return N5DisplacementField.openInvertible(n5, FORWARD_ATTR, INVERSE_ATTR, defaultType, interpolator);
    }

    public static final <T extends RealType<T> & NativeType<T>> RealTransform open(N5Reader n5, String dataset, boolean inverse, T defaultType, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolator) {
        AffineGet affine = N5DisplacementField.openAffine(n5, dataset);
        DisplacementFieldTransform dfield = new DisplacementFieldTransform(N5DisplacementField.openCalibratedField(n5, dataset, interpolator, defaultType));
        if (affine != null) {
            RealTransformSequence xfmSeq = new RealTransformSequence();
            if (inverse) {
                xfmSeq.add((RealTransform)affine);
                xfmSeq.add((RealTransform)dfield);
            } else {
                xfmSeq.add((RealTransform)dfield);
                xfmSeq.add((RealTransform)affine);
            }
            return xfmSeq;
        }
        return dfield;
    }

    public static final AffineGet openPixelToPhysical(N5Reader n5, String dataset) {
        double[] spacing = (double[])n5.getAttribute(dataset, SPACING_ATTR, double[].class);
        double[] offset = (double[])n5.getAttribute(dataset, OFFSET_ATTR, double[].class);
        if (spacing == null && offset == null) {
            return null;
        }
        if (offset == null) {
            int N = spacing.length;
            if (N == 2) {
                return new Scale2D(spacing);
            }
            if (N == 3) {
                return new Scale3D(spacing);
            }
            return new Scale(spacing);
        }
        if (spacing == null) {
            int N = offset.length;
            if (N == 2) {
                return new Translation2D(offset);
            }
            if (N == 3) {
                return new Translation3D(offset);
            }
            return new Translation(offset);
        }
        return new ScaleAndTranslation(spacing, offset);
    }

    public static final AffineGet openAffine(N5Reader n5, String dataset) {
        AffineTransform affineMtx;
        double[] affineMtxRow = (double[])n5.getAttribute(dataset, AFFINE_ATTR, double[].class);
        if (affineMtxRow == null) {
            return null;
        }
        int N = affineMtxRow.length;
        if (N == 2) {
            affineMtx = new AffineTransform(1);
        } else if (N == 6) {
            affineMtx = new AffineTransform(2);
        } else if (N == 12) {
            affineMtx = new AffineTransform(3);
        } else {
            return null;
        }
        affineMtx.set(affineMtxRow);
        return affineMtx;
    }

    public static final <T extends NativeType<T> & RealType<T>, Q extends NativeType<Q> & IntegerType<Q>> RandomAccessibleInterval<T> openField(N5Reader n5, String dataset, T defaultType) {
        DatasetAttributes attributes = n5.getDatasetAttributes(dataset);
        switch (attributes.getDataType()) {
            case INT8: {
                return N5DisplacementField.openQuantized(n5, dataset, new ByteType(), defaultType);
            }
            case UINT8: {
                return N5DisplacementField.openQuantized(n5, dataset, new UnsignedByteType(), defaultType);
            }
            case INT16: {
                return N5DisplacementField.openQuantized(n5, dataset, new ShortType(), defaultType);
            }
            case UINT16: {
                return N5DisplacementField.openQuantized(n5, dataset, new UnsignedShortType(), defaultType);
            }
            case INT32: {
                return N5DisplacementField.openQuantized(n5, dataset, new IntType(), defaultType);
            }
            case UINT32: {
                return N5DisplacementField.openQuantized(n5, dataset, new UnsignedIntType(), defaultType);
            }
            case INT64: {
                return N5DisplacementField.openQuantized(n5, dataset, new LongType(), defaultType);
            }
            case UINT64: {
                return N5DisplacementField.openQuantized(n5, dataset, new UnsignedLongType(), defaultType);
            }
        }
        return N5DisplacementField.openRaw(n5, dataset, defaultType);
    }

    public static <T extends NativeType<T> & RealType<T>> RealRandomAccessible<RealComposite<T>> openCalibratedField(N5Reader n5, String dataset, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolator, T defaultType) {
        return N5DisplacementField.openCalibratedField(n5, dataset, interpolator, EXTEND_BORDER, defaultType);
    }

    public static <T extends NativeType<T> & RealType<T>> RealRandomAccessible<RealComposite<T>> openCalibratedField(N5Reader n5, String dataset, InterpolatorFactory<RealComposite<T>, RandomAccessible<RealComposite<T>>> interpolator, String extensionType, T defaultType) {
        RandomAccessibleInterval<T> dfieldRai = N5DisplacementField.openField(n5, dataset, defaultType);
        if (dfieldRai == null) {
            return null;
        }
        CompositeIntervalView dfieldRaiPerm = Views.collapseReal(N5DisplacementField.vectorAxisLast(dfieldRai));
        RealRandomAccessible dfieldReal = extensionType.equals(EXTEND_MIRROR) ? Views.interpolate((EuclideanSpace)Views.extendMirrorDouble((RandomAccessibleInterval)dfieldRaiPerm), interpolator) : (extensionType.equals(EXTEND_BORDER) ? Views.interpolate((EuclideanSpace)Views.extendBorder((RandomAccessibleInterval)dfieldRaiPerm), interpolator) : Views.interpolate((EuclideanSpace)Views.extendZero((RandomAccessibleInterval)dfieldRaiPerm), interpolator));
        AffineGet pix2Phys = N5DisplacementField.openPixelToPhysical(n5, dataset);
        Object displacements = pix2Phys != null ? RealViews.affine((RealRandomAccessible)dfieldReal, (AffineGet)pix2Phys) : dfieldReal;
        return displacements;
    }

    public static <T extends NativeType<T> & RealType<T>> RealTransform open(N5Reader n5, String dataset, boolean inverse) {
        return N5DisplacementField.open(n5, dataset, inverse, new FloatType(), new NLinearInterpolatorFactory());
    }

    public static final <T extends RealType<T> & NativeType<T>> RandomAccessibleInterval<T> openRaw(N5Reader n5, String dataset, T defaultType) {
        CachedCellImg<NativeType<T>, ?> src = N5Utils.open(n5, dataset, defaultType);
        return N5DisplacementField.vectorAxisLast(src);
    }

    public static final <Q extends RealType<Q> & NativeType<Q>, T extends RealType<T>> RandomAccessibleInterval<T> openQuantized(N5Reader n5, String dataset, Q defaultQuantizedType, T defaultType) {
        CachedCellImg<NativeType<Q>, ?> src = N5Utils.open(n5, dataset, (NativeType<Q>)defaultQuantizedType);
        Double mattr = (Double)n5.getAttribute(dataset, MULTIPLIER_ATTR, Double.TYPE);
        final double m = mattr != null ? mattr : 1.0;
        RandomAccessibleInterval<T> src_perm = N5DisplacementField.vectorAxisLast(src);
        RandomAccessibleInterval src_converted = Converters.convert(src_perm, (Converter)new Converter<Q, T>(){

            public void convert(Q input, T output) {
                output.setReal(input.getRealDouble() * m);
            }
        }, (Type)defaultType.copy());
        return src_converted;
    }

    public static final <T extends RealType<T>> RandomAccessibleInterval<T> vectorAxisLast(RandomAccessibleInterval<T> source) {
        int n = source.numDimensions();
        if (source.dimension(n - 1) == (long)(n - 1)) {
            return source;
        }
        if (source.dimension(0) == (long)(n - 1)) {
            int[] component = new int[n];
            component[0] = n - 1;
            for (int i = 1; i < n; ++i) {
                component[i] = i - 1;
            }
            return N5DisplacementField.permute(source, component);
        }
        throw new RuntimeException(String.format("Displacement fields must store vector components in the first or last dimension. Found a %d-d volume; expect size [%d,...] or [...,%d]", n, n - 1, n - 1));
    }

    public static final <T extends RealType<T>> RandomAccessibleInterval<T> vectorAxisFirst(RandomAccessibleInterval<T> source) {
        int n = source.numDimensions();
        if (source.dimension(0) == (long)(n - 1)) {
            return source;
        }
        if (source.dimension(n - 1) == (long)(n - 1)) {
            int[] component = new int[n];
            component[n - 1] = 0;
            for (int i = 0; i < n - 1; ++i) {
                component[i] = i + 1;
            }
            return N5DisplacementField.permute(source, component);
        }
        throw new RuntimeException(String.format("Displacement fields must store vector components in the first or last dimension. Found a %d-d volume; expect size [%d,...] or [...,%d]", n, n - 1, n - 1));
    }

    public static final <T> IntervalView<T> permute(RandomAccessibleInterval<T> source, int[] p) {
        int n = source.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int i = 0; i < n; ++i) {
            min[p[i]] = source.min(i);
            max[p[i]] = source.max(i);
        }
        MixedTransform t = new MixedTransform(n, n);
        t.setComponentMapping(p);
        return Views.interval((RandomAccessible)new MixedTransformView(source, (Mixed)t), (long[])min, (long[])max);
    }

    public static <T extends RealType<T>> double[] getMinMax(IterableInterval<T> img) {
        double min = Double.MAX_VALUE;
        double max = Double.MIN_VALUE;
        Cursor c = img.cursor();
        while (c.hasNext()) {
            double v = Math.abs(((RealType)c.next()).getRealDouble());
            if (v > max) {
                max = v;
            }
            if (!(v < min)) continue;
            min = v;
        }
        return new double[]{min, max};
    }
}

