/*
 * Decompiled with CFR 0.152.
 */
package org.janelia.saalfeldlab.n5.imglib2;

import java.util.Arrays;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.cache.img.CellLoader;
import net.imglib2.cache.img.SingleCellArrayImg;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.type.NativeType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.GenericByteType;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.type.numeric.integer.GenericShortType;
import net.imglib2.type.numeric.real.DoubleType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.util.Intervals;
import net.imglib2.view.IntervalView;
import net.imglib2.view.Views;
import org.janelia.saalfeldlab.n5.DataBlock;
import org.janelia.saalfeldlab.n5.DataType;
import org.janelia.saalfeldlab.n5.DatasetAttributes;
import org.janelia.saalfeldlab.n5.N5Reader;

public class N5CellLoader<T extends NativeType<T>>
implements CellLoader<T> {
    private final N5Reader n5;
    private final String dataset;
    private final int[] cellDimensions;
    private final DatasetAttributes attributes;
    private final BiConsumer<SingleCellArrayImg<T, ?>, DataBlock<?>> copyFromBlock;
    private final Consumer<IterableInterval<T>> blockNotFoundHandler;

    public N5CellLoader(N5Reader n5, String dataset, int[] cellDimensions) {
        this(n5, dataset, cellDimensions, img -> {});
    }

    public N5CellLoader(N5Reader n5, String dataset, int[] cellDimensions, Consumer<IterableInterval<T>> blockNotFoundHandler) {
        this.n5 = n5;
        this.dataset = dataset;
        this.cellDimensions = cellDimensions;
        this.attributes = n5.getDatasetAttributes(dataset);
        this.copyFromBlock = N5CellLoader.createCopy(this.attributes.getDataType());
        this.blockNotFoundHandler = blockNotFoundHandler;
        if (!Arrays.equals(this.cellDimensions, this.attributes.getBlockSize())) {
            throw new RuntimeException("Cell dimensions inconsistent!  " + Arrays.toString(cellDimensions) + " " + Arrays.toString(this.attributes.getBlockSize()));
        }
    }

    public void load(SingleCellArrayImg<T, ?> cell) {
        long[] gridPosition = new long[cell.numDimensions()];
        for (int d = 0; d < gridPosition.length; ++d) {
            gridPosition[d] = cell.min(d) / (long)this.cellDimensions[d];
        }
        DataBlock block = this.n5.readBlock(this.dataset, this.attributes, gridPosition);
        if (block == null) {
            this.blockNotFoundHandler.accept((IterableInterval<SingleCellArrayImg<T, ?>>)cell);
        } else {
            this.copyFromBlock.accept(cell, block);
        }
    }

    public static <T extends Type<T>> void burnIn(RandomAccessibleInterval<T> source, RandomAccessibleInterval<T> target) {
        Cursor s = Views.flatIterable(source).cursor();
        Cursor t = Views.flatIterable(target).cursor();
        while (t.hasNext()) {
            ((Type)t.next()).set((Type)s.next());
        }
    }

    public static <T extends Type<T>> boolean burnInTestAllEqual(RandomAccessibleInterval<T> source, RandomAccessibleInterval<T> target, T reference) {
        boolean equal = true;
        Cursor s = Views.flatIterable(source).cursor();
        Cursor t = Views.flatIterable(target).cursor();
        while (t.hasNext()) {
            Type ts = (Type)s.next();
            equal &= reference.valueEquals((Object)ts);
            ((Type)t.next()).set(ts);
        }
        return equal;
    }

    public static <T extends NativeType<T>, I extends RandomAccessibleInterval<T> & IterableInterval<T>> BiConsumer<I, DataBlock<?>> createCopy(DataType dataType) {
        switch (dataType) {
            case INT8: 
            case UINT8: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        byte[] data = (byte[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((GenericByteType)c.next()).setByte(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
            case INT16: 
            case UINT16: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        short[] data = (short[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((GenericShortType)c.next()).setShort(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
            case INT32: 
            case UINT32: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        int[] data = (int[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((GenericIntType)c.next()).setInt(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
            case INT64: 
            case UINT64: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        long[] data = (long[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((GenericLongType)c.next()).setLong(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
            case FLOAT32: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        float[] data = (float[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((FloatType)c.next()).set(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
            case FLOAT64: {
                return (a, b) -> {
                    if (N5CellLoader.sizeEquals((Interval)a, b)) {
                        double[] data = (double[])b.getData();
                        Cursor c = ((IterableInterval)a).cursor();
                        for (int i = 0; i < data.length; ++i) {
                            ((DoubleType)c.next()).set(data[i]);
                        }
                    } else {
                        N5CellLoader.copyIntersection(a, b, dataType);
                    }
                };
            }
        }
        throw new IllegalArgumentException("Type " + dataType.name() + " not supported!");
    }

    public static <T extends Type<T>, I extends IterableInterval<T>> Consumer<I> setToDefaultValue(T defaultValue) {
        return rai -> rai.forEach(pixel -> pixel.set(defaultValue));
    }

    private static boolean sizeEquals(Interval a, DataBlock<?> b) {
        int[] dataBlockSize = b.getSize();
        for (int d = 0; d < dataBlockSize.length; ++d) {
            if (a.dimension(d) == (long)dataBlockSize[d]) continue;
            return false;
        }
        return true;
    }

    private static ArrayImg dataBlock2ArrayImg(DataBlock<?> dataBlock, DataType dataType) {
        int[] dataBlockSize = dataBlock.getSize();
        long[] dims = new long[dataBlockSize.length];
        for (int d = 0; d < dataBlockSize.length; ++d) {
            dims[d] = dataBlockSize[d];
        }
        switch (dataType) {
            case INT8: {
                return ArrayImgs.bytes((byte[])((byte[])dataBlock.getData()), (long[])dims);
            }
            case UINT8: {
                return ArrayImgs.unsignedBytes((byte[])((byte[])dataBlock.getData()), (long[])dims);
            }
            case INT16: {
                return ArrayImgs.shorts((short[])((short[])dataBlock.getData()), (long[])dims);
            }
            case UINT16: {
                return ArrayImgs.unsignedShorts((short[])((short[])dataBlock.getData()), (long[])dims);
            }
            case INT32: {
                return ArrayImgs.ints((int[])((int[])dataBlock.getData()), (long[])dims);
            }
            case UINT32: {
                return ArrayImgs.unsignedInts((int[])((int[])dataBlock.getData()), (long[])dims);
            }
            case INT64: {
                return ArrayImgs.longs((long[])((long[])dataBlock.getData()), (long[])dims);
            }
            case UINT64: {
                return ArrayImgs.unsignedLongs((long[])((long[])dataBlock.getData()), (long[])dims);
            }
            case FLOAT32: {
                return ArrayImgs.floats((float[])((float[])dataBlock.getData()), (long[])dims);
            }
            case FLOAT64: {
                return ArrayImgs.doubles((double[])((double[])dataBlock.getData()), (long[])dims);
            }
        }
        return null;
    }

    private static <T extends NativeType<T>, I extends RandomAccessibleInterval<T> & IterableInterval<T>> void copyIntersection(I a, DataBlock<?> b, DataType dataType) {
        ArrayImg block = N5CellLoader.dataBlock2ArrayImg(b, dataType);
        IntervalView za = Views.zeroMin(a);
        FinalInterval intersection = Intervals.intersect((Interval)block, (Interval)za);
        Cursor c = Views.interval((RandomAccessible)za, (Interval)intersection).cursor();
        Cursor d = Views.interval((RandomAccessible)block, (Interval)intersection).cursor();
        while (c.hasNext()) {
            ((NativeType)c.next()).set((Type)d.next());
        }
    }
}

