/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.View;
import net.imglib2.view.composite.Composite;

public class InterleaveView<T>
implements RandomAccessible<T>,
View {
    protected final RandomAccessible<? extends Composite<T>> source;
    protected final int n;

    public InterleaveView(RandomAccessible<? extends Composite<T>> source) {
        this.source = source;
        this.n = source.numDimensions() + 1;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public InterleaveRandomAccess randomAccess() {
        return new InterleaveRandomAccess();
    }

    public InterleaveRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class InterleaveRandomAccess
    implements RandomAccess<T> {
        protected final RandomAccess<? extends Composite<T>> sourceAccess;
        protected Composite<T> composite;
        protected boolean needsUpdate = true;
        protected long compositePosition = 0L;

        public InterleaveRandomAccess() {
            this.sourceAccess = InterleaveView.this.source.randomAccess();
        }

        protected InterleaveRandomAccess(InterleaveRandomAccess other) {
            this.sourceAccess = other.sourceAccess.copy();
        }

        @Override
        public void localize(int[] position) {
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                position[d] = this.sourceAccess.getIntPosition(d - 1);
            }
            position[0] = (int)this.compositePosition;
        }

        @Override
        public void localize(long[] position) {
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                position[d] = this.sourceAccess.getLongPosition(d - 1);
            }
            position[0] = (int)this.compositePosition;
        }

        @Override
        public int getIntPosition(int d) {
            return d == 0 ? (int)this.compositePosition : this.sourceAccess.getIntPosition(d - 1);
        }

        @Override
        public long getLongPosition(int d) {
            return d == 0 ? this.compositePosition : this.sourceAccess.getLongPosition(d - 1);
        }

        @Override
        public void localize(float[] position) {
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                position[d] = this.sourceAccess.getFloatPosition(d - 1);
            }
            position[0] = this.compositePosition;
        }

        @Override
        public void localize(double[] position) {
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                position[d] = this.sourceAccess.getDoublePosition(d - 1);
            }
            position[0] = this.compositePosition;
        }

        @Override
        public float getFloatPosition(int d) {
            return d == 0 ? (float)this.compositePosition : this.sourceAccess.getFloatPosition(d - 1);
        }

        @Override
        public double getDoublePosition(int d) {
            return d == 0 ? (double)this.compositePosition : this.sourceAccess.getDoublePosition(d - 1);
        }

        @Override
        public int numDimensions() {
            return InterleaveView.this.n;
        }

        @Override
        public void fwd(int d) {
            if (d == 0) {
                ++this.compositePosition;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.fwd(d - 1);
            }
        }

        @Override
        public void bck(int d) {
            if (d == 0) {
                --this.compositePosition;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.bck(d - 1);
            }
        }

        @Override
        public void move(int distance, int d) {
            if (d == 0) {
                this.compositePosition += (long)distance;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.move(distance, d - 1);
            }
        }

        @Override
        public void move(long distance, int d) {
            if (d == 0) {
                this.compositePosition += distance;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.move(distance, d - 1);
            }
        }

        @Override
        public void move(Localizable localizable) {
            this.needsUpdate = true;
            this.compositePosition += localizable.getLongPosition(0);
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.move(localizable.getLongPosition(d), d - 1);
            }
        }

        @Override
        public void move(int[] distance) {
            this.needsUpdate = true;
            this.compositePosition += (long)distance[0];
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.move(distance[d], d - 1);
            }
        }

        @Override
        public void move(long[] distance) {
            this.needsUpdate = true;
            this.compositePosition += distance[0];
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.move(distance[d], d - 1);
            }
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.needsUpdate = true;
            this.compositePosition = localizable.getLongPosition(0);
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.setPosition(localizable.getLongPosition(d), d - 1);
            }
        }

        @Override
        public void setPosition(int[] position) {
            this.needsUpdate = true;
            this.compositePosition = position[0];
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.setPosition(position[d], d - 1);
            }
        }

        @Override
        public void setPosition(long[] position) {
            this.needsUpdate = true;
            this.compositePosition = position[0];
            for (int d = 1; d < InterleaveView.this.n; ++d) {
                this.sourceAccess.setPosition(position[d], d - 1);
            }
        }

        @Override
        public void setPosition(int position, int d) {
            if (d == 0) {
                this.compositePosition = position;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.setPosition(position, d - 1);
            }
        }

        @Override
        public void setPosition(long position, int d) {
            if (d == 0) {
                this.compositePosition = position;
            } else {
                this.needsUpdate = true;
                this.sourceAccess.setPosition(position, d - 1);
            }
        }

        @Override
        public T get() {
            if (this.needsUpdate) {
                this.composite = (Composite)this.sourceAccess.get();
                this.needsUpdate = false;
            }
            return this.composite.get(this.compositePosition);
        }

        @Override
        public InterleaveRandomAccess copy() {
            return new InterleaveRandomAccess(this);
        }
    }
}

