/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view.composite;

import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.View;
import net.imglib2.view.composite.Composite;

public class InflateView<T>
implements RandomAccessible<T>,
View {
    protected final RandomAccessible<? extends Composite<T>> source;
    protected final int n;
    protected final int nSource;

    public InflateView(RandomAccessible<? extends Composite<T>> source) {
        this.source = source;
        this.nSource = source.numDimensions();
        this.n = this.nSource + 1;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    public InflateRandomAccess randomAccess() {
        return new InflateRandomAccess();
    }

    public InflateRandomAccess randomAccess(Interval interval) {
        return this.randomAccess();
    }

    public class InflateRandomAccess
    implements RandomAccess<T> {
        protected final RandomAccess<? extends Composite<T>> sourceAccess;
        protected Composite<T> composite;
        protected boolean needsUpdate = true;
        protected long compositePosition = 0L;

        public InflateRandomAccess() {
            this.sourceAccess = InflateView.this.source.randomAccess();
        }

        protected InflateRandomAccess(InflateRandomAccess other) {
            this.sourceAccess = other.sourceAccess.copy();
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                position[d] = this.sourceAccess.getIntPosition(d);
            }
            position[InflateView.this.nSource] = (int)this.compositePosition;
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                position[d] = this.sourceAccess.getLongPosition(d);
            }
            position[InflateView.this.nSource] = this.compositePosition;
        }

        @Override
        public int getIntPosition(int d) {
            return d < InflateView.this.nSource ? this.sourceAccess.getIntPosition(d) : (int)this.compositePosition;
        }

        @Override
        public long getLongPosition(int d) {
            return d < InflateView.this.nSource ? this.sourceAccess.getLongPosition(d) : this.compositePosition;
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                position[d] = this.sourceAccess.getFloatPosition(d);
            }
            position[InflateView.this.nSource] = this.compositePosition;
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                position[d] = this.sourceAccess.getDoublePosition(d);
            }
            position[InflateView.this.nSource] = this.compositePosition;
        }

        @Override
        public float getFloatPosition(int d) {
            return d < InflateView.this.nSource ? this.sourceAccess.getFloatPosition(d) : (float)this.compositePosition;
        }

        @Override
        public double getDoublePosition(int d) {
            return d < InflateView.this.nSource ? this.sourceAccess.getDoublePosition(d) : (double)this.compositePosition;
        }

        @Override
        public int numDimensions() {
            return InflateView.this.n;
        }

        @Override
        public void fwd(int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.fwd(d);
            } else {
                ++this.compositePosition;
            }
        }

        @Override
        public void bck(int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.bck(d);
            } else {
                --this.compositePosition;
            }
        }

        @Override
        public void move(int distance, int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.move(distance, d);
            } else {
                this.compositePosition += (long)distance;
            }
        }

        @Override
        public void move(long distance, int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.move(distance, d);
            } else {
                this.compositePosition += distance;
            }
        }

        @Override
        public void move(Localizable localizable) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.move(localizable.getLongPosition(d), d);
            }
            this.compositePosition += localizable.getLongPosition(InflateView.this.nSource);
        }

        @Override
        public void move(int[] distance) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.move(distance[d], d);
            }
            this.compositePosition += (long)distance[InflateView.this.nSource];
        }

        @Override
        public void move(long[] distance) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.move(distance[d], d);
            }
            this.compositePosition += distance[InflateView.this.nSource];
        }

        @Override
        public void setPosition(Localizable localizable) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.setPosition(localizable.getLongPosition(d), d);
            }
            this.compositePosition = localizable.getLongPosition(InflateView.this.nSource);
        }

        @Override
        public void setPosition(int[] position) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.setPosition(position[d], d);
            }
            this.compositePosition = position[InflateView.this.nSource];
        }

        @Override
        public void setPosition(long[] position) {
            this.needsUpdate = true;
            for (int d = 0; d < InflateView.this.nSource; ++d) {
                this.sourceAccess.setPosition(position[d], d);
            }
            this.compositePosition = position[InflateView.this.nSource];
        }

        @Override
        public void setPosition(int position, int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.setPosition(position, d);
            } else {
                this.compositePosition = position;
            }
        }

        @Override
        public void setPosition(long position, int d) {
            if (d < InflateView.this.nSource) {
                this.needsUpdate = true;
                this.sourceAccess.setPosition(position, d);
            } else {
                this.compositePosition = position;
            }
        }

        @Override
        public T get() {
            if (this.needsUpdate) {
                this.composite = (Composite)this.sourceAccess.get();
                this.needsUpdate = false;
            }
            return this.composite.get(this.compositePosition);
        }

        @Override
        public InflateRandomAccess copy() {
            return new InflateRandomAccess(this);
        }
    }
}

