/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import net.imglib2.EuclideanSpace;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealRandomAccessible;
import net.imglib2.interpolation.Interpolant;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.outofbounds.OutOfBoundsBorderFactory;
import net.imglib2.outofbounds.OutOfBoundsConstantValueFactory;
import net.imglib2.outofbounds.OutOfBoundsFactory;
import net.imglib2.outofbounds.OutOfBoundsMirrorFactory;
import net.imglib2.outofbounds.OutOfBoundsPeriodicFactory;
import net.imglib2.outofbounds.OutOfBoundsRandomValueFactory;
import net.imglib2.transform.integer.BoundingBox;
import net.imglib2.transform.integer.MixedTransform;
import net.imglib2.transform.integer.permutation.AbstractPermutationTransform;
import net.imglib2.transform.integer.permutation.PermutationTransform;
import net.imglib2.transform.integer.permutation.SingleDimensionPermutationTransform;
import net.imglib2.transform.integer.shear.InverseShearTransform;
import net.imglib2.transform.integer.shear.ShearTransform;
import net.imglib2.type.BooleanType;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.IntegerType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.util.Grid;
import net.imglib2.util.Intervals;
import net.imglib2.util.Pair;
import net.imglib2.util.Util;
import net.imglib2.view.BundleView;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.FunctionView;
import net.imglib2.view.HyperSlicesView;
import net.imglib2.view.IntervalView;
import net.imglib2.view.IterableRandomAccessibleInterval;
import net.imglib2.view.MixedTransformView;
import net.imglib2.view.RandomAccessibleOnRealRandomAccessible;
import net.imglib2.view.RandomAccessiblePair;
import net.imglib2.view.StackView;
import net.imglib2.view.SubsampleIntervalView;
import net.imglib2.view.SubsampleView;
import net.imglib2.view.TransformView;
import net.imglib2.view.ViewTransforms;
import net.imglib2.view.composite.Composite;
import net.imglib2.view.composite.CompositeIntervalView;
import net.imglib2.view.composite.CompositeView;
import net.imglib2.view.composite.GenericComposite;
import net.imglib2.view.composite.InflateView;
import net.imglib2.view.composite.InterleaveView;
import net.imglib2.view.composite.NumericComposite;
import net.imglib2.view.composite.RealComposite;

public class Views {
    public static <T, F extends EuclideanSpace> RealRandomAccessible<T> interpolate(F source, InterpolatorFactory<T, F> factory) {
        return new Interpolant<T, F>(source, factory, source.numDimensions());
    }

    public static <T> RandomAccessibleOnRealRandomAccessible<T> raster(RealRandomAccessible<T> source) {
        return new RandomAccessibleOnRealRandomAccessible<T>(source);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extend(F source, OutOfBoundsFactory<T, ? super F> factory) {
        return new ExtendedRandomAccessibleInterval<T, F>(source, factory);
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorSingle(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.SINGLE));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendMirrorDouble(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsMirrorFactory(OutOfBoundsMirrorFactory.Boundary.DOUBLE));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, T value) {
        return new ExtendedRandomAccessibleInterval<T, F>(source, new OutOfBoundsConstantValueFactory(value));
    }

    @Deprecated
    public static <T extends Type<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, T value) {
        return Views.extendValue(source, value);
    }

    public static <T extends RealType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, float value) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(source)).createVariable();
        extension.setReal(value);
        return Views.extendValue(source, extension);
    }

    public static <T extends RealType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, double value) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(source)).createVariable();
        extension.setReal(value);
        return Views.extendValue(source, extension);
    }

    public static <T extends IntegerType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, int value) {
        IntegerType extension = (IntegerType)((IntegerType)Util.getTypeFromInterval(source)).createVariable();
        extension.setInteger(value);
        return Views.extendValue(source, extension);
    }

    public static <T extends IntegerType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, long value) {
        IntegerType extension = (IntegerType)((IntegerType)Util.getTypeFromInterval(source)).createVariable();
        extension.setInteger(value);
        return Views.extendValue(source, extension);
    }

    public static <T extends BooleanType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendValue(F source, boolean value) {
        BooleanType extension = (BooleanType)((BooleanType)Util.getTypeFromInterval(source)).createVariable();
        extension.set(value);
        return Views.extendValue(source, extension);
    }

    public static <T extends NumericType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendZero(F source) {
        NumericType zero = (NumericType)((NumericType)Util.getTypeFromInterval(source)).createVariable();
        zero.setZero();
        return new ExtendedRandomAccessibleInterval<NumericType, F>(source, new OutOfBoundsConstantValueFactory(zero));
    }

    public static <T extends RealType<T>, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendRandom(F source, double min, double max) {
        return new ExtendedRandomAccessibleInterval<RealType, F>(source, new OutOfBoundsRandomValueFactory((RealType)Util.getTypeFromInterval(source), min, max));
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendPeriodic(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsPeriodicFactory());
    }

    public static <T, F extends RandomAccessibleInterval<T>> ExtendedRandomAccessibleInterval<T, F> extendBorder(F source) {
        return new ExtendedRandomAccessibleInterval(source, new OutOfBoundsBorderFactory());
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, long[] min, long[] max) {
        return new IntervalView<T>(randomAccessible, min, max);
    }

    public static <T> IntervalView<T> interval(RandomAccessible<T> randomAccessible, Interval interval) {
        return new IntervalView<T>(randomAccessible, interval);
    }

    public static <T> RandomAccessible<RandomAccessibleInterval<T>> intervals(RandomAccessible<T> img, RandomAccessible<? extends Interval> intervals) {
        return new FunctionView<Interval, RandomAccessibleInterval>(intervals, interval -> Views.interval(img, interval));
    }

    public static <T> RandomAccessibleInterval<RandomAccessibleInterval<T>> intervals(RandomAccessible<T> img, RandomAccessibleInterval<? extends Interval> intervals) {
        return Views.interval(Views.intervals(img, intervals), intervals);
    }

    public static <T> RandomAccessibleInterval<RandomAccessibleInterval<T>> tiles(RandomAccessibleInterval<T> source, long ... tileSize) {
        long[] b = tileSize;
        if (tileSize.length != source.numDimensions() && (b = Arrays.copyOf(tileSize, source.numDimensions())).length > tileSize.length) {
            Arrays.fill(b, tileSize.length, b.length, 1L);
        }
        Grid grid = new Grid(source.dimensionsAsLongArray(), b);
        return Views.intervals(source, grid.cellIntervals());
    }

    public static <T> RandomAccessibleInterval<RandomAccessibleInterval<T>> tiles(RandomAccessibleInterval<T> source, int ... tileSize) {
        return Views.tiles(source, Util.int2long(tileSize));
    }

    public static <T> MixedTransformView<T> rotate(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        return new MixedTransformView<T>(randomAccessible, ViewTransforms.rotate(n, fromAxis, toAxis));
    }

    public static <T> IntervalView<T> rotate(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        return Views.interval(Views.rotate(interval, fromAxis, toAxis), Intervals.rotate(interval, fromAxis, toAxis));
    }

    public static <T> MixedTransformView<T> permute(RandomAccessible<T> randomAccessible, int fromAxis, int toAxis) {
        int n = randomAccessible.numDimensions();
        return new MixedTransformView<T>(randomAccessible, ViewTransforms.permute(n, fromAxis, toAxis));
    }

    public static <T> IntervalView<T> permute(RandomAccessibleInterval<T> interval, int fromAxis, int toAxis) {
        return Views.interval(Views.permute(interval, fromAxis, toAxis), Intervals.permuteAxes(interval, fromAxis, toAxis));
    }

    public static <T> RandomAccessible<T> moveAxis(RandomAccessible<T> image, int fromAxis, int toAxis) {
        return new MixedTransformView<T>(image, ViewTransforms.moveAxis(image.numDimensions(), fromAxis, toAxis));
    }

    public static <T> RandomAccessibleInterval<T> moveAxis(RandomAccessibleInterval<T> image, int fromAxis, int toAxis) {
        int n = image.numDimensions();
        MixedTransform t = ViewTransforms.moveAxis(n, fromAxis, toAxis);
        return Views.interval(new MixedTransformView<T>(image, t), Intervals.moveAxis(image, fromAxis, toAxis));
    }

    public static <T> MixedTransformView<T> translate(RandomAccessible<T> randomAccessible, long ... translation) {
        MixedTransform t = ViewTransforms.translate(translation);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> translate(RandomAccessibleInterval<T> interval, long ... translation) {
        return Views.interval(Views.translate(interval, translation), Intervals.translate(interval, translation));
    }

    public static <T> MixedTransformView<T> translateInverse(RandomAccessible<T> randomAccessible, long ... translation) {
        MixedTransform t = ViewTransforms.translateInverse(translation);
        return new MixedTransformView<T>(randomAccessible, t);
    }

    public static <T> IntervalView<T> translateInverse(RandomAccessibleInterval<T> interval, long ... translation) {
        return Views.interval(Views.translateInverse(interval, translation), Intervals.translateInverse(interval, translation));
    }

    @Deprecated
    public static <T> MixedTransformView<T> offset(RandomAccessible<T> randomAccessible, long ... offset) {
        return Views.translateInverse(randomAccessible, offset);
    }

    @Deprecated
    public static <T> IntervalView<T> offset(RandomAccessibleInterval<T> interval, long ... offset) {
        return Views.translateInverse(interval, offset);
    }

    public static <T> IntervalView<T> zeroMin(RandomAccessibleInterval<T> interval) {
        MixedTransform t = ViewTransforms.zeroMin(interval);
        FinalInterval newInterval = Intervals.zeroMin(interval);
        return Views.interval(new MixedTransformView<T>(interval, t), newInterval);
    }

    public static <T> MixedTransformView<T> hyperSlice(RandomAccessible<T> view, int d, long pos) {
        int m = view.numDimensions();
        MixedTransform t = ViewTransforms.hyperSlice(m, d, pos);
        return new MixedTransformView<T>(view, t);
    }

    public static <T> IntervalView<T> hyperSlice(RandomAccessibleInterval<T> view, int d, long pos) {
        return Views.interval(Views.hyperSlice(view, d, pos), Intervals.hyperSlice(view, d));
    }

    public static <T> MixedTransformView<T> addDimension(RandomAccessible<T> randomAccessible) {
        int m = randomAccessible.numDimensions();
        return new MixedTransformView<T>(randomAccessible, ViewTransforms.addDimension(m));
    }

    public static <T> IntervalView<T> addDimension(RandomAccessibleInterval<T> interval, long minOfNewDim, long maxOfNewDim) {
        return Views.interval(Views.addDimension(interval), Intervals.addDimension(interval, minOfNewDim, maxOfNewDim));
    }

    public static <T> MixedTransformView<T> invertAxis(RandomAccessible<T> randomAccessible, int d) {
        int n = randomAccessible.numDimensions();
        return new MixedTransformView<T>(randomAccessible, ViewTransforms.invertAxis(n, d));
    }

    public static <T> IntervalView<T> invertAxis(RandomAccessibleInterval<T> interval, int d) {
        return Views.interval(Views.invertAxis(interval, d), Intervals.invertAxis(interval, d));
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, long[] offset, long[] dimension) {
        int n = randomAccessible.numDimensions();
        long[] min = new long[n];
        long[] max = new long[n];
        for (int d = 0; d < n; ++d) {
            max[d] = dimension[d] - 1L;
        }
        return Views.interval(Views.offset(randomAccessible, offset), min, max);
    }

    public static <T> IntervalView<T> offsetInterval(RandomAccessible<T> randomAccessible, Interval interval) {
        return Views.zeroMin(Views.interval(randomAccessible, interval));
    }

    public static boolean isZeroMin(Interval interval) {
        for (int d = 0; d < interval.numDimensions(); ++d) {
            if (interval.min(d) == 0L) continue;
            return false;
        }
        return true;
    }

    public static <T> IterableInterval<T> iterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval)) {
            Object o;
            Class<?> raiType = Util.getTypeFromInterval(randomAccessibleInterval).getClass();
            Iterator iter = ((IterableInterval)((Object)randomAccessibleInterval)).iterator();
            Object v0 = o = iter.hasNext() ? iter.next() : null;
            if (raiType.isInstance(o)) {
                return (IterableInterval)((Object)randomAccessibleInterval);
            }
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> IterableInterval<T> flatIterable(RandomAccessibleInterval<T> randomAccessibleInterval) {
        if (IterableInterval.class.isInstance(randomAccessibleInterval) && FlatIterationOrder.class.isInstance(((IterableInterval)((Object)randomAccessibleInterval)).iterationOrder())) {
            Object o;
            Class<?> raiType = Util.getTypeFromInterval(randomAccessibleInterval).getClass();
            Iterator iter = ((IterableInterval)((Object)randomAccessibleInterval)).iterator();
            Object v0 = o = iter.hasNext() ? iter.next() : null;
            if (raiType.isInstance(o)) {
                return (IterableInterval)((Object)randomAccessibleInterval);
            }
        }
        return new IterableRandomAccessibleInterval<T>(randomAccessibleInterval);
    }

    public static <T> CompositeIntervalView<T, ? extends GenericComposite<T>> collapse(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeIntervalView<T, RealComposite<T>> collapseReal(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new RealComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T extends NumericType<T>> CompositeIntervalView<T, NumericComposite<T>> collapseNumeric(RandomAccessibleInterval<T> source) {
        return new CompositeIntervalView(source, new NumericComposite.Factory((int)source.dimension(source.numDimensions() - 1)));
    }

    public static <T> CompositeView<T, ? extends GenericComposite<T>> collapse(RandomAccessible<T> source) {
        return new CompositeView(source, new GenericComposite.Factory());
    }

    public static <T extends RealType<T>> CompositeView<T, RealComposite<T>> collapseReal(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new RealComposite.Factory(numChannels));
    }

    public static <T extends NumericType<T>> CompositeView<T, NumericComposite<T>> collapseNumeric(RandomAccessible<T> source, int numChannels) {
        return new CompositeView(source, new NumericComposite.Factory(numChannels));
    }

    public static <T> SubsampleIntervalView<T> subsample(RandomAccessibleInterval<T> source, long step) {
        return new SubsampleIntervalView<T>(source, step);
    }

    public static <T> SubsampleIntervalView<T> subsample(RandomAccessibleInterval<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleIntervalView<T>(source, steps);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long step) {
        return new SubsampleView<T>(source, step);
    }

    public static <T> SubsampleView<T> subsample(RandomAccessible<T> source, long ... steps) {
        assert (steps.length >= source.numDimensions()) : "Dimensions do not match.";
        return new SubsampleView<T>(source, steps);
    }

    public static <T> RandomAccessibleInterval<T> dropSingletonDimensions(RandomAccessibleInterval<T> source) {
        RandomAccessibleInterval<T> res = source;
        for (int d = source.numDimensions() - 1; d >= 0; --d) {
            if (source.dimension(d) != 1L) continue;
            res = Views.hyperSlice(res, d, source.min(d));
        }
        return res;
    }

    public static <T> RandomAccessibleInterval<T> stack(List<? extends RandomAccessibleInterval<T>> hyperslices) {
        return new StackView(hyperslices);
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> stack(RandomAccessibleInterval<T> ... hyperslices) {
        return new StackView<T>(Arrays.asList(hyperslices));
    }

    public static <T> RandomAccessibleInterval<T> stack(StackView.StackAccessMode stackAccessMode, List<? extends RandomAccessibleInterval<T>> hyperslices) {
        return new StackView(hyperslices, stackAccessMode);
    }

    public static <T> RandomAccessibleInterval<T> stack(StackView.StackAccessMode stackAccessMode, RandomAccessibleInterval<T> ... hyperslices) {
        return new StackView<T>(Arrays.asList(hyperslices), stackAccessMode);
    }

    public static <T> TransformView<T> shear(RandomAccessible<T> source, int shearDimension, int referenceDimension) {
        ShearTransform transform = new ShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return new TransformView<T>(source, transform.inverse());
    }

    public static <T> TransformView<T> unshear(RandomAccessible<T> source, int shearDimension, int referenceDimension) {
        InverseShearTransform transform = new InverseShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return new TransformView<T>(source, transform.inverse());
    }

    public static <T> IntervalView<T> shear(RandomAccessible<T> source, Interval interval, int shearDimension, int referenceDimension) {
        ShearTransform transform = new ShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return Views.interval(Views.shear(source, shearDimension, referenceDimension), transform.transform(new BoundingBox(interval)).getInterval());
    }

    public static <T> IntervalView<T> unshear(RandomAccessible<T> source, Interval interval, int shearDimension, int referenceDimension) {
        InverseShearTransform transform = new InverseShearTransform(source.numDimensions(), shearDimension, referenceDimension);
        return Views.interval(Views.unshear(source, shearDimension, referenceDimension), transform.transform(new BoundingBox(interval)).getInterval());
    }

    public static <T> IntervalView<T> permuteCoordinates(RandomAccessibleInterval<T> source, int[] permutation) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (PermutationTransform.checkInterval(source, permutation)) : "Source interval boundaries do not match permutation.";
        int nDim = source.numDimensions();
        PermutationTransform transform = new PermutationTransform(permutation, nDim, nDim);
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <T> IntervalView<T> permuteCoordinates(RandomAccessibleInterval<T> source, int[] permutation, int d) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (source.min(d) == 0L) : "Source with min[d] coordinate != 0 passed to coordinate permutation.";
        assert (source.dimension(d) == (long)permutation.length) : "Source with dimension[d] != LUT.length passed to coordinate permutation.";
        int nDim = source.numDimensions();
        SingleDimensionPermutationTransform transform = new SingleDimensionPermutationTransform(permutation, nDim, nDim, d);
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <T> IntervalView<T> permuteCoordinatesInverse(RandomAccessibleInterval<T> source, int[] permutation) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (PermutationTransform.checkInterval(source, permutation)) : "Source interval boundaries do not match permutation.";
        int nDim = source.numDimensions();
        PermutationTransform transform = new PermutationTransform(permutation, nDim, nDim).inverse();
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    @Deprecated
    public static <T> IntervalView<T> permuteCoordinateInverse(RandomAccessibleInterval<T> source, int[] permutation, int d) {
        return Views.permuteCoordinatesInverse(source, permutation, d);
    }

    public static <T> IntervalView<T> permuteCoordinatesInverse(RandomAccessibleInterval<T> source, int[] permutation, int d) {
        assert (AbstractPermutationTransform.checkBijectivity(permutation)) : "Non-bijective LUT passed for coordinate permuation.";
        assert (source.min(d) == 0L) : "Source with min[d] coordinate != 0 passed to coordinate permutation.";
        assert (source.dimension(d) == (long)permutation.length) : "Source with dimension[d] != LUT.length passed to coordinate permutation.";
        int nDim = source.numDimensions();
        SingleDimensionPermutationTransform transform = new SingleDimensionPermutationTransform(permutation, nDim, nDim, d).inverse();
        return Views.interval(new TransformView<T>(source, transform.inverse()), source);
    }

    public static <A, B> RandomAccessible<Pair<A, B>> pair(RandomAccessible<A> sourceA, RandomAccessible<B> sourceB) {
        return new RandomAccessiblePair<A, B>(sourceA, sourceB);
    }

    public static <T> RandomAccessible<? extends RandomAccessible<T>> hyperSlices(RandomAccessible<T> source, int ... axes) {
        return new HyperSlicesView<T>(source, axes);
    }

    public static <T, F extends RandomAccessibleInterval<T>> IntervalView<T> expand(F source, OutOfBoundsFactory<T, ? super F> oob, long ... border) {
        return Views.interval(Views.extend(source, oob), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandMirrorSingle(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendMirrorSingle(source), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandMirrorDouble(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendMirrorDouble(source), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, T t, long ... border) {
        return Views.interval(Views.extendValue(source, t), Intervals.expand(source, border));
    }

    @Deprecated
    public static <T extends Type<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, T t, long ... border) {
        return Views.expandValue(source, t, border);
    }

    public static <T extends RealType<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, float value, long ... border) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(source)).createVariable();
        extension.setReal(value);
        return Views.expandValue(source, extension, border);
    }

    public static <T extends RealType<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, double value, long ... border) {
        RealType extension = (RealType)((RealType)Util.getTypeFromInterval(source)).createVariable();
        extension.setReal(value);
        return Views.expandValue(source, extension, border);
    }

    public static <T extends IntegerType<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, int value, long ... border) {
        IntegerType extension = (IntegerType)((IntegerType)Util.getTypeFromInterval(source)).createVariable();
        extension.setInteger(value);
        return Views.expandValue(source, extension, border);
    }

    public static <T extends IntegerType<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, long value, long ... border) {
        IntegerType extension = (IntegerType)((IntegerType)Util.getTypeFromInterval(source)).createVariable();
        extension.setInteger(value);
        return Views.expandValue(source, extension, border);
    }

    public static <T extends BooleanType<T>> IntervalView<T> expandValue(RandomAccessibleInterval<T> source, boolean value, long ... border) {
        BooleanType extension = (BooleanType)((BooleanType)Util.getTypeFromInterval(source)).createVariable();
        extension.set(value);
        return Views.expandValue(source, extension, border);
    }

    public static <T extends NumericType<T>> IntervalView<T> expandZero(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendZero(source), Intervals.expand(source, border));
    }

    public static <T extends RealType<T>> IntervalView<T> expandRandom(RandomAccessibleInterval<T> source, double min, double max, long ... border) {
        return Views.interval(Views.extendRandom(source, min, max), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandPeriodic(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendPeriodic(source), Intervals.expand(source, border));
    }

    public static <T> IntervalView<T> expandBorder(RandomAccessibleInterval<T> source, long ... border) {
        return Views.interval(Views.extendBorder(source), Intervals.expand(source, border));
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, RandomAccessibleInterval<T> ... sources) {
        return Views.concatenate(concatenationAxis, StackView.StackAccessMode.DEFAULT, sources);
    }

    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, List<? extends RandomAccessibleInterval<T>> sources) {
        return Views.concatenate(concatenationAxis, StackView.StackAccessMode.DEFAULT, sources);
    }

    @SafeVarargs
    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, StackView.StackAccessMode mode, RandomAccessibleInterval<T> ... sources) {
        return Views.concatenate(concatenationAxis, mode, Arrays.asList(sources));
    }

    public static <T> RandomAccessibleInterval<T> concatenate(int concatenationAxis, StackView.StackAccessMode mode, List<? extends RandomAccessibleInterval<T>> sources) {
        assert (sources.size() > 0);
        ArrayList<IntervalView<T>> hyperSlices = new ArrayList<IntervalView<T>>();
        for (RandomAccessibleInterval<T> source : sources) {
            for (long index = source.min(concatenationAxis); index <= source.max(concatenationAxis); ++index) {
                hyperSlices.add(Views.hyperSlice(source, concatenationAxis, index));
            }
        }
        RandomAccessibleInterval<T> stacked = Views.stack(mode, hyperSlices);
        return Views.moveAxis(stacked, stacked.numDimensions() - 1, concatenationAxis);
    }

    public static <T> InflateView<T> inflate(RandomAccessible<? extends Composite<T>> source) {
        return new InflateView(source);
    }

    public static <T> InterleaveView<T> interleave(RandomAccessible<? extends Composite<T>> source) {
        return new InterleaveView(source);
    }

    public static <T> BundleView<T> bundle(RandomAccessible<T> source) {
        return new BundleView<T>(source);
    }
}

