/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.transform.integer.Translation;

public final class TranslationRandomAccess<T>
extends AbstractEuclideanSpace
implements RandomAccess<T> {
    private final RandomAccess<T> s;
    private final long[] translation;
    private final long[] tmp;

    TranslationRandomAccess(RandomAccess<T> source, Translation transformToSource) {
        super(transformToSource.numSourceDimensions());
        assert (source.numDimensions() == transformToSource.numTargetDimensions());
        this.s = source;
        this.translation = new long[this.n];
        transformToSource.getTranslation(this.translation);
        this.tmp = new long[this.n];
    }

    protected TranslationRandomAccess(TranslationRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.s = randomAccess.s.copy();
        this.translation = (long[])randomAccess.translation.clone();
        this.tmp = new long[this.n];
    }

    @Override
    public void localize(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.s.getIntPosition(d) - (int)this.translation[d];
        }
    }

    @Override
    public void localize(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.s.getLongPosition(d) - (long)((int)this.translation[d]);
        }
    }

    @Override
    public int getIntPosition(int d) {
        assert (d <= this.n);
        return this.s.getIntPosition(d) - (int)this.translation[d];
    }

    @Override
    public long getLongPosition(int d) {
        assert (d <= this.n);
        return this.s.getLongPosition(d) - (long)((int)this.translation[d]);
    }

    @Override
    public void localize(float[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.s.getFloatPosition(d) - (float)this.translation[d];
        }
    }

    @Override
    public void localize(double[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            position[d] = this.s.getDoublePosition(d) - (double)this.translation[d];
        }
    }

    @Override
    public float getFloatPosition(int d) {
        assert (d <= this.n);
        return this.s.getFloatPosition(d) - (float)this.translation[d];
    }

    @Override
    public double getDoublePosition(int d) {
        assert (d <= this.n);
        return this.s.getDoublePosition(d) - (double)this.translation[d];
    }

    @Override
    public void fwd(int d) {
        this.s.fwd(d);
    }

    @Override
    public void bck(int d) {
        this.s.bck(d);
    }

    @Override
    public void move(int distance, int d) {
        this.s.move(distance, d);
    }

    @Override
    public void move(long distance, int d) {
        this.s.move(distance, d);
    }

    @Override
    public void move(Localizable localizable) {
        this.s.move(localizable);
    }

    @Override
    public void move(int[] distance) {
        this.s.move(distance);
    }

    @Override
    public void move(long[] distance) {
        this.s.move(distance);
    }

    @Override
    public void setPosition(Localizable localizable) {
        assert (localizable.numDimensions() == this.n);
        localizable.localize(this.tmp);
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.tmp[n] = this.tmp[n] + this.translation[d];
        }
        this.s.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmp[d] = (long)position[d] + this.translation[d];
        }
        this.s.setPosition(this.tmp);
    }

    @Override
    public void setPosition(long[] position) {
        assert (position.length >= this.n);
        for (int d = 0; d < this.n; ++d) {
            this.tmp[d] = position[d] + this.translation[d];
        }
        this.s.setPosition(this.tmp);
    }

    @Override
    public void setPosition(int position, int d) {
        assert (d <= this.n);
        this.s.setPosition((long)position + this.translation[d], d);
    }

    @Override
    public void setPosition(long position, int d) {
        assert (d <= this.n);
        this.s.setPosition(position + this.translation[d], d);
    }

    @Override
    public T get() {
        return this.s.get();
    }

    @Override
    public TranslationRandomAccess<T> copy() {
        return new TranslationRandomAccess<T>(this);
    }
}

