/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.view;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.List;
import net.imglib2.AbstractInterval;
import net.imglib2.FinalInterval;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.View;
import net.imglib2.util.Cast;

public class StackView<T>
extends AbstractInterval
implements RandomAccessibleInterval<T>,
View {
    private final RandomAccessibleInterval<T>[] slices;
    private final StackAccessMode stackAccessMode;

    public StackView(List<? extends RandomAccessibleInterval<T>> hyperslices) {
        this(hyperslices, StackAccessMode.DEFAULT);
    }

    public StackView(List<? extends RandomAccessibleInterval<T>> hyperslices, StackAccessMode stackAccessMode) {
        super(hyperslices.get(0).numDimensions() + 1);
        this.stackAccessMode = stackAccessMode;
        this.slices = hyperslices.toArray(new RandomAccessibleInterval[hyperslices.size()]);
        for (int d = 0; d < this.n - 1; ++d) {
            this.min[d] = this.slices[0].min(d);
            this.max[d] = this.slices[0].max(d);
        }
        this.min[this.n - 1] = 0L;
        this.max[this.n - 1] = this.slices.length - 1;
    }

    @Override
    public RandomAccess<T> randomAccess() {
        return this.stackAccessMode == StackAccessMode.MOVE_ALL_SLICE_ACCESSES ? new MoveAllSlicesRA<T>(this.slices) : new DefaultRA<T>(this.slices);
    }

    @Override
    public RandomAccess<T> randomAccess(Interval interval) {
        return this.stackAccessMode == StackAccessMode.MOVE_ALL_SLICE_ACCESSES ? new MoveAllSlicesRA<T>(this.slices, interval) : new DefaultRA<T>(this.slices, interval);
    }

    public List<RandomAccessibleInterval<T>> getSourceSlices() {
        return Arrays.asList(this.slices);
    }

    public StackAccessMode getStackAccessMode() {
        return this.stackAccessMode;
    }

    public static class MoveAllSlicesRA<T>
    implements RandomAccess<T> {
        private final int n;
        private final int sd;
        private int slice;
        private final long[] tmpLong;
        private final int[] tmpInt;
        private final RandomAccess<T>[] sliceAccesses;

        public MoveAllSlicesRA(RandomAccessibleInterval<T>[] slices) {
            this(slices, null);
        }

        public MoveAllSlicesRA(RandomAccessibleInterval<T>[] slices, Interval interval) {
            this.n = slices[0].numDimensions() + 1;
            this.sd = this.n - 1;
            this.slice = 0;
            this.tmpLong = new long[this.sd];
            this.tmpInt = new int[this.sd];
            this.sliceAccesses = new RandomAccess[slices.length];
            if (interval == null) {
                for (int i = 0; i < slices.length; ++i) {
                    this.sliceAccesses[i] = slices[i].randomAccess();
                }
            } else {
                long[] smin = new long[this.sd];
                long[] smax = new long[this.sd];
                for (int d = 0; d < this.sd; ++d) {
                    smin[d] = interval.min(d);
                    smax[d] = interval.max(d);
                }
                FinalInterval sliceInterval = new FinalInterval(smin, smax);
                for (int i = 0; i < slices.length; ++i) {
                    this.sliceAccesses[i] = slices[i].randomAccess(sliceInterval);
                }
            }
        }

        private MoveAllSlicesRA(MoveAllSlicesRA<T> a) {
            this.sliceAccesses = (RandomAccess[])Cast.unchecked(Array.newInstance(RandomAccess.class, a.sliceAccesses.length));
            for (int i = 0; i < this.sliceAccesses.length; ++i) {
                this.sliceAccesses[i] = a.sliceAccesses[i].copy();
            }
            this.slice = a.slice;
            this.n = a.n;
            this.sd = a.sd;
            this.tmpLong = (long[])a.tmpLong.clone();
            this.tmpInt = (int[])a.tmpInt.clone();
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccesses[0].getIntPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccesses[0].getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public int getIntPosition(int d) {
            return d < this.sd ? this.sliceAccesses[0].getIntPosition(d) : this.slice;
        }

        @Override
        public long getLongPosition(int d) {
            return d < this.sd ? this.sliceAccesses[0].getLongPosition(d) : (long)this.slice;
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccesses[0].getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccesses[0].getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public float getFloatPosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public int numDimensions() {
            return this.n;
        }

        @Override
        public void fwd(int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].fwd(d);
                }
            } else {
                ++this.slice;
            }
        }

        @Override
        public void bck(int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].bck(d);
                }
            } else {
                --this.slice;
            }
        }

        @Override
        public void move(int distance, int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].move(distance, d);
                }
            } else {
                this.slice += distance;
            }
        }

        @Override
        public void move(long distance, int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].move(distance, d);
                }
            } else {
                this.slice += (int)distance;
            }
        }

        @Override
        public void move(Localizable distance) {
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                for (int d = 0; d < this.sd; ++d) {
                    this.sliceAccesses[s].move(distance.getLongPosition(d), d);
                }
            }
            this.slice += distance.getIntPosition(this.sd);
        }

        @Override
        public void move(int[] distance) {
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                for (int d = 0; d < this.sd; ++d) {
                    this.sliceAccesses[s].move(distance[d], d);
                }
            }
            this.slice += distance[this.sd];
        }

        @Override
        public void move(long[] distance) {
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                for (int d = 0; d < this.sd; ++d) {
                    this.sliceAccesses[s].move(distance[d], d);
                }
            }
            this.slice += (int)distance[this.sd];
        }

        @Override
        public void setPosition(Localizable position) {
            for (int d = 0; d < this.sd; ++d) {
                this.tmpLong[d] = position.getLongPosition(d);
            }
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                this.sliceAccesses[s].setPosition(this.tmpLong);
            }
            this.slice = position.getIntPosition(this.sd);
        }

        @Override
        public void setPosition(int[] position) {
            System.arraycopy(position, 0, this.tmpInt, 0, this.sd);
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                this.sliceAccesses[s].setPosition(this.tmpInt);
            }
            this.slice = position[this.sd];
        }

        @Override
        public void setPosition(long[] position) {
            System.arraycopy(position, 0, this.tmpLong, 0, this.sd);
            for (int s = 0; s < this.sliceAccesses.length; ++s) {
                this.sliceAccesses[s].setPosition(this.tmpLong);
            }
            this.slice = (int)position[this.sd];
        }

        @Override
        public void setPosition(int position, int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].setPosition(position, d);
                }
            } else {
                this.slice = position;
            }
        }

        @Override
        public void setPosition(long position, int d) {
            if (d < this.sd) {
                for (int s = 0; s < this.sliceAccesses.length; ++s) {
                    this.sliceAccesses[s].setPosition(position, d);
                }
            } else {
                this.slice = (int)position;
            }
        }

        @Override
        public T get() {
            return this.sliceAccesses[this.slice].get();
        }

        @Override
        public MoveAllSlicesRA<T> copy() {
            return new MoveAllSlicesRA<T>(this);
        }
    }

    public static final class DefaultRA<T>
    implements RandomAccess<T> {
        private final int n;
        private final int sd;
        private int slice;
        private final long[] tmpLong;
        private final int[] tmpInt;
        private final RandomAccess<T>[] sliceAccesses;
        private RandomAccess<T> sliceAccess;

        public DefaultRA(RandomAccessibleInterval<T>[] slices) {
            this(slices, null);
        }

        public DefaultRA(RandomAccessibleInterval<T>[] slices, Interval interval) {
            this.n = slices[0].numDimensions() + 1;
            this.sd = this.n - 1;
            this.slice = 0;
            this.tmpLong = new long[this.sd];
            this.tmpInt = new int[this.sd];
            this.sliceAccesses = new RandomAccess[slices.length];
            if (interval == null) {
                for (int i = 0; i < slices.length; ++i) {
                    this.sliceAccesses[i] = slices[i].randomAccess();
                }
            } else {
                long[] smin = new long[this.sd];
                long[] smax = new long[this.sd];
                for (int d = 0; d < this.sd; ++d) {
                    smin[d] = interval.min(d);
                    smax[d] = interval.max(d);
                }
                FinalInterval sliceInterval = new FinalInterval(smin, smax);
                for (int i = 0; i < slices.length; ++i) {
                    this.sliceAccesses[i] = slices[i].randomAccess(sliceInterval);
                }
            }
            this.sliceAccess = this.sliceAccesses[this.slice];
        }

        private DefaultRA(DefaultRA<T> a) {
            this.sliceAccesses = (RandomAccess[])Cast.unchecked(Array.newInstance(RandomAccess.class, a.sliceAccesses.length));
            for (int i = 0; i < this.sliceAccesses.length; ++i) {
                this.sliceAccesses[i] = a.sliceAccesses[i].copy();
            }
            this.slice = a.slice;
            this.sliceAccess = this.sliceAccesses[this.slice];
            this.n = a.n;
            this.sd = a.sd;
            this.tmpLong = (long[])a.tmpLong.clone();
            this.tmpInt = (int[])a.tmpInt.clone();
        }

        @Override
        public void localize(int[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccess.getIntPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public void localize(long[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccess.getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public int getIntPosition(int d) {
            return d < this.sd ? this.sliceAccess.getIntPosition(d) : this.slice;
        }

        @Override
        public long getLongPosition(int d) {
            return d < this.sd ? this.sliceAccess.getLongPosition(d) : (long)this.slice;
        }

        @Override
        public void localize(float[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccess.getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public void localize(double[] position) {
            for (int d = 0; d < this.sd; ++d) {
                position[d] = this.sliceAccess.getLongPosition(d);
            }
            position[this.sd] = this.slice;
        }

        @Override
        public float getFloatPosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public double getDoublePosition(int d) {
            return this.getLongPosition(d);
        }

        @Override
        public int numDimensions() {
            return this.n;
        }

        @Override
        public void fwd(int d) {
            if (d < this.sd) {
                this.sliceAccess.fwd(d);
            } else {
                this.setSlice(this.slice + 1);
            }
        }

        @Override
        public void bck(int d) {
            if (d < this.sd) {
                this.sliceAccess.bck(d);
            } else {
                this.setSlice(this.slice - 1);
            }
        }

        @Override
        public void move(int distance, int d) {
            if (d < this.sd) {
                this.sliceAccess.move(distance, d);
            } else {
                this.setSlice(this.slice + distance);
            }
        }

        @Override
        public void move(long distance, int d) {
            if (d < this.sd) {
                this.sliceAccess.move(distance, d);
            } else {
                this.setSlice(this.slice + (int)distance);
            }
        }

        @Override
        public void move(Localizable distance) {
            for (int d = 0; d < this.sd; ++d) {
                this.sliceAccess.move(distance.getLongPosition(d), d);
            }
            this.setSlice(this.slice + distance.getIntPosition(this.sd));
        }

        @Override
        public void move(int[] distance) {
            for (int d = 0; d < this.sd; ++d) {
                this.sliceAccess.move(distance[d], d);
            }
            this.setSlice(this.slice + distance[this.sd]);
        }

        @Override
        public void move(long[] distance) {
            for (int d = 0; d < this.sd; ++d) {
                this.sliceAccess.move(distance[d], d);
            }
            this.setSlice(this.slice + (int)distance[this.sd]);
        }

        @Override
        public void setPosition(Localizable position) {
            for (int d = 0; d < this.sd; ++d) {
                this.tmpLong[d] = position.getLongPosition(d);
            }
            this.sliceAccess.setPosition(this.tmpLong);
            this.setSlice(position.getIntPosition(this.sd));
        }

        @Override
        public void setPosition(int[] position) {
            System.arraycopy(position, 0, this.tmpInt, 0, this.sd);
            this.sliceAccess.setPosition(this.tmpInt);
            this.setSlice(position[this.sd]);
        }

        @Override
        public void setPosition(long[] position) {
            System.arraycopy(position, 0, this.tmpLong, 0, this.sd);
            this.sliceAccess.setPosition(this.tmpLong);
            this.setSlice(position[this.sd]);
        }

        @Override
        public void setPosition(int position, int d) {
            if (d < this.sd) {
                this.sliceAccess.setPosition(position, d);
            } else {
                this.setSlice(position);
            }
        }

        @Override
        public void setPosition(long position, int d) {
            if (d < this.sd) {
                this.sliceAccess.setPosition(position, d);
            } else {
                this.setSlice(position);
            }
        }

        private void setSlice(int i) {
            if (i != this.slice) {
                this.slice = i;
                if (this.slice >= 0 && this.slice < this.sliceAccesses.length) {
                    this.sliceAccesses[this.slice].setPosition(this.sliceAccess);
                    this.sliceAccess = this.sliceAccesses[this.slice];
                }
            }
        }

        private void setSlice(long i) {
            this.setSlice((int)i);
        }

        @Override
        public T get() {
            return this.sliceAccess.get();
        }

        @Override
        public DefaultRA<T> copy() {
            return new DefaultRA<T>(this);
        }
    }

    public static enum StackAccessMode {
        DEFAULT,
        MOVE_ALL_SLICE_ACCESSES;

    }
}

