/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import net.imglib2.AbstractEuclideanSpace;
import net.imglib2.Interval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.RealInterval;
import net.imglib2.RealLocalizable;
import net.imglib2.RealPoint;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.view.Views;

public class Localizables {
    @Deprecated
    public static long[] asLongArray(Localizable localizable) {
        long[] result = new long[localizable.numDimensions()];
        localizable.localize(result);
        return result;
    }

    public static RandomAccessible<Localizable> randomAccessible(int n) {
        return new LocationRandomAccessible(n);
    }

    public static RandomAccessibleInterval<Localizable> randomAccessibleInterval(Interval interval) {
        return Views.interval(Localizables.randomAccessible(interval.numDimensions()), interval);
    }

    public static RealRandomAccessible<RealLocalizable> realRandomAccessible(int n) {
        return new RealLocationRealRandomAccessible(n);
    }

    public static boolean equals(Localizable a, Localizable b) {
        int n = a.numDimensions();
        if (n != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < n; ++d) {
            if (a.getLongPosition(d) == b.getLongPosition(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealLocalizable a, RealLocalizable b) {
        int n = a.numDimensions();
        if (n != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < n; ++d) {
            if (a.getDoublePosition(d) == b.getDoublePosition(d)) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(RealLocalizable a, RealLocalizable b, double tolerance) {
        int n = a.numDimensions();
        if (n != b.numDimensions()) {
            return false;
        }
        for (int d = 0; d < n; ++d) {
            if (!(Math.abs(a.getDoublePosition(d) - b.getDoublePosition(d)) > tolerance)) continue;
            return false;
        }
        return true;
    }

    public static String toString(Localizable value) {
        StringBuilder sb = new StringBuilder();
        int c = 40;
        for (int i = 0; i < value.numDimensions(); ++i) {
            sb.append((char)c);
            sb.append(value.getLongPosition(i));
            c = 44;
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(RealLocalizable value) {
        StringBuilder sb = new StringBuilder();
        int c = 40;
        for (int i = 0; i < value.numDimensions(); ++i) {
            sb.append((char)c);
            sb.append(value.getDoublePosition(i));
            c = 44;
        }
        sb.append(")");
        return sb.toString();
    }

    private static class RealLocationRealRandomAccess
    extends RealPoint
    implements RealRandomAccess<RealLocalizable> {
        public RealLocationRealRandomAccess(int n) {
            super(n);
        }

        public RealLocationRealRandomAccess(RealLocalizable initialPosition) {
            super(initialPosition);
        }

        @Override
        public RealLocationRealRandomAccess get() {
            return this;
        }

        @Override
        public RealLocationRealRandomAccess copy() {
            return new RealLocationRealRandomAccess(this);
        }
    }

    private static class RealLocationRealRandomAccessible
    extends AbstractEuclideanSpace
    implements RealRandomAccessible<RealLocalizable> {
        public RealLocationRealRandomAccessible(int n) {
            super(n);
        }

        public RealLocationRealRandomAccess realRandomAccess() {
            return new RealLocationRealRandomAccess(this.n);
        }

        public RealLocationRealRandomAccess realRandomAccess(RealInterval interval) {
            return this.realRandomAccess();
        }
    }

    private static class LocationRandomAccess
    extends Point
    implements RandomAccess<Localizable> {
        public LocationRandomAccess(int n) {
            super(n);
        }

        public LocationRandomAccess(Localizable initialPosition) {
            super(initialPosition);
        }

        @Override
        public Localizable get() {
            return this;
        }

        @Override
        public RandomAccess<Localizable> copy() {
            return new LocationRandomAccess(this);
        }
    }

    private static class LocationRandomAccessible
    extends AbstractEuclideanSpace
    implements RandomAccessible<Localizable> {
        public LocationRandomAccessible(int n) {
            super(n);
        }

        @Override
        public RandomAccess<Localizable> randomAccess() {
            return new LocationRandomAccess(this.n);
        }

        @Override
        public RandomAccess<Localizable> randomAccess(Interval interval) {
            return this.randomAccess();
        }
    }
}

