/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.util;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.RandomAccessibleIntervalCursor;

public class Grid {
    private final int n;
    private final long[] dimensions;
    private final long[] cellDimensions;
    private final long[] minBorderSize;
    private final long[] numCells;
    private final long[] maxBorderSize;
    private final int hashcode;
    private final CellIntervals cellIntervals;

    public Grid(long[] dimensions, long[] cellDimensions) {
        this(dimensions, cellDimensions, new long[dimensions.length]);
    }

    public Grid(long[] dimensions, long[] cellDimensions, long[] offset) {
        this.n = dimensions.length;
        this.dimensions = (long[])dimensions.clone();
        this.cellDimensions = (long[])cellDimensions.clone();
        this.numCells = new long[this.n];
        this.minBorderSize = new long[this.n];
        this.maxBorderSize = new long[this.n];
        for (int d = 0; d < this.n; ++d) {
            long cd = cellDimensions[d];
            long po = (offset[d] % cd + cd) % cd;
            this.minBorderSize[d] = Math.min(po == 0L ? cellDimensions[d] : po, dimensions[d]);
            long d0 = dimensions[d] - this.minBorderSize[d];
            this.numCells[d] = d0 == 0L ? 1L : (d0 - 1L) / cd + 2L;
            this.maxBorderSize[d] = (int)(d0 - (this.numCells[d] - 2L) * cd);
        }
        int hash = Arrays.hashCode(dimensions);
        hash = hash * 31 + Arrays.hashCode(cellDimensions);
        this.hashcode = hash = hash * 31 + Arrays.hashCode(this.minBorderSize);
        this.cellIntervals = new CellIntervals();
    }

    public Grid(Grid grid) {
        this.n = grid.n;
        this.dimensions = (long[])grid.dimensions.clone();
        this.cellDimensions = (long[])grid.cellDimensions.clone();
        this.numCells = (long[])grid.numCells.clone();
        this.minBorderSize = (long[])grid.minBorderSize.clone();
        this.maxBorderSize = (long[])grid.maxBorderSize.clone();
        this.hashcode = grid.hashcode;
        this.cellIntervals = new CellIntervals();
    }

    public int numDimensions() {
        return this.n;
    }

    public long[] getGridDimensions() {
        return (long[])this.numCells.clone();
    }

    public void gridDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.numCells[i];
        }
    }

    public long gridDimension(int d) {
        return this.numCells[d];
    }

    public long[] getImgDimensions() {
        return (long[])this.dimensions.clone();
    }

    public void imgDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.dimensions[i];
        }
    }

    public long imgDimension(int d) {
        return this.dimensions[d];
    }

    public long[] getCellDimensions() {
        return (long[])this.cellDimensions.clone();
    }

    public void cellDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.cellDimensions[i];
        }
    }

    public long cellDimension(int d) {
        return this.cellDimensions[d];
    }

    public void getCellDimensions(long index, long[] cellMin, long[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            long j = index / this.numCells[d];
            long gridPos = index - j * this.numCells[d];
            index = j;
            if (gridPos == 0L) {
                cellDims[d] = this.minBorderSize[d];
                cellMin[d] = 0L;
                continue;
            }
            if (gridPos == this.numCells[d] - 1L) {
                cellDims[d] = this.maxBorderSize[d];
                cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
                continue;
            }
            cellDims[d] = this.cellDimensions[d];
            cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
        }
    }

    public void getCellDimensions(long[] cellGridPosition, long[] cellMin, long[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            long gridPos = cellGridPosition[d];
            if (gridPos == 0L) {
                cellDims[d] = this.minBorderSize[d];
                cellMin[d] = 0L;
                continue;
            }
            if (gridPos == this.numCells[d] - 1L) {
                cellDims[d] = this.maxBorderSize[d];
                cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
                continue;
            }
            cellDims[d] = this.cellDimensions[d];
            cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
        }
    }

    public void getCellInterval(long[] cellGridPosition, long[] cellMin, long[] cellMax) {
        for (int d = 0; d < this.n; ++d) {
            long gridPos = cellGridPosition[d];
            if (gridPos == 0L) {
                cellMin[d] = 0L;
                cellMax[d] = this.minBorderSize[d] - 1L;
                continue;
            }
            if (gridPos == this.numCells[d] - 1L) {
                cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
                cellMax[d] = cellMin[d] + this.maxBorderSize[d] - 1L;
                continue;
            }
            cellMin[d] = this.minBorderSize[d] + (gridPos - 1L) * this.cellDimensions[d];
            cellMax[d] = cellMin[d] + this.cellDimensions[d] - 1L;
        }
    }

    public long getCellDimension(int d, long cellGridPosition) {
        if (cellGridPosition == 0L) {
            return this.minBorderSize[d];
        }
        if (cellGridPosition == this.numCells[d] - 1L) {
            return this.maxBorderSize[d];
        }
        return this.cellDimensions[d];
    }

    public long getCellMin(int d, long cellGridPosition) {
        if (cellGridPosition == 0L) {
            return 0L;
        }
        return this.minBorderSize[d] + (cellGridPosition - 1L) * this.cellDimensions[d];
    }

    public void getCellGridPositionFlat(long index, long[] cellGridPosition) {
        IntervalIndexer.indexToPosition(index, this.numCells, cellGridPosition);
    }

    public void getCellPosition(long[] position, long[] cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos[d] = position[d] < this.minBorderSize[d] ? 0L : (position[d] - this.minBorderSize[d]) / this.cellDimensions[d];
        }
    }

    public void getCellPosition(long[] position, Positionable cellPos) {
        for (int d = 0; d < this.n; ++d) {
            if (position[d] < this.minBorderSize[d]) {
                cellPos.setPosition(0, d);
                continue;
            }
            cellPos.setPosition((position[d] - this.minBorderSize[d]) / this.cellDimensions[d], d);
        }
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Grid) {
            Grid other = (Grid)obj;
            return Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.cellDimensions, other.cellDimensions) && Arrays.equals(this.minBorderSize, other.minBorderSize);
        }
        return false;
    }

    public String toString() {
        long[] offset = new long[this.n];
        Arrays.setAll(offset, d -> this.cellDimensions[d] == this.minBorderSize[d] ? 0L : this.minBorderSize[d]);
        return this.getClass().getSimpleName() + "( dims = " + Util.printCoordinates(this.dimensions) + ", cellDims = " + Util.printCoordinates(this.cellDimensions) + ", offset = " + Util.printCoordinates(offset) + " )";
    }

    public CellIntervals cellIntervals() {
        return this.cellIntervals;
    }

    public class CellIntervals
    implements RandomAccessibleInterval<Interval>,
    IterableInterval<Interval> {
        private final long size;

        public CellIntervals() {
            this.size = Intervals.numElements(Grid.this.numCells);
        }

        @Override
        public int numDimensions() {
            return Grid.this.n;
        }

        @Override
        public long min(int d) {
            return 0L;
        }

        @Override
        public long max(int d) {
            return Grid.this.numCells[d] - 1L;
        }

        @Override
        public RandomAccess<Interval> randomAccess() {
            return new CellIntervalsRA();
        }

        @Override
        public RandomAccess<Interval> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public Cursor<Interval> cursor() {
            return new RandomAccessibleIntervalCursor<Interval>(this);
        }

        @Override
        public Cursor<Interval> localizingCursor() {
            return this.cursor();
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public FlatIterationOrder iterationOrder() {
            return new FlatIterationOrder(this);
        }
    }

    private class CellIntervalsRA
    extends Point
    implements RandomAccess<Interval> {
        private final long[] min;
        private final long[] max;
        private final Interval interval;

        @Override
        public Interval get() {
            Grid.this.getCellInterval(this.position, this.min, this.max);
            return this.interval;
        }

        CellIntervalsRA() {
            super(Grid.this.n);
            this.min = new long[Grid.this.n];
            this.max = new long[Grid.this.n];
            this.interval = FinalInterval.wrap(this.min, this.max);
        }

        CellIntervalsRA(CellIntervalsRA ra) {
            super(ra);
            this.min = new long[Grid.this.n];
            this.max = new long[Grid.this.n];
            this.interval = FinalInterval.wrap(this.min, this.max);
        }

        @Override
        public RandomAccess<Interval> copy() {
            return new CellIntervalsRA(this);
        }
    }
}

