/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.real;

import net.imglib2.img.NativeImg;
import net.imglib2.img.array.ArrayImgs;
import net.imglib2.img.basictypeaccess.FloatAccess;
import net.imglib2.img.basictypeaccess.array.FloatArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;
import net.imglib2.view.Views;
import net.imglib2.view.composite.RealComposite;

public class FloatType
extends AbstractRealType<FloatType>
implements NativeType<FloatType> {
    private final Index i = new Index();
    protected final NativeImg<?, ? extends FloatAccess> img;
    protected FloatAccess dataAccess;
    private static final NativeTypeFactory<FloatType, FloatAccess> typeFactory = NativeTypeFactory.FLOAT(FloatType::new);

    public FloatType(NativeImg<?, ? extends FloatAccess> floatStorage) {
        this.img = floatStorage;
    }

    public FloatType(float value) {
        this.img = null;
        this.dataAccess = new FloatArray(1);
        this.set(value);
    }

    public FloatType(FloatAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public FloatType() {
        this(0.0f);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public FloatType duplicateTypeOnSameNativeImg() {
        return new FloatType(this.img);
    }

    @Override
    public NativeTypeFactory<FloatType, FloatAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public float get() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Override
    public void set(float f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public float getRealFloat() {
        return this.get();
    }

    @Override
    public double getRealDouble() {
        return this.get();
    }

    @Override
    public void setReal(float real) {
        this.set(real);
    }

    @Override
    public void setReal(double real) {
        this.set((float)real);
    }

    @Override
    public double getMaxValue() {
        return 3.4028234663852886E38;
    }

    @Override
    public double getMinValue() {
        return -3.4028234663852886E38;
    }

    @Override
    public double getMinIncrement() {
        return 1.4E-45f;
    }

    @Override
    public void mul(float c) {
        this.set(this.get() * c);
    }

    @Override
    public void mul(double c) {
        this.set((float)((double)this.get() * c));
    }

    @Override
    public void add(FloatType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(FloatType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(FloatType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(FloatType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public void set(FloatType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(1.0f);
    }

    @Override
    public void setZero() {
        this.set(0.0f);
    }

    @Override
    public void inc() {
        float a = this.get();
        this.set(a += 1.0f);
    }

    @Override
    public void dec() {
        float a = this.get();
        this.set(a -= 1.0f);
    }

    @Override
    public FloatType createVariable() {
        return new FloatType(0.0f);
    }

    @Override
    public FloatType copy() {
        return new FloatType(this.get());
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public int getBitsPerPixel() {
        return 32;
    }

    @Override
    public int compareTo(FloatType other) {
        return Float.compare(this.get(), other.get());
    }

    @Override
    public boolean valueEquals(FloatType other) {
        return FloatType.equals(this.get(), other.get());
    }

    @Override
    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    @Override
    public int hashCode() {
        return Float.hashCode(this.get());
    }

    public static boolean equals(float a, float b) {
        return Float.floatToIntBits(a) == Float.floatToIntBits(b);
    }

    public static RealComposite<FloatType> createVector(int n) {
        return (RealComposite)Views.collapseReal(ArrayImgs.floats(n)).randomAccess().get();
    }

    public static RealComposite<FloatType> wrapVector(float[] array) {
        return (RealComposite)Views.collapseReal(ArrayImgs.floats(array, new long[]{array.length})).randomAccess().get();
    }
}

