/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericIntType;
import net.imglib2.util.Util;

public class UnsignedIntType
extends GenericIntType<UnsignedIntType> {
    private static final NativeTypeFactory<UnsignedIntType, IntAccess> typeFactory = NativeTypeFactory.INT(UnsignedIntType::new);

    public UnsignedIntType(NativeImg<?, ? extends IntAccess> img) {
        super(img);
    }

    public UnsignedIntType(long value) {
        super(UnsignedIntType.getCodedSignedInt(value));
    }

    public UnsignedIntType(IntAccess access) {
        super(access);
    }

    public UnsignedIntType() {
        this(0L);
    }

    public static int getCodedSignedIntChecked(long unsignedInt) {
        if (unsignedInt < 0L) {
            unsignedInt = 0L;
        } else if (unsignedInt > 0xFFFFFFFFL) {
            unsignedInt = 0xFFFFFFFFL;
        }
        return UnsignedIntType.getCodedSignedInt(unsignedInt);
    }

    public static int getCodedSignedInt(long unsignedInt) {
        return (int)(unsignedInt & 0xFFFFFFFFFFFFFFFFL);
    }

    public static long getUnsignedInt(int signedInt) {
        return (long)signedInt & 0xFFFFFFFFL;
    }

    @Override
    public UnsignedIntType duplicateTypeOnSameNativeImg() {
        return new UnsignedIntType(this.img);
    }

    @Override
    public NativeTypeFactory<UnsignedIntType, IntAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public void mul(float c) {
        long a = UnsignedIntType.getUnsignedInt(this.getInt());
        this.setInt(UnsignedIntType.getCodedSignedInt(Util.round((float)a * c)));
    }

    @Override
    public void mul(double c) {
        long a = UnsignedIntType.getUnsignedInt(this.getInt());
        this.setInt(UnsignedIntType.getCodedSignedInt((int)Util.round((double)a * c)));
    }

    @Override
    public void add(UnsignedIntType c) {
        this.set(this.get() + c.get());
    }

    @Override
    public void div(UnsignedIntType c) {
        this.set(this.get() / c.get());
    }

    @Override
    public void mul(UnsignedIntType c) {
        this.set(this.get() * c.get());
    }

    @Override
    public void sub(UnsignedIntType c) {
        this.set(this.get() - c.get());
    }

    @Override
    public void setOne() {
        this.set(1L);
    }

    @Override
    public void setZero() {
        this.set(0L);
    }

    @Override
    public void inc() {
        this.set(this.get() + 1L);
    }

    @Override
    public void dec() {
        this.set(this.get() - 1L);
    }

    @Override
    public String toString() {
        return "" + this.get();
    }

    public long get() {
        return UnsignedIntType.getUnsignedInt(this.getInt());
    }

    @Override
    public void set(long f) {
        this.setInt(UnsignedIntType.getCodedSignedInt(f));
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public void setReal(float real) {
        this.set(Util.roundToLong(real));
    }

    @Override
    public double getMaxValue() {
        return 4.294967295E9;
    }

    @Override
    public double getMinValue() {
        return 0.0;
    }

    @Override
    public UnsignedIntType createVariable() {
        return new UnsignedIntType(0L);
    }

    @Override
    public UnsignedIntType copy() {
        return new UnsignedIntType(this.get());
    }

    @Override
    public int compareTo(UnsignedIntType other) {
        return Long.compare(this.get(), other.get());
    }
}

