/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.img.basictypeaccess.array.LongArray;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.AbstractIntegerBitType;

public class Unsigned4BitType
extends AbstractIntegerBitType<Unsigned4BitType> {
    private static final long mask = 15L;
    private static final NativeTypeFactory<Unsigned4BitType, LongAccess> typeFactory = NativeTypeFactory.LONG(Unsigned4BitType::new);

    public Unsigned4BitType(NativeImg<?, ? extends LongAccess> bitStorage) {
        super(bitStorage, 4);
    }

    public Unsigned4BitType(long value) {
        this((NativeImg)null);
        this.dataAccess = new LongArray(1);
        this.set(value);
    }

    public Unsigned4BitType(LongAccess access) {
        this((NativeImg)null);
        this.dataAccess = access;
    }

    public Unsigned4BitType() {
        this(0L);
    }

    @Override
    public Unsigned4BitType duplicateTypeOnSameNativeImg() {
        return new Unsigned4BitType(this.img);
    }

    @Override
    public NativeTypeFactory<Unsigned4BitType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public long get() {
        long j = this.index().get();
        return this.dataAccess.getValue((int)(j >>> 4)) >>> (int)((j & 0xFL) << 2) & 0xFL;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void set(long value) {
        long j = this.index().get();
        int i1 = (int)(j >>> 4);
        long shift = j << 2 & 0x3FL;
        long bitsToRetain = 15L << (int)shift ^ 0xFFFFFFFFFFFFFFFFL;
        long bitsToSet = (value & 0xFL) << (int)shift;
        LongAccess longAccess = this.dataAccess;
        synchronized (longAccess) {
            this.dataAccess.setValue(i1, this.dataAccess.getValue(i1) & bitsToRetain | bitsToSet);
        }
    }

    @Override
    public Unsigned4BitType createVariable() {
        return new Unsigned4BitType(0L);
    }

    @Override
    public Unsigned4BitType copy() {
        return new Unsigned4BitType(this.get());
    }
}

