/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.integer;

import java.math.BigInteger;
import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.LongAccess;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.integer.GenericLongType;
import net.imglib2.util.Util;

public class LongType
extends GenericLongType<LongType> {
    private static final NativeTypeFactory<LongType, LongAccess> typeFactory = NativeTypeFactory.LONG(LongType::new);

    public LongType(NativeImg<?, ? extends LongAccess> longStorage) {
        super(longStorage);
    }

    public LongType(LongAccess access) {
        super(access);
    }

    public LongType(long value) {
        super(value);
    }

    public LongType() {
        super(0L);
    }

    @Override
    public LongType duplicateTypeOnSameNativeImg() {
        return new LongType(this.img);
    }

    @Override
    public NativeTypeFactory<LongType, LongAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public long get() {
        return this.getLong();
    }

    @Override
    public void set(long f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public int getInteger() {
        return (int)this.get();
    }

    @Override
    public long getIntegerLong() {
        return this.get();
    }

    @Override
    public BigInteger getBigInteger() {
        return BigInteger.valueOf(this.get());
    }

    @Override
    public void setInteger(int f) {
        this.set(f);
    }

    @Override
    public void setInteger(long f) {
        this.set(f);
    }

    @Override
    public void setBigInteger(BigInteger b) {
        this.set(b.longValue());
    }

    @Override
    public void setReal(float real) {
        this.set(Util.roundToLong(real));
    }

    @Override
    public double getMaxValue() {
        return 9.223372036854776E18;
    }

    @Override
    public double getMinValue() {
        return -9.223372036854776E18;
    }

    @Override
    public LongType createVariable() {
        return new LongType(0L);
    }

    @Override
    public LongType copy() {
        return new LongType(this.get());
    }
}

