/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric.complex;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.complex.AbstractComplexType;
import net.imglib2.util.Fraction;

public class ComplexDoubleType
extends AbstractComplexType<ComplexDoubleType>
implements NativeType<ComplexDoubleType> {
    private final Index i = new Index();
    private int realI = 0;
    private int imaginaryI = 1;
    protected final NativeImg<?, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;
    private static final NativeTypeFactory<ComplexDoubleType, DoubleAccess> typeFactory = NativeTypeFactory.DOUBLE(ComplexDoubleType::new);

    public ComplexDoubleType(NativeImg<?, ? extends DoubleAccess> complexfloatStorage) {
        this.img = complexfloatStorage;
    }

    public ComplexDoubleType(double r, double i) {
        this.img = null;
        this.dataAccess = new DoubleArray(2);
        this.set(r, i);
    }

    public ComplexDoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public ComplexDoubleType() {
        this(0.0, 0.0);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public ComplexDoubleType duplicateTypeOnSameNativeImg() {
        return new ComplexDoubleType(this.img);
    }

    @Override
    public NativeTypeFactory<ComplexDoubleType, DoubleAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public float getRealFloat() {
        return (float)this.dataAccess.getValue(this.i.get() << 1);
    }

    @Override
    public double getRealDouble() {
        return this.dataAccess.getValue(this.i.get() << 1);
    }

    @Override
    public float getImaginaryFloat() {
        return (float)this.dataAccess.getValue((this.i.get() << 1) + 1);
    }

    @Override
    public double getImaginaryDouble() {
        return this.dataAccess.getValue((this.i.get() << 1) + 1);
    }

    @Override
    public void setReal(float r) {
        this.dataAccess.setValue(this.i.get() << 1, r);
    }

    @Override
    public void setReal(double r) {
        this.dataAccess.setValue(this.i.get() << 1, r);
    }

    @Override
    public void setImaginary(float i) {
        this.dataAccess.setValue((this.i.get() << 1) + 1, i);
    }

    @Override
    public void setImaginary(double i) {
        this.dataAccess.setValue((this.i.get() << 1) + 1, i);
    }

    public void set(double r, double i) {
        int j = this.i.get() << 1;
        this.dataAccess.setValue(j, r);
        this.dataAccess.setValue(j + 1, i);
    }

    @Override
    public void set(ComplexDoubleType c) {
        this.setReal(c.getRealDouble());
        this.setImaginary(c.getImaginaryDouble());
    }

    @Override
    public ComplexDoubleType createVariable() {
        return new ComplexDoubleType(0.0, 0.0);
    }

    @Override
    public ComplexDoubleType copy() {
        return new ComplexDoubleType(this.getRealFloat(), this.getImaginaryFloat());
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(2L, 1L);
    }
}

