/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.DoubleAccess;
import net.imglib2.img.basictypeaccess.array.DoubleArray;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.ARGBDoubleType;
import net.imglib2.type.numeric.AbstractARGBDoubleType;
import net.imglib2.util.Fraction;

public class NativeARGBDoubleType
extends AbstractARGBDoubleType<NativeARGBDoubleType>
implements NativeType<NativeARGBDoubleType> {
    private final Index i = new Index();
    protected final NativeImg<?, ? extends DoubleAccess> img;
    protected DoubleAccess dataAccess;
    private static final NativeTypeFactory<NativeARGBDoubleType, DoubleAccess> typeFactory = NativeTypeFactory.DOUBLE(NativeARGBDoubleType::new);

    public NativeARGBDoubleType(NativeImg<?, ? extends DoubleAccess> img) {
        this.img = img;
    }

    public NativeARGBDoubleType(double a, double r, double g, double b) {
        this.img = null;
        this.dataAccess = new DoubleArray(4);
        this.set(a, r, g, b);
    }

    public NativeARGBDoubleType(DoubleAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public NativeARGBDoubleType() {
        this(0.0, 0.0, 0.0, 0.0);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public Index index() {
        return this.i;
    }

    @Override
    public NativeARGBDoubleType duplicateTypeOnSameNativeImg() {
        return new NativeARGBDoubleType(this.img);
    }

    @Override
    public NativeTypeFactory<NativeARGBDoubleType, DoubleAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    @Override
    public double getA() {
        int ai = this.i.get() << 2;
        return this.dataAccess.getValue(ai);
    }

    @Override
    public double getR() {
        int ai = this.i.get() << 2;
        return this.dataAccess.getValue(ai + 1);
    }

    @Override
    public double getG() {
        int ai = this.i.get() << 2;
        return this.dataAccess.getValue(ai + 2);
    }

    @Override
    public double getB() {
        int ai = this.i.get() << 2;
        return this.dataAccess.getValue(ai + 3);
    }

    @Override
    public void setA(double a) {
        int ai = this.i.get() << 2;
        this.dataAccess.setValue(ai, a);
    }

    @Override
    public void setR(double r) {
        int ai = this.i.get() << 2;
        this.dataAccess.setValue(ai + 1, r);
    }

    @Override
    public void setG(double g) {
        int ai = this.i.get() << 2;
        this.dataAccess.setValue(ai + 2, g);
    }

    @Override
    public void setB(double b) {
        int ai = this.i.get() << 2;
        this.dataAccess.setValue(ai + 3, b);
    }

    @Override
    public void set(double a, double r, double g, double b) {
        int ai = this.i.get() << 2;
        this.dataAccess.setValue(ai, a);
        this.dataAccess.setValue(ai + 1, r);
        this.dataAccess.setValue(ai + 2, g);
        this.dataAccess.setValue(ai + 3, b);
    }

    @Override
    public void set(ARGBDoubleType c) {
        this.set(c.getA(), c.getR(), c.getG(), c.getB());
    }

    @Override
    public NativeARGBDoubleType createVariable() {
        return new NativeARGBDoubleType();
    }

    @Override
    public NativeARGBDoubleType copy() {
        return new NativeARGBDoubleType(this.getA(), this.getR(), this.getG(), this.getB());
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction(4L, 1L);
    }
}

