/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.numeric;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.IntAccess;
import net.imglib2.img.basictypeaccess.array.IntArray;
import net.imglib2.type.AbstractNativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.util.Fraction;
import net.imglib2.util.Util;

public class ARGBType
extends AbstractNativeType<ARGBType>
implements NumericType<ARGBType> {
    protected final NativeImg<?, ? extends IntAccess> img;
    protected IntAccess dataAccess;
    private static final NativeTypeFactory<ARGBType, IntAccess> typeFactory = NativeTypeFactory.INT(ARGBType::new);

    public ARGBType(NativeImg<?, ? extends IntAccess> intStorage) {
        this.img = intStorage;
    }

    public ARGBType(int value) {
        this.img = null;
        this.dataAccess = new IntArray(1);
        this.set(value);
    }

    public ARGBType(IntAccess access) {
        this.img = null;
        this.dataAccess = access;
    }

    public ARGBType() {
        this(0);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public ARGBType duplicateTypeOnSameNativeImg() {
        return new ARGBType(this.img);
    }

    @Override
    public NativeTypeFactory<ARGBType, IntAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public static final int rgba(int r, int g, int b, int a) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF | (a & 0xFF) << 24;
    }

    public static final int rgba(float r, float g, float b, float a) {
        return ARGBType.rgba(Util.round(r), Util.round(g), Util.round(b), Util.round(a));
    }

    public static final int rgba(double r, double g, double b, double a) {
        return ARGBType.rgba((int)Util.round(r), (int)Util.round(g), (int)Util.round(b), (int)Util.round(a));
    }

    public static final int red(int value) {
        return value >> 16 & 0xFF;
    }

    public static final int green(int value) {
        return value >> 8 & 0xFF;
    }

    public static final int blue(int value) {
        return value & 0xFF;
    }

    public static final int alpha(int value) {
        return value >> 24 & 0xFF;
    }

    public int get() {
        return this.dataAccess.getValue(this.i.get());
    }

    @Override
    public void set(int f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void mul(float c) {
        int value = this.get();
        this.set(ARGBType.rgba((float)ARGBType.red(value) * c, (float)ARGBType.green(value) * c, (float)ARGBType.blue(value) * c, (float)ARGBType.alpha(value) * c));
    }

    @Override
    public void mul(double c) {
        int value = this.get();
        this.set(ARGBType.rgba((double)ARGBType.red(value) * c, (double)ARGBType.green(value) * c, (double)ARGBType.blue(value) * c, (double)ARGBType.alpha(value) * c));
    }

    @Override
    public void add(ARGBType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(ARGBType.rgba(ARGBType.red(value1) + ARGBType.red(value2), ARGBType.green(value1) + ARGBType.green(value2), ARGBType.blue(value1) + ARGBType.blue(value2), ARGBType.alpha(value1) + ARGBType.alpha(value2)));
    }

    @Override
    public void div(ARGBType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(ARGBType.rgba(ARGBType.red(value1) / ARGBType.red(value2), ARGBType.green(value1) / ARGBType.green(value2), ARGBType.blue(value1) / ARGBType.blue(value2), ARGBType.alpha(value1) / ARGBType.alpha(value2)));
    }

    @Override
    public void mul(ARGBType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(ARGBType.rgba(ARGBType.red(value1) * ARGBType.red(value2), ARGBType.green(value1) * ARGBType.green(value2), ARGBType.blue(value1) * ARGBType.blue(value2), ARGBType.alpha(value1) * ARGBType.alpha(value2)));
    }

    @Override
    public void sub(ARGBType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(ARGBType.rgba(ARGBType.red(value1) - ARGBType.red(value2), ARGBType.green(value1) - ARGBType.green(value2), ARGBType.blue(value1) - ARGBType.blue(value2), ARGBType.alpha(value1) - ARGBType.alpha(value2)));
    }

    @Override
    public void pow(ARGBType c) {
        int value1 = this.get();
        int value2 = c.get();
        this.set(ARGBType.rgba(Math.pow(ARGBType.red(value1), ARGBType.red(value2)), Math.pow(ARGBType.green(value1), ARGBType.green(value2)), Math.pow(ARGBType.blue(value1), ARGBType.blue(value2)), Math.pow(ARGBType.alpha(value1), ARGBType.alpha(value2))));
    }

    @Override
    public void pow(double power) {
        int value1 = this.get();
        this.set(ARGBType.rgba(Math.pow(ARGBType.red(value1), power), Math.pow(ARGBType.green(value1), power), Math.pow(ARGBType.blue(value1), power), Math.pow(ARGBType.alpha(value1), power)));
    }

    @Override
    public void set(ARGBType c) {
        this.set(c.get());
    }

    @Override
    public void setOne() {
        this.set(ARGBType.rgba(1, 1, 1, 1));
    }

    @Override
    public void setZero() {
        this.set(0);
    }

    @Override
    public ARGBType createVariable() {
        return new ARGBType(0);
    }

    @Override
    public ARGBType copy() {
        return new ARGBType(this.get());
    }

    public String toString() {
        int rgba = this.get();
        return "(r=" + ARGBType.red(rgba) + ",g=" + ARGBType.green(rgba) + ",b=" + ARGBType.blue(rgba) + ",a=" + ARGBType.alpha(rgba) + ")";
    }

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    @Override
    public boolean valueEquals(ARGBType t) {
        return this.get() == t.get();
    }

    public boolean equals(Object obj) {
        return Util.valueEqualsObject(this, obj);
    }

    public int hashCode() {
        return Integer.hashCode(this.get());
    }
}

