/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.type.label;

import net.imglib2.img.NativeImg;
import net.imglib2.img.basictypeaccess.CharAccess;
import net.imglib2.img.basictypeaccess.array.CharArray;
import net.imglib2.type.AbstractNativeType;
import net.imglib2.type.BasePairType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.type.label.BasePairBitType;
import net.imglib2.util.Fraction;

public class BasePairCharType
extends AbstractNativeType<BasePairCharType>
implements BasePairType<BasePairCharType> {
    protected final NativeImg<?, ? extends CharAccess> img;
    protected CharAccess dataAccess;
    private static final NativeTypeFactory<BasePairCharType, CharAccess> typeFactory = NativeTypeFactory.CHAR(BasePairCharType::new);

    @Override
    public Fraction getEntitiesPerPixel() {
        return new Fraction();
    }

    public BasePairCharType(NativeImg<?, ? extends CharAccess> charStorage) {
        this.img = charStorage;
    }

    public BasePairCharType(BasePairBitType.Base value) {
        this.img = null;
        this.dataAccess = new CharArray(1);
        this.set(value);
    }

    public BasePairCharType(char value) {
        this.img = null;
        this.dataAccess = new CharArray(1);
        this.setChar(value);
    }

    public BasePairCharType() {
        this(BasePairBitType.Base.N);
    }

    @Override
    public void updateContainer(Object c) {
        this.dataAccess = this.img.update(c);
    }

    @Override
    public BasePairCharType duplicateTypeOnSameNativeImg() {
        return new BasePairCharType(this.img);
    }

    @Override
    public NativeTypeFactory<BasePairCharType, CharAccess> getNativeTypeFactory() {
        return typeFactory;
    }

    public char getChar() {
        return this.dataAccess.getValue(this.i.get());
    }

    public void setChar(char f) {
        this.dataAccess.setValue(this.i.get(), f);
    }

    @Override
    public void set(BasePairBitType.Base base) {
        this.setChar(base.getChar());
    }

    @Override
    public BasePairBitType.Base get() {
        return BasePairBitType.Base.fromChar(this.getChar());
    }

    @Override
    public void set(BasePairCharType c) {
        this.dataAccess.setValue(this.i.get(), c.getChar());
    }

    @Override
    public int compareTo(BasePairCharType c) {
        return this.get().compareTo(c.get());
    }

    @Override
    public void complement() {
        char base = this.getChar();
        switch (base) {
            case 'A': {
                this.setChar('T');
                break;
            }
            case 'T': {
                this.setChar('A');
                break;
            }
            case 'G': {
                this.setChar('C');
                break;
            }
            case 'C': {
                this.setChar('G');
                break;
            }
            case 'U': {
                this.setChar('A');
            }
        }
    }

    @Override
    public byte baseToValue() {
        return (byte)this.get().ordinal();
    }

    @Override
    public BasePairCharType createVariable() {
        return new BasePairCharType(BasePairBitType.Base.N);
    }

    @Override
    public BasePairCharType copy() {
        return new BasePairCharType(this.get());
    }

    public String toString() {
        return "" + (Object)((Object)this.get());
    }

    @Override
    public boolean valueEquals(BasePairCharType t) {
        return this.get() == t.get();
    }
}

