/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.stream;

import java.util.function.Consumer;
import net.imglib2.RealCursor;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.stream.RealLocalizableSpliterator;

public class RealCursorSpliterator<T>
implements RealLocalizableSpliterator<T> {
    private final RealCursor<T> cursor;
    private long index;
    private final long fence;
    private final int characteristics;

    public RealCursorSpliterator(RealCursor<T> cursor, long origin, long fence, int additionalCharacteristics) {
        this.cursor = cursor;
        this.index = origin;
        this.fence = fence;
        this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0L && this.index < this.fence) {
            ++this.index;
            action.accept(this.cursor.next());
            return true;
        }
        return false;
    }

    @Override
    public RealCursorSpliterator<T> trySplit() {
        long lo = this.index;
        long mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            return null;
        }
        RealCursorSpliterator<T> prefix = new RealCursorSpliterator<T>(this.cursor.copy(), lo, mid, this.characteristics);
        this.cursor.jumpFwd(mid - lo);
        this.index = mid;
        return prefix;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public T get() {
        return this.cursor.get();
    }

    @Override
    public RealCursorSpliterator<T> copy() {
        return new RealCursorSpliterator<T>(this.cursor.copy(), this.index, this.fence, this.characteristics);
    }

    @Override
    public int numDimensions() {
        return this.cursor.numDimensions();
    }

    @Override
    public void localize(float[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(RealPositionable position) {
        this.cursor.localize(position);
    }

    @Override
    public double[] positionAsDoubleArray() {
        return this.cursor.positionAsDoubleArray();
    }

    @Override
    public RealPoint positionAsRealPoint() {
        return this.cursor.positionAsRealPoint();
    }

    @Override
    public float getFloatPosition(int d) {
        return this.cursor.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.cursor.getDoublePosition(d);
    }
}

