/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.stream;

import java.util.function.Consumer;
import net.imglib2.Cursor;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RealPoint;
import net.imglib2.RealPositionable;
import net.imglib2.stream.LocalizableSpliterator;

public class CursorSpliterator<T>
implements LocalizableSpliterator<T> {
    private final Cursor<T> cursor;
    private long index;
    private final long fence;
    private final int characteristics;

    public CursorSpliterator(Cursor<T> cursor, long origin, long fence, int additionalCharacteristics) {
        this.cursor = cursor;
        this.index = origin;
        this.fence = fence;
        this.characteristics = additionalCharacteristics | 0x40 | 0x4000;
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index >= 0L && this.index < this.fence) {
            ++this.index;
            action.accept(this.cursor.next());
            return true;
        }
        return false;
    }

    @Override
    public CursorSpliterator<T> trySplit() {
        long lo = this.index;
        long mid = lo + this.fence >>> 1;
        if (lo >= mid) {
            return null;
        }
        CursorSpliterator<T> prefix = new CursorSpliterator<T>(this.cursor.copy(), lo, mid, this.characteristics);
        this.cursor.jumpFwd(mid - lo);
        this.index = mid;
        return prefix;
    }

    @Override
    public long estimateSize() {
        return this.fence - this.index;
    }

    @Override
    public int characteristics() {
        return this.characteristics;
    }

    @Override
    public T get() {
        return this.cursor.get();
    }

    @Override
    public CursorSpliterator<T> copy() {
        return new CursorSpliterator<T>(this.cursor.copy(), this.index, this.fence, this.characteristics);
    }

    @Override
    public int numDimensions() {
        return this.cursor.numDimensions();
    }

    @Override
    public void localize(float[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(double[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(RealPositionable position) {
        this.cursor.localize(position);
    }

    @Override
    public double[] positionAsDoubleArray() {
        return this.cursor.positionAsDoubleArray();
    }

    @Override
    public RealPoint positionAsRealPoint() {
        return this.cursor.positionAsRealPoint();
    }

    @Override
    public float getFloatPosition(int d) {
        return this.cursor.getFloatPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.cursor.getDoublePosition(d);
    }

    @Override
    public void localize(int[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(long[] position) {
        this.cursor.localize(position);
    }

    @Override
    public void localize(Positionable position) {
        this.cursor.localize(position);
    }

    @Override
    public int getIntPosition(int d) {
        return this.cursor.getIntPosition(d);
    }

    @Override
    public long[] positionAsLongArray() {
        return this.cursor.positionAsLongArray();
    }

    @Override
    public Point positionAsPoint() {
        return this.cursor.positionAsPoint();
    }

    @Override
    public long getLongPosition(int d) {
        return this.cursor.getLongPosition(d);
    }
}

