/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.position.transform.Floor;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.NumericType;

public class NLinearInterpolator<T extends NumericType<T>>
extends Floor<RandomAccess<T>>
implements RealRandomAccess<T> {
    protected int code;
    protected final double[] weights;
    protected final T accumulator;
    protected final T tmp;

    protected NLinearInterpolator(NLinearInterpolator<T> interpolator) {
        super(((RandomAccess)interpolator.target).copy());
        this.weights = (double[])interpolator.weights.clone();
        this.code = interpolator.code;
        this.accumulator = (NumericType)interpolator.accumulator.createVariable();
        this.tmp = (NumericType)interpolator.tmp.createVariable();
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = interpolator.position[d];
            this.discrete[d] = interpolator.discrete[d];
        }
    }

    protected NLinearInterpolator(RandomAccessible<T> randomAccessible, T type) {
        super(randomAccessible.randomAccess());
        this.weights = new double[1 << this.n];
        this.code = 0;
        this.accumulator = (NumericType)type.createVariable();
        this.tmp = (NumericType)type.createVariable();
    }

    protected NLinearInterpolator(RandomAccessible<T> randomAccessible) {
        this(randomAccessible, (NumericType)randomAccessible.randomAccess().get());
    }

    protected void fillWeights() {
        this.weights[0] = 1.0;
        for (int d = this.n - 1; d >= 0; --d) {
            double w = this.position[d] - (double)((RandomAccess)this.target).getLongPosition(d);
            double wInv = 1.0 - w;
            int wInvIndexIncrement = 1 << d;
            int loopCount = 1 << this.n - 1 - d;
            int baseIndexIncrement = wInvIndexIncrement * 2;
            int baseIndex = 0;
            for (int i = 0; i < loopCount; ++i) {
                this.weights[baseIndex + wInvIndexIncrement] = this.weights[baseIndex] * w;
                int n = baseIndex;
                this.weights[n] = this.weights[n] * wInv;
                baseIndex += baseIndexIncrement;
            }
        }
    }

    @Override
    public T get() {
        this.fillWeights();
        this.accumulator.set((Type)((Type)((RandomAccess)this.target).get()));
        this.accumulator.mul(this.weights[0]);
        this.code = 0;
        this.graycodeFwdRecursive(this.n - 1);
        ((RandomAccess)this.target).bck(this.n - 1);
        return this.accumulator;
    }

    @Override
    public NLinearInterpolator<T> copy() {
        return new NLinearInterpolator<T>(this);
    }

    private final void graycodeFwdRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).fwd(0);
            ++this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).fwd(dimension);
            this.code += 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void graycodeBckRecursive(int dimension) {
        if (dimension == 0) {
            ((RandomAccess)this.target).bck(0);
            --this.code;
            this.accumulate();
        } else {
            this.graycodeFwdRecursive(dimension - 1);
            ((RandomAccess)this.target).bck(dimension);
            this.code -= 1 << dimension;
            this.accumulate();
            this.graycodeBckRecursive(dimension - 1);
        }
    }

    private final void accumulate() {
        this.tmp.set((Type)((Type)((RandomAccess)this.target).get()));
        this.tmp.mul(this.weights[this.code]);
        this.accumulator.add(this.tmp);
    }

    private final void printWeights() {
        for (int i = 0; i < this.weights.length; ++i) {
            System.out.printf("weights [ %2d ] = %f\n", i, this.weights[i]);
        }
    }

    private final void printCode() {
        int maxbits = 4;
        String binary = Integer.toBinaryString(this.code);
        for (int i = binary.length(); i < 4; ++i) {
            System.out.print("0");
        }
        System.out.print(binary);
    }
}

