/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation.randomaccess;

import net.imglib2.RandomAccessible;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.Volatile;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorRealType;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorVolatileARGB;
import net.imglib2.interpolation.randomaccess.ClampingNLinearInterpolatorVolatileRealType;
import net.imglib2.interpolation.randomaccess.NLinearInterpolator;
import net.imglib2.interpolation.randomaccess.NLinearInterpolatorARGB;
import net.imglib2.type.numeric.ARGBType;
import net.imglib2.type.numeric.NumericType;
import net.imglib2.type.numeric.RealType;
import net.imglib2.type.volatiles.VolatileARGBType;

public class ClampingNLinearInterpolatorFactory<T extends NumericType<T>>
implements InterpolatorFactory<T, RandomAccessible<T>> {
    @Override
    public RealRandomAccess<T> create(RandomAccessible<T> randomAccessible) {
        NumericType type = (NumericType)randomAccessible.randomAccess().get();
        if (type instanceof RealType) {
            if (type instanceof Volatile) {
                return new ClampingNLinearInterpolatorVolatileRealType(randomAccessible);
            }
            return new ClampingNLinearInterpolatorRealType<T>(randomAccessible);
        }
        if (ARGBType.class.isInstance(type)) {
            return new NLinearInterpolatorARGB(randomAccessible);
        }
        if (VolatileARGBType.class.isInstance(type)) {
            return new ClampingNLinearInterpolatorVolatileARGB<ARGBType>(randomAccessible);
        }
        return new NLinearInterpolator<ARGBType>(randomAccessible);
    }

    @Override
    public RealRandomAccess<T> create(RandomAccessible<T> randomAccessible, RealInterval interval) {
        return this.create(randomAccessible);
    }
}

