/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.interpolation;

import net.imglib2.EuclideanSpace;
import net.imglib2.RealInterval;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.View;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.util.Cast;

public final class Interpolant<T, F>
implements RealRandomAccessible<T>,
View {
    protected final F source;
    protected final int n;
    final InterpolatorFactory<T, F> factory;

    @Deprecated
    public Interpolant(EuclideanSpace source, InterpolatorFactory<T, F> factory) {
        this.source = Cast.unchecked(source);
        this.factory = factory;
        this.n = source.numDimensions();
    }

    public Interpolant(F source, InterpolatorFactory<T, F> factory, int n) {
        this.source = source;
        this.factory = factory;
        this.n = n;
    }

    @Override
    public int numDimensions() {
        return this.n;
    }

    @Override
    public RealRandomAccess<T> realRandomAccess() {
        return this.factory.create(this.source);
    }

    @Override
    public RealRandomAccess<T> realRandomAccess(RealInterval interval) {
        return this.factory.create(this.source, interval);
    }

    public F getSource() {
        return this.source;
    }

    public InterpolatorFactory<T, F> getInterpolatorFactory() {
        return this.factory;
    }
}

