/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.AbstractCursorInt;
import net.imglib2.Interval;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

public class PlanarPlaneSubsetCursor<T extends NativeType<T>>
extends AbstractCursorInt<T>
implements PlanarImg.PlanarContainerSampler {
    private final T type;
    private final Index typeIndex;
    private final PlanarImg<T, ?> container;
    private final int sliceIndex;
    private final int planeSize;
    private final int lastPlaneIndex;

    protected PlanarPlaneSubsetCursor(PlanarPlaneSubsetCursor<T> cursor) {
        super(cursor.numDimensions());
        this.container = cursor.container;
        this.type = this.container.createLinkedType();
        this.typeIndex = this.type.index();
        this.sliceIndex = cursor.sliceIndex;
        this.planeSize = cursor.planeSize;
        this.lastPlaneIndex = cursor.lastPlaneIndex;
        this.type.updateContainer(this);
        this.typeIndex.set(cursor.typeIndex.get());
    }

    public PlanarPlaneSubsetCursor(PlanarImg<T, ?> container, Interval interval) {
        super(container.numDimensions());
        this.type = container.createLinkedType();
        this.typeIndex = this.type.index();
        this.container = container;
        this.planeSize = (this.n > 1 ? (int)interval.dimension(1) : 1) * (int)interval.dimension(0);
        this.lastPlaneIndex = this.planeSize - 1;
        this.sliceIndex = (int)(this.offset(interval) / (long)this.planeSize);
        this.reset();
    }

    @Override
    public final int getCurrentSliceIndex() {
        return this.sliceIndex;
    }

    @Override
    public final T get() {
        return this.type;
    }

    @Override
    public PlanarPlaneSubsetCursor<T> copy() {
        return new PlanarPlaneSubsetCursor<T>(this);
    }

    @Override
    public final boolean hasNext() {
        return this.typeIndex.get() < this.lastPlaneIndex;
    }

    @Override
    public final void fwd() {
        this.typeIndex.inc();
    }

    @Override
    public final void jumpFwd(long steps) {
        this.typeIndex.inc((int)steps);
    }

    @Override
    public final void reset() {
        this.typeIndex.set(-1);
        this.type.updateContainer(this);
    }

    @Override
    public String toString() {
        return this.type.toString();
    }

    @Override
    public final void localize(int[] position) {
        this.container.indexToGlobalPosition(this.sliceIndex, this.typeIndex.get(), position);
    }

    @Override
    public final int getIntPosition(int dim) {
        return this.container.indexToGlobalPosition(this.sliceIndex, this.typeIndex.get(), dim);
    }

    private long offset(Interval interval) {
        int maxDim = this.numDimensions() - 1;
        long i = interval.min(maxDim);
        for (int d = maxDim - 1; d >= 0; --d) {
            i = i * this.container.dimension(d) + interval.min(d);
        }
        return i;
    }
}

