/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.planar;

import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.planar.PlanarImg;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class PlanarImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    public PlanarImgFactory(T type) {
        super(type);
    }

    @Override
    public PlanarImg<T, ?> create(long ... dimensions) {
        PlanarImg<NativeType, ?> img = this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
        return img;
    }

    @Override
    public PlanarImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public PlanarImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    private <A extends ArrayDataAccess<A>> PlanarImg<T, ?> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        Dimensions.verify(dimensions);
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        PlanarImg<T, A> img = new PlanarImg<T, A>(ArrayDataAccessFactory.get(typeFactory), dimensions, entitiesPerPixel);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new PlanarImgFactory<NativeType>((NativeType)type);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    @Deprecated
    public PlanarImgFactory() {
    }

    @Override
    @Deprecated
    public PlanarImg<T, ?> create(long[] dimensions, T type) {
        this.cache(type);
        PlanarImg<T, ?> img = this.create(dimensions, type, type.getNativeTypeFactory());
        return img;
    }
}

