/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.util.function.Consumer;
import net.imglib2.Cursor;
import net.imglib2.IterableInterval;
import net.imglib2.Positionable;
import net.imglib2.RealPositionable;
import net.imglib2.img.cell.AbstractCellImg;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.stream.LocalizableSpliterator;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

class CellSpliterator<T extends NativeType<T>, C extends Cell<?>>
implements LocalizableSpliterator<T> {
    private final AbstractCellImg<T, ?, C, ?> img;
    private final CellGrid grid;
    private final T type;
    private final Index index;
    private final CursorOnCells<C> currentCell;
    private int lastIndexInCurrentCell;
    private final long lastCell;
    private final int lastIndexInLastCell;
    private final long[] tmpIndices;
    private final long[] tmp;

    CellSpliterator(AbstractCellImg<T, ?, C, ?> img, long origin, long fence) {
        this.img = img;
        this.grid = img.getCellGrid();
        this.type = img.createLinkedType();
        this.index = this.type.index();
        this.currentCell = new CursorOnCells(((IterableInterval)img.getCells()).cursor());
        this.tmpIndices = new long[2];
        this.grid.getCellAndPixelIndices(fence - 1L, this.tmpIndices);
        this.lastCell = this.tmpIndices[0];
        this.lastIndexInLastCell = (int)this.tmpIndices[1];
        this.jumpBefore(origin);
        this.tmp = new long[img.numDimensions()];
    }

    private CellSpliterator(CellSpliterator<T, C> o) {
        this.img = o.img;
        this.grid = o.grid;
        this.type = o.type.duplicateTypeOnSameNativeImg();
        this.index = this.type.index();
        this.index.set(o.index.get());
        this.currentCell = o.currentCell.copy();
        this.lastCell = o.lastCell;
        this.lastIndexInLastCell = o.lastIndexInLastCell;
        this.lastIndexInCurrentCell = o.lastIndexInCurrentCell;
        this.tmp = new long[o.tmp.length];
        this.tmpIndices = new long[2];
        this.type.updateContainer(this.currentCell);
    }

    private void jumpBefore(long i) {
        this.grid.getCellAndPixelIndices(i, this.tmpIndices);
        this.currentCell.setIndex(this.tmpIndices[0]);
        this.cellUpdated();
        int indexInCell = (int)this.tmpIndices[1];
        this.index.set(indexInCell - 1);
    }

    private void cellUpdated() {
        boolean isLastCell = this.currentCell.index() == this.lastCell;
        this.lastIndexInCurrentCell = isLastCell ? this.lastIndexInLastCell : (int)(((Cell)this.currentCell.getCell()).size() - 1L);
        this.type.updateContainer(this.currentCell);
    }

    @Override
    public boolean tryAdvance(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        if (this.index.get() < this.lastIndexInCurrentCell) {
            this.index.inc();
            action.accept(this.type);
            return true;
        }
        if (this.currentCell.index() < this.lastCell) {
            this.currentCell.fwd();
            this.cellUpdated();
            this.index.set(0);
            action.accept(this.type);
            return true;
        }
        return false;
    }

    @Override
    public void forEachRemaining(Consumer<? super T> action) {
        if (action == null) {
            throw new NullPointerException();
        }
        while (this.currentCell.index() < this.lastCell) {
            this.forEachRemainingInCell(action);
            this.currentCell.fwd();
            this.cellUpdated();
            this.index.set(-1);
        }
        this.forEachRemainingInCell(action);
    }

    private void forEachRemainingInCell(Consumer<? super T> action) {
        int len = this.lastIndexInCurrentCell - this.index.get();
        for (int i = 0; i < len; ++i) {
            this.index.inc();
            action.accept(this.type);
        }
    }

    private long globalIndex(long cell, int index) {
        return this.grid.indexOfFirstPixelInCell(cell, this.tmp) + (long)index;
    }

    @Override
    public CellSpliterator<T, C> trySplit() {
        long mid;
        long lo = this.globalIndex(this.currentCell.index(), this.index.get()) + 1L;
        if (lo >= (mid = lo + this.globalIndex(this.lastCell, this.lastIndexInLastCell) + 1L >>> 1)) {
            return null;
        }
        CellSpliterator<T, C> prefix = new CellSpliterator<T, C>(this.img, lo, mid);
        this.jumpBefore(mid);
        return prefix;
    }

    @Override
    public long estimateSize() {
        if (this.currentCell.index() == this.lastCell) {
            return this.lastIndexInLastCell - this.index.get();
        }
        return this.globalIndex(this.lastCell, this.lastIndexInLastCell) - this.globalIndex(this.currentCell.index(), this.index.get());
    }

    @Override
    public int characteristics() {
        return 17744;
    }

    @Override
    public CellSpliterator<T, C> copy() {
        return new CellSpliterator<T, C>(this);
    }

    @Override
    public T get() {
        return this.type;
    }

    public String toString() {
        long lo = this.globalIndex(this.currentCell.index(), this.index.get()) + 1L;
        long hi = this.globalIndex(this.lastCell, this.lastIndexInLastCell) + 1L;
        return "lo = " + lo + ", hi = " + hi;
    }

    @Override
    public long getLongPosition(int d) {
        return ((Cell)this.currentCell.getCell()).indexToGlobalPosition(this.index.get(), d);
    }

    @Override
    public void localize(long[] pos) {
        ((Cell)this.currentCell.getCell()).indexToGlobalPosition(this.index.get(), pos);
    }

    @Override
    public int numDimensions() {
        return this.tmp.length;
    }

    @Override
    public void localize(int[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = (int)this.tmp[d];
        }
    }

    @Override
    public void localize(float[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = this.tmp[d];
        }
    }

    @Override
    public void localize(double[] pos) {
        this.localize(this.tmp);
        for (int d = 0; d < this.tmp.length; ++d) {
            pos[d] = this.tmp[d];
        }
    }

    @Override
    public void localize(Positionable position) {
        this.localize(this.tmp);
        position.setPosition(this.tmp);
    }

    @Override
    public void localize(RealPositionable position) {
        this.localize(this.tmp);
        position.setPosition(this.tmp);
    }

    @Override
    public float getFloatPosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public double getDoublePosition(int d) {
        return this.getLongPosition(d);
    }

    @Override
    public int getIntPosition(int d) {
        return (int)this.getLongPosition(d);
    }

    private static class CursorOnCells<C extends Cell<?>>
    implements AbstractCellImg.CellImgSampler<C> {
        private long index;
        private final Cursor<C> delegate;

        CursorOnCells(Cursor<C> delegate) {
            this.delegate = delegate;
            this.index = -1L;
        }

        CursorOnCells(CursorOnCells<C> o) {
            this.delegate = o.delegate.copy();
            this.index = o.index;
        }

        public long index() {
            return this.index;
        }

        public void setIndex(long index) {
            long steps = index - this.index;
            this.index = index;
            if (steps != 0L) {
                this.delegate.jumpFwd(steps);
            }
        }

        @Override
        public C getCell() {
            return (C)((Cell)this.delegate.get());
        }

        public void fwd() {
            ++this.index;
            this.delegate.fwd();
        }

        public CursorOnCells<C> copy() {
            return new CursorOnCells<C>(this);
        }
    }
}

