/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Cursor;
import net.imglib2.Dimensions;
import net.imglib2.exception.IncompatibleTypeException;
import net.imglib2.img.ImgFactory;
import net.imglib2.img.NativeImgFactory;
import net.imglib2.img.basictypeaccess.ArrayDataAccessFactory;
import net.imglib2.img.basictypeaccess.array.ArrayDataAccess;
import net.imglib2.img.cell.Cell;
import net.imglib2.img.cell.CellGrid;
import net.imglib2.img.cell.CellImg;
import net.imglib2.img.list.ListImg;
import net.imglib2.img.list.ListLocalizingCursor;
import net.imglib2.type.NativeType;
import net.imglib2.type.NativeTypeFactory;
import net.imglib2.util.Fraction;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;

public class CellImgFactory<T extends NativeType<T>>
extends NativeImgFactory<T> {
    private final int[] defaultCellDimensions;

    public CellImgFactory(T type) {
        this(type, 10);
    }

    public CellImgFactory(T type, int ... cellDimensions) {
        super(type);
        this.defaultCellDimensions = (int[])Dimensions.verify(cellDimensions).clone();
    }

    public static int[] getCellDimensions(int[] defaultCellDimensions, int n, Fraction entitiesPerPixel) throws IllegalArgumentException {
        int[] cellDimensions = new int[n];
        int max = defaultCellDimensions.length - 1;
        for (int i = 0; i < n; ++i) {
            cellDimensions[i] = defaultCellDimensions[i < max ? i : max];
        }
        long numEntities = entitiesPerPixel.mulCeil(Intervals.numElements(cellDimensions));
        if (numEntities > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("Number of entities in cell too large. Use smaller cell size.");
        }
        return cellDimensions;
    }

    @Override
    public CellImg<T, ?> create(long ... dimensions) {
        CellImg<NativeType, ?> img = this.create(dimensions, (NativeType)this.type(), ((NativeType)this.type()).getNativeTypeFactory());
        return img;
    }

    @Override
    public CellImg<T, ?> create(Dimensions dimensions) {
        return this.create(Intervals.dimensionsAsLongArray(dimensions));
    }

    @Override
    public CellImg<T, ?> create(int[] dimensions) {
        return this.create(Util.int2long(dimensions));
    }

    private <A extends ArrayDataAccess<A>> CellImg<T, A> create(long[] dimensions, T type, NativeTypeFactory<T, A> typeFactory) {
        Dimensions.verify(dimensions);
        int n = dimensions.length;
        Fraction entitiesPerPixel = type.getEntitiesPerPixel();
        int[] cellDimensions = CellImgFactory.getCellDimensions(this.defaultCellDimensions, n, entitiesPerPixel);
        CellGrid grid = new CellGrid(dimensions, cellDimensions);
        long[] gridDimensions = new long[grid.numDimensions()];
        grid.gridDimensions(gridDimensions);
        Cell<Object> cellType = new Cell<Object>(new int[]{1}, new long[]{1L}, null);
        ListImg cells = new ListImg(gridDimensions, cellType);
        long[] cellGridPosition = new long[n];
        long[] cellMin = new long[n];
        int[] cellDims = new int[n];
        Cursor cellCursor = cells.localizingCursor();
        while (((ListLocalizingCursor)cellCursor).hasNext()) {
            ((ListLocalizingCursor)cellCursor).fwd();
            ((AbstractLocalizableInt)((Object)cellCursor)).localize(cellGridPosition);
            grid.getCellDimensions(cellGridPosition, cellMin, cellDims);
            ArrayDataAccess data = (ArrayDataAccess)ArrayDataAccessFactory.get(typeFactory).createArray((int)entitiesPerPixel.mulCeil(Intervals.numElements(cellDims)));
            ((ListLocalizingCursor)cellCursor).set(new Cell<ArrayDataAccess>(cellDims, cellMin, data));
        }
        CellImg img = new CellImg(this, grid, cells, entitiesPerPixel);
        img.setLinkedType(typeFactory.createLinkedType(img));
        return img;
    }

    @Override
    public <S> ImgFactory<S> imgFactory(S type) throws IncompatibleTypeException {
        if (NativeType.class.isInstance(type)) {
            return new CellImgFactory<NativeType>((NativeType)type, this.defaultCellDimensions);
        }
        throw new IncompatibleTypeException(this, type.getClass().getCanonicalName() + " does not implement NativeType.");
    }

    @Deprecated
    public CellImgFactory() {
        this(10);
    }

    @Deprecated
    public CellImgFactory(int ... cellDimensions) {
        this.defaultCellDimensions = (int[])Dimensions.verify(cellDimensions).clone();
    }

    @Override
    @Deprecated
    public CellImg<T, ?> create(long[] dimensions, T type) {
        this.cache(type);
        CellImg<T, ?> img = this.create(dimensions, type, type.getNativeTypeFactory());
        return img;
    }

    @Deprecated
    public static void verifyDimensions(int[] dimensions) throws IllegalArgumentException {
        Dimensions.verify(dimensions);
    }

    @Deprecated
    public static void verifyDimensions(long[] dimensions) throws IllegalArgumentException {
        Dimensions.verify(dimensions);
    }
}

