/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.cell;

import java.util.Arrays;
import net.imglib2.Cursor;
import net.imglib2.FinalInterval;
import net.imglib2.FlatIterationOrder;
import net.imglib2.Interval;
import net.imglib2.IterableInterval;
import net.imglib2.Localizable;
import net.imglib2.Point;
import net.imglib2.Positionable;
import net.imglib2.RandomAccess;
import net.imglib2.RandomAccessibleInterval;
import net.imglib2.util.IntervalIndexer;
import net.imglib2.util.Intervals;
import net.imglib2.util.Util;
import net.imglib2.view.RandomAccessibleIntervalCursor;

public class CellGrid {
    private final int n;
    private final long[] dimensions;
    private final long[] steps;
    private final int[] cellDimensions;
    private final long[] numCells;
    private final int[] borderSize;
    private final int hashcode;
    private final CellIntervals cellIntervals;

    public CellGrid(long[] dimensions, int[] cellDimensions) {
        this.n = dimensions.length;
        this.dimensions = (long[])dimensions.clone();
        this.cellDimensions = (int[])cellDimensions.clone();
        this.steps = new long[this.n];
        IntervalIndexer.createAllocationSteps(dimensions, this.steps);
        this.numCells = new long[this.n];
        this.borderSize = new int[this.n];
        for (int d = 0; d < this.n; ++d) {
            this.numCells[d] = (dimensions[d] - 1L) / (long)cellDimensions[d] + 1L;
            this.borderSize[d] = (int)(dimensions[d] - (this.numCells[d] - 1L) * (long)cellDimensions[d]);
        }
        this.hashcode = 31 * Arrays.hashCode(dimensions) + Arrays.hashCode(cellDimensions);
        this.cellIntervals = new CellIntervals();
    }

    public CellGrid(CellGrid grid) {
        this.n = grid.n;
        this.dimensions = (long[])grid.dimensions.clone();
        this.steps = (long[])grid.steps.clone();
        this.cellDimensions = (int[])grid.cellDimensions.clone();
        this.numCells = (long[])grid.numCells.clone();
        this.borderSize = (int[])grid.borderSize.clone();
        this.hashcode = grid.hashcode;
        this.cellIntervals = new CellIntervals();
    }

    public int numDimensions() {
        return this.n;
    }

    public long[] getGridDimensions() {
        return (long[])this.numCells.clone();
    }

    public void gridDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.numCells[i];
        }
    }

    public long gridDimension(int d) {
        return this.numCells[d];
    }

    public long[] getImgDimensions() {
        return (long[])this.dimensions.clone();
    }

    public void imgDimensions(long[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.dimensions[i];
        }
    }

    public long imgDimension(int d) {
        return this.dimensions[d];
    }

    public int[] getCellDimensions() {
        return (int[])this.cellDimensions.clone();
    }

    public void cellDimensions(int[] dimensions) {
        for (int i = 0; i < this.n; ++i) {
            dimensions[i] = this.cellDimensions[i];
        }
    }

    public int cellDimension(int d) {
        return this.cellDimensions[d];
    }

    public void getCellDimensions(long index, long[] cellMin, int[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            long j = index / this.numCells[d];
            long gridPos = index - j * this.numCells[d];
            index = j;
            cellDims[d] = gridPos == this.numCells[d] - 1L ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = gridPos * (long)this.cellDimensions[d];
        }
    }

    public void getCellDimensions(long[] cellGridPosition, long[] cellMin, int[] cellDims) {
        for (int d = 0; d < this.n; ++d) {
            cellDims[d] = cellGridPosition[d] + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = cellGridPosition[d] * (long)this.cellDimensions[d];
        }
    }

    public void getCellInterval(long[] cellGridPosition, long[] cellMin, long[] cellMax) {
        for (int d = 0; d < this.n; ++d) {
            long gridPos = cellGridPosition[d];
            int cellDim = gridPos + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = gridPos * (long)this.cellDimensions[d];
            cellMax[d] = cellMin[d] + (long)cellDim - 1L;
        }
    }

    public int getCellDimension(int d, long cellGridPosition) {
        return cellGridPosition + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
    }

    public long getCellMin(int d, long cellGridPosition) {
        return cellGridPosition * (long)this.cellDimensions[d];
    }

    public void getCellGridPositionFlat(long index, long[] cellGridPosition) {
        IntervalIndexer.indexToPosition(index, this.numCells, cellGridPosition);
    }

    public long getCellGridIndexFlat(long[] cellGridPosition) {
        return IntervalIndexer.positionToIndex(cellGridPosition, this.numCells);
    }

    public void getCellPosition(long[] position, long[] cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos[d] = position[d] / (long)this.cellDimensions[d];
        }
    }

    public void getCellPosition(long[] position, Positionable cellPos) {
        for (int d = 0; d < this.n; ++d) {
            cellPos.setPosition(position[d] / (long)this.cellDimensions[d], d);
        }
    }

    void getCellAndPixelIndices(long index, long[] indices) {
        long cellIndex = 0L;
        long pcdims = 1L;
        for (int d = this.n - 1; d >= 0; --d) {
            long psize = this.steps[d] * (long)this.cellDimensions[d] * pcdims;
            long pos = index / psize;
            index -= pos * psize;
            cellIndex = cellIndex * this.numCells[d] + pos;
            pcdims *= (long)this.getCellDimension(d, pos);
        }
        indices[0] = cellIndex;
        indices[1] = index;
    }

    void getIndicesFromGridPosition(long[] cellGridPosition, long[] indices) {
        long cellIndex = 0L;
        long index = 0L;
        long pcdims = 1L;
        for (int d = this.n - 1; d >= 0; --d) {
            long gridpos = cellGridPosition[d];
            index += this.steps[d] * (long)this.cellDimensions[d] * gridpos * pcdims;
            pcdims *= (long)this.getCellDimension(d, gridpos);
            cellIndex = cellIndex * this.numCells[d] + gridpos;
        }
        indices[0] = cellIndex;
        indices[1] = index;
    }

    void getIndicesFromGridPosition(Localizable cellGridPosition, long[] indices) {
        long cellIndex = 0L;
        long index = 0L;
        long pcdims = 1L;
        for (int d = this.n - 1; d >= 0; --d) {
            long gridpos = cellGridPosition.getLongPosition(d);
            index += this.steps[d] * (long)this.cellDimensions[d] * gridpos * pcdims;
            pcdims *= (long)this.getCellDimension(d, gridpos);
            cellIndex = cellIndex * this.numCells[d] + gridpos;
        }
        indices[0] = cellIndex;
        indices[1] = index;
    }

    long indexOfFirstPixelInCell(long cellGridIndex) {
        return this.indexOfFirstPixelInCell(cellGridIndex, new long[this.n]);
    }

    long indexOfFirstPixelInCell(long cellGridIndex, long[] tmp) {
        IntervalIndexer.indexToPosition(cellGridIndex, this.numCells, tmp);
        return this.indexOfFirstPixelInCell(tmp);
    }

    long indexOfFirstPixelInCell(long[] cellGridPosition) {
        long index = 0L;
        long pcdims = 1L;
        for (int d = this.n - 1; d >= 0; --d) {
            long gridpos = cellGridPosition[d];
            index += this.steps[d] * (long)this.cellDimensions[d] * gridpos * pcdims;
            pcdims *= (long)this.getCellDimension(d, gridpos);
        }
        return index;
    }

    long indexOfFirstPixelInCell(Localizable cellGridPosition) {
        long index = 0L;
        long pcdims = 1L;
        for (int d = this.n - 1; d >= 0; --d) {
            long gridpos = cellGridPosition.getLongPosition(d);
            index += this.steps[d] * (long)this.cellDimensions[d] * gridpos * pcdims;
            pcdims *= (long)this.getCellDimension(d, gridpos);
        }
        return index;
    }

    int getCellCoordinates(long[] position, int[] cellSteps, long[] cellMin, long[] cellMax) {
        int steps = 1;
        int i = 0;
        for (int d = 0; d < this.n; ++d) {
            long gridPos = position[d] / (long)this.cellDimensions[d];
            int cellDim = gridPos + 1L == this.numCells[d] ? this.borderSize[d] : this.cellDimensions[d];
            cellMin[d] = gridPos * (long)this.cellDimensions[d];
            cellMax[d] = cellMin[d] + (long)cellDim - 1L;
            cellSteps[d] = steps;
            i = (int)((long)i + (long)steps * (position[d] - cellMin[d]));
            steps *= cellDim;
        }
        return i;
    }

    public int hashCode() {
        return this.hashcode;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CellGrid) {
            CellGrid other = (CellGrid)obj;
            return Arrays.equals(this.dimensions, other.dimensions) && Arrays.equals(this.cellDimensions, other.cellDimensions);
        }
        return false;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "( dims = " + Util.printCoordinates(this.dimensions) + ", cellDims = " + Util.printCoordinates(this.cellDimensions) + " )";
    }

    public CellIntervals cellIntervals() {
        return this.cellIntervals;
    }

    public class CellIntervals
    implements RandomAccessibleInterval<Interval>,
    IterableInterval<Interval> {
        private final long size;

        public CellIntervals() {
            this.size = Intervals.numElements(CellGrid.this.numCells);
        }

        @Override
        public int numDimensions() {
            return CellGrid.this.n;
        }

        @Override
        public long min(int d) {
            return 0L;
        }

        @Override
        public long max(int d) {
            return CellGrid.this.numCells[d] - 1L;
        }

        @Override
        public RandomAccess<Interval> randomAccess() {
            return new CellIntervalsRA();
        }

        @Override
        public RandomAccess<Interval> randomAccess(Interval interval) {
            return this.randomAccess();
        }

        @Override
        public Cursor<Interval> cursor() {
            return new RandomAccessibleIntervalCursor<Interval>(this);
        }

        @Override
        public Cursor<Interval> localizingCursor() {
            return this.cursor();
        }

        @Override
        public long size() {
            return this.size;
        }

        @Override
        public FlatIterationOrder iterationOrder() {
            return new FlatIterationOrder(this);
        }
    }

    private class CellIntervalsRA
    extends Point
    implements RandomAccess<Interval> {
        private final long[] min;
        private final long[] max;
        private final Interval interval;

        @Override
        public Interval get() {
            CellGrid.this.getCellInterval(this.position, this.min, this.max);
            return this.interval;
        }

        CellIntervalsRA() {
            super(CellGrid.this.n);
            this.min = new long[CellGrid.this.n];
            this.max = new long[CellGrid.this.n];
            this.interval = FinalInterval.wrap(this.min, this.max);
        }

        CellIntervalsRA(CellIntervalsRA ra) {
            super(ra);
            this.min = new long[CellGrid.this.n];
            this.max = new long[CellGrid.this.n];
            this.interval = FinalInterval.wrap(this.min, this.max);
        }

        @Override
        public RandomAccess<Interval> copy() {
            return new CellIntervalsRA(this);
        }
    }
}

