/*
 * Decompiled with CFR 0.152.
 */
package net.imglib2.img.array;

import net.imglib2.AbstractLocalizableInt;
import net.imglib2.Localizable;
import net.imglib2.RandomAccess;
import net.imglib2.img.array.ArrayImg;
import net.imglib2.type.Index;
import net.imglib2.type.NativeType;

public class ArrayRandomAccess<T extends NativeType<T>>
extends AbstractLocalizableInt
implements RandomAccess<T> {
    protected final T type;
    private final Index typeIndex;
    final ArrayImg<T, ?> img;

    protected ArrayRandomAccess(ArrayRandomAccess<T> randomAccess) {
        super(randomAccess.numDimensions());
        this.img = randomAccess.img;
        this.type = this.img.createLinkedType();
        this.typeIndex = this.type.index();
        this.typeIndex.set(0);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = randomAccess.position[d];
            this.typeIndex.inc(this.position[d] * this.img.steps[d]);
        }
        this.type.updateContainer(this);
    }

    public ArrayRandomAccess(ArrayImg<T, ?> container) {
        super(container.numDimensions());
        this.img = container;
        this.type = container.createLinkedType();
        this.typeIndex = this.type.index();
        this.typeIndex.set(0);
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = 0;
        }
        this.type.updateContainer(this);
    }

    @Override
    public T get() {
        return this.type;
    }

    @Override
    public void fwd(int d) {
        this.typeIndex.inc(this.img.steps[d]);
        int n = d;
        this.position[n] = this.position[n] + 1;
    }

    @Override
    public void bck(int d) {
        this.typeIndex.dec(this.img.steps[d]);
        int n = d;
        this.position[n] = this.position[n] - 1;
    }

    @Override
    public void move(int distance, int d) {
        this.typeIndex.inc(this.img.steps[d] * distance);
        int n = d;
        this.position[n] = this.position[n] + distance;
    }

    @Override
    public void move(long distance, int d) {
        this.typeIndex.inc(this.img.steps[d] * (int)distance);
        int n = d;
        this.position[n] = (int)((long)this.position[n] + distance);
    }

    @Override
    public void move(Localizable localizable) {
        int move = 0;
        for (int d = 0; d < this.n; ++d) {
            int distance = localizable.getIntPosition(d);
            int n = d;
            this.position[n] = this.position[n] + distance;
            move += distance * this.img.steps[d];
        }
        this.typeIndex.inc(move);
    }

    @Override
    public void move(int[] distance) {
        int move = 0;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = this.position[n] + distance[d];
            move += distance[d] * this.img.steps[d];
        }
        this.typeIndex.inc(move);
    }

    @Override
    public void move(long[] distance) {
        int move = 0;
        for (int d = 0; d < this.n; ++d) {
            int n = d;
            this.position[n] = (int)((long)this.position[n] + distance[d]);
            move = (int)((long)move + distance[d] * (long)this.img.steps[d]);
        }
        this.typeIndex.inc(move);
    }

    @Override
    public void setPosition(Localizable localizable) {
        int i = 0;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = localizable.getIntPosition(d);
            i += this.position[d] * this.img.steps[d];
        }
        this.typeIndex.set(i);
    }

    @Override
    public void setPosition(int[] pos) {
        int i = 0;
        for (int d = 0; d < this.n; ++d) {
            this.position[d] = pos[d];
            i += pos[d] * this.img.steps[d];
        }
        this.typeIndex.set(i);
    }

    @Override
    public void setPosition(long[] pos) {
        int i = 0;
        for (int d = 0; d < this.n; ++d) {
            int p;
            this.position[d] = p = (int)pos[d];
            i += p * this.img.steps[d];
        }
        this.typeIndex.set(i);
    }

    @Override
    public void setPosition(int pos, int d) {
        this.typeIndex.inc((pos - this.position[d]) * this.img.steps[d]);
        this.position[d] = pos;
    }

    @Override
    public void setPosition(long pos, int d) {
        this.typeIndex.inc(((int)pos - this.position[d]) * this.img.steps[d]);
        this.position[d] = (int)pos;
    }

    @Override
    public ArrayRandomAccess<T> copy() {
        return new ArrayRandomAccess<T>(this);
    }

    public void fwdDim0() {
        this.typeIndex.inc();
        this.position[0] = this.position[0] + 1;
    }

    public void bckDim0() {
        this.typeIndex.dec();
        this.position[0] = this.position[0] - 1;
    }

    public void moveDim0(int distance) {
        this.typeIndex.inc(distance);
        this.position[0] = this.position[0] + distance;
    }

    public void move(long distance) {
        this.typeIndex.inc((int)distance);
        this.position[0] = (int)((long)this.position[0] + distance);
    }

    public void setPositionDim0(int pos) {
        this.typeIndex.set(pos);
        this.position[0] = pos;
    }

    public void setPositionDim0(long pos) {
        this.typeIndex.set((int)pos);
        this.position[0] = (int)pos;
    }
}

